/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.parameter;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AbstractParameter;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;

public class TextParameter
extends AbstractParameter {
    private String text;
    private int priority;

    public TextParameter(String string, String string2) {
        this(string, null, string2, null, "");
    }

    public TextParameter(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, "");
    }

    public TextParameter(String string, String string2, String string3, String string4, String string5) {
        super(string, string2, string4, string5);
        this.text = string3;
    }

    @Override
    public String getNodeString() {
        return this.text;
    }

    public String getText() {
        return this.text;
    }

    public float[] getValues() {
        String[] stringArray = this.text.split(";");
        float[] fArray = new float[stringArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = RtDataFormat.toNumberFloat(stringArray[i]);
            if (!Float.isNaN(fArray[i])) continue;
            throw new RuntimeException(String.format("Illegal parameter (%s) value: %s", this.getName(), this.text));
        }
        return fArray;
    }

    public int[] getGridInt() {
        String[] stringArray = this.text.split("x");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = RtDataFormat.toNumberInt(stringArray[i]);
        }
        return nArray;
    }

    public int[] getValuesInt() {
        float[] fArray = this.getValues();
        int[] nArray = new int[fArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)fArray[i];
        }
        return nArray;
    }

    @Override
    public String getValueStr() {
        return this.text;
    }

    @Override
    public void parse(Node node) {
        this.text = node.getTextContent();
    }

    @Override
    public Element save(Element element) {
        Element element2 = XmlParserHelper.addElement(element, "param");
        XmlParserHelper.setAttribute((Node)element2, "name", this.getSerializeAsName());
        element2.setTextContent(this.getValueStr());
        return element2;
    }

    public void setText(String string) {
        this.text = string;
    }

    @Override
    public void setValueStr(String string) {
        this.text = string;
    }

    public void clearValue() {
        this.text = null;
    }

    @Override
    public boolean updateParameterRecursive() {
        return true;
    }

    @Override
    public boolean updateParameterRecursive(FunctionTreeNode functionTreeNode, FunctionTreeNode functionTreeNode2) {
        return true;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int n) {
        this.priority = n;
    }
}

