/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.parameter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.backend.realtime.module.ContinuumRemovalRtModule;
import se.prediktera.breeze.backend.realtime.module.DerivateRtModule;
import se.prediktera.breeze.backend.realtime.module.LogarithmRtModule;
import se.prediktera.breeze.backend.realtime.module.SNVRtModule;
import se.prediktera.breeze.backend.realtime.module.SavitzkyGolayRtModule;
import se.prediktera.breeze.common.realtime.RtModule;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.TransformationPanel;
import se.prediktera.map.main.script.ScriptHelper;

public class TransformationParameter
extends TextParameter {
    private final boolean onlySmoothing;

    public TransformationParameter() {
        this(false);
    }

    public TransformationParameter(boolean bl) {
        super("transformations", "Pretreatments", "", "Apply pretreatments to band values before expression");
        this.onlySmoothing = bl;
    }

    public HashMap<Model.Transformation, ModelProperties.TransformationProperties> getTransformationHashMap() {
        HashMap<Model.Transformation, ModelProperties.TransformationProperties> hashMap = new HashMap<Model.Transformation, ModelProperties.TransformationProperties>();
        for (ModelProperties.TransformationProperties transformationProperties : this.getTransformations()) {
            hashMap.put(transformationProperties.getTransformation(), transformationProperties);
        }
        return hashMap;
    }

    public String getShortDescriptions() {
        StringBuffer stringBuffer = new StringBuffer();
        for (ModelProperties.TransformationProperties transformationProperties : this.getTransformations()) {
            if (!transformationProperties.enabled()) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(transformationProperties.getTransformation().getXmlName());
        }
        return stringBuffer.toString();
    }

    public List<ModelProperties.TransformationProperties> getTransformations() {
        return TransformationParameter.getTransformations(this.getValueStr());
    }

    public List<RtModule> getTransformationModules(int n) {
        return TransformationParameter.getTransformationModules(this.getValueStr(), n);
    }

    public static List<RtModule> getTransformationModules(String string, int n) {
        ArrayList<RtModule> arrayList = new ArrayList<RtModule>();
        if (string != null && !string.isEmpty()) {
            for (ModelProperties.TransformationProperties transformationProperties : TransformationParameter.getTransformations(string)) {
                if (!transformationProperties.enabled()) continue;
                arrayList.add(TransformationParameter.createModule(transformationProperties, n));
            }
        }
        return arrayList;
    }

    public static List<ModelProperties.TransformationProperties> getTransformations(String string) {
        String[] stringArray = string.split(",");
        ArrayList<ModelProperties.TransformationProperties> arrayList = new ArrayList<ModelProperties.TransformationProperties>();
        for (Model.Transformation transformation : Model.Transformation.values()) {
            String string2 = TransformationParameter.getValue(stringArray, transformation);
            if (string2 != null) {
                String string3 = string2.substring(transformation.name().length());
                arrayList.add(new ModelProperties.TransformationProperties(transformation, true, string3));
                continue;
            }
            arrayList.add(new ModelProperties.TransformationProperties(transformation, false));
        }
        return arrayList;
    }

    public static float[] getData(List<RtModule> list, float[] fArray) {
        if (list != null && !list.isEmpty() && fArray != null) {
            FloatMatrix floatMatrix = new FloatMatrix((float[])fArray.clone());
            for (RtModule rtModule : list) {
                rtModule.apply(floatMatrix, 0);
            }
            return floatMatrix.data;
        }
        return fArray;
    }

    private static String getValue(String[] stringArray, Model.Transformation transformation) {
        for (String string : stringArray) {
            if (!string.startsWith(transformation.name())) continue;
            return string;
        }
        return null;
    }

    public void setTransformations(List<ModelProperties.TransformationProperties> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ModelProperties.TransformationProperties transformationProperties : list) {
            if (!transformationProperties.enabled()) continue;
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append(",");
            }
            stringBuilder.append(transformationProperties.getTransformation().name());
            if (transformationProperties.getProperties().isEmpty()) continue;
            stringBuilder.append(transformationProperties.getPropertyString());
        }
        this.setValueStr(stringBuilder.toString());
    }

    public boolean onlySmoothing() {
        return this.onlySmoothing;
    }

    public static RtModule createModule(ModelProperties.TransformationProperties transformationProperties, int n) {
        Model.Transformation transformation = transformationProperties.getTransformation();
        Properties properties = transformationProperties.getProperties();
        return switch (transformationProperties.getTransformation()) {
            case Model.Transformation.Center, Model.Transformation.UvScale -> throw new RuntimeException("Transformation  " + String.valueOf((Object)transformation) + " not applicable");
            case Model.Transformation.ContinuumRemoval -> new ContinuumRemovalRtModule(ScriptHelper.getPropertyInt((Properties)properties, (String)"leftoffset"), ScriptHelper.getPropertyInt((Properties)properties, (String)"rightoffset"));
            case Model.Transformation.Derivative -> new DerivateRtModule(ScriptHelper.getPropertyInt((Properties)properties, (String)"type"), n);
            case Model.Transformation.Logarithm -> new LogarithmRtModule();
            case Model.Transformation.SNV -> new SNVRtModule();
            case Model.Transformation.SavitzkyGolay -> new SavitzkyGolayRtModule(ScriptHelper.getPropertyInt((Properties)properties, (String)"leftpoints"), ScriptHelper.getPropertyInt((Properties)properties, (String)"rightpoints"), ScriptHelper.getPropertyInt((Properties)properties, (String)"polynomialorder"), ScriptHelper.getPropertyInt((Properties)properties, (String)"derivativeorder"), n);
            default -> throw new RuntimeException("No such transformation " + String.valueOf((Object)transformation));
        };
    }

    public static class SelectTransformationsPanel
    extends AbstractBreezeCustomPanel {
        private final TransformationPanel transformationPanel;

        public SelectTransformationsPanel(HashMap<Model.Transformation, ModelProperties.TransformationProperties> hashMap, int n, TransformationParameter transformationParameter) {
            this.setLayout(new GridBagLayout());
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            this.setBackground(breezeTheme.getDialogBackground());
            this.transformationPanel = new TransformationPanel(false, false, transformationParameter.onlySmoothing());
            this.transformationPanel.setValues(hashMap, n);
            BreezeScrollPane breezeScrollPane = new BreezeScrollPane(this.transformationPanel);
            this.transformationPanel.setOpaque(true);
            this.transformationPanel.setBackground(breezeTheme.getDialogBackground());
            this.add((Component)breezeScrollPane, GridBagHelper.createLast(0, new Insets(24, 0, 0, 0)));
            this.setPreferredSize(new Dimension(600, 600));
        }

        @Override
        public boolean usePreferredSize() {
            return true;
        }

        @Override
        public Object getResult() {
            return this.transformationPanel.getTransformations();
        }
    }
}

