/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.spatial;

import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;

public class AxisPercentageDescriptor
extends AbstractDescriptor {
    public AxisPercentageDescriptor(AbstractDescriptorInfo abstractDescriptorInfo) {
        super(abstractDescriptorInfo);
        this.addOutput("value");
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        return RtDataFormat.toPercent(f, false);
    }

    @Override
    public String getUnit(FunctionTreeNode functionTreeNode, int n) {
        return "%";
    }

    @Override
    public MinMax getMinMax(int n) {
        return MinMax.Percent;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return "Axis percentage";
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "axispercentage";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new AxisPercentageDescriptor(this);
        }

        public String toString() {
            return "AxisPercentageDescriptor";
        }

        @Override
        public String getShortDescription() {
            return "Axis percentage";
        }

        @Override
        public String getDescription() {
            return "Center position percentage along axis";
        }

        @Override
        public String getHelp() {
            return "axis-percentage-descriptor";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Spatial;
        }
    }
}

