/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.spatial;

import java.awt.Rectangle;
import java.util.List;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.RtFramesAndRefs;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.realtime.descriptor.spatial.DistributionBalanceAngleCalculator;
import se.prediktera.breeze.common.realtime.frame.RtFrameStackList;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.image.RtSpatialObject;

public class ChildDistributionDescriptor
extends AbstractDescriptor {
    private final ChildBalanceAngleCalculator calculator = new ChildBalanceAngleCalculator();
    private final TextParameter gridParameter = new TextParameter("grid", "Grid", "3x3", "Columns x Rows");

    public ChildDistributionDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addParameter(this.gridParameter);
        this.addOutput("distribution");
        this.addOutput("balance");
        this.addOutput("direction");
    }

    @Override
    public float[] perform(BreezeProgress breezeProgress, FunctionTreeNode functionTreeNode, DescriptorInterface descriptorInterface, RtFramesAndRefs rtFramesAndRefs, RtSpatialObject rtSpatialObject) {
        int[] nArray = this.gridParameter.getGridInt();
        BasicSample basicSample = (BasicSample)descriptorInterface;
        List<BasicSample> list = basicSample.getChildList();
        if (list.isEmpty()) {
            return new float[]{1.0f, 1.0f, 0.0f};
        }
        return this.calculator.calculate(breezeProgress, basicSample, rtFramesAndRefs.frames(), rtSpatialObject, nArray, DistributionBalanceAngleCalculator.DistType.MaxDist);
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        if (n == 2) {
            return DistributionBalanceAngleCalculator.formatDirection(f);
        }
        return RtDataFormat.toPercent(f, false);
    }

    @Override
    public String getUnit(FunctionTreeNode functionTreeNode, int n) {
        return n != 2 ? "%" : null;
    }

    @Override
    public MinMax getMinMax(int n) {
        return n != 2 ? new MinMax(0.0f, 1.0f) : null;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return RtDataFormat.initialLetter(this.getOutputString(n));
    }

    private static class ChildBalanceAngleCalculator
    extends DistributionBalanceAngleCalculator {
        private boolean[][] subSampleMatrix;
        private int x;
        private int y;

        private ChildBalanceAngleCalculator() {
        }

        @Override
        protected void prepare(BreezeProgress breezeProgress, BasicSample basicSample, RtFrameStackList rtFrameStackList, RtSpatialObject rtSpatialObject) {
            Rectangle rectangle = rtSpatialObject.getBoundingBox();
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.subSampleMatrix = new boolean[rectangle.width + 1][rectangle.height + 1];
            List<BasicSample> list = basicSample.getChildList();
            for (BasicSample basicSample2 : list) {
                ChildBalanceAngleCalculator.setSubSampleMatrix(basicSample2.getCachedSpatialObject(), this.x, this.y, this.subSampleMatrix);
            }
        }

        private void printIndexMatrix() {
            System.out.println();
            for (int i = 0; i < this.subSampleMatrix[0].length; ++i) {
                for (boolean[] blArray : this.subSampleMatrix) {
                    System.out.print(blArray[i] ? "X" : ".");
                }
                System.out.println();
            }
        }

        @Override
        protected float getNormalizedValue(int n, int n2) {
            return this.subSampleMatrix[n2 - this.x][n - this.y] ? 1.0f : 0.0f;
        }

        private static void setSubSampleMatrix(RtSpatialObject rtSpatialObject, int n, int n2, boolean[][] blArray) {
            rtSpatialObject.forEveryPixel((n3, n4, n5) -> {
                blArray[n3 - n][n4 - n2] = true;
            });
        }
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "dist";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new ChildDistributionDescriptor(this);
        }

        public String toString() {
            return "DistributionSummary";
        }

        @Override
        public String getDescription() {
            return "Distribution of subsamples";
        }

        @Override
        public String getHelp() {
            return "distribution-of-subsamples";
        }
    }
}

