/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.spatial;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.realtime.frame.RtFrameStackList;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.image.RtPixelFloat;
import se.prediktera.breeze.common.util.image.RtSpatialObject;

public abstract class DistributionBalanceAngleCalculator {
    protected abstract void prepare(BreezeProgress var1, BasicSample var2, RtFrameStackList var3, RtSpatialObject var4);

    protected abstract float getNormalizedValue(int var1, int var2);

    public float[] calculate(BreezeProgress breezeProgress, BasicSample basicSample, RtFrameStackList rtFrameStackList, RtSpatialObject rtSpatialObject, int[] nArray, DistType distType) {
        float f;
        Rectangle rectangle = rtSpatialObject.getBoundingBox();
        int n4 = nArray[0];
        int n5 = nArray[1];
        float[] fArray = new float[2];
        int n6 = 0;
        this.prepare(breezeProgress, basicSample, rtFrameStackList, rtSpatialObject);
        RtPixelFloat rtPixelFloat = rtSpatialObject.getCenterPoint().copy();
        rtPixelFloat.x -= (float)rectangle.x;
        rtPixelFloat.y -= (float)rectangle.y;
        float f2 = 0.0f;
        List<GridBucket> list = this.createGridBuckets(rectangle, n4, n5);
        rtSpatialObject.forEveryPixel((n, n2, n3) -> {
            for (GridBucket gridBucket : list) {
                gridBucket.addPixelIfWithinBounds(n, n2);
            }
        });
        for (GridBucket gridBucket : list) {
            gridBucket.calculate(fArray, rtPixelFloat, rectangle);
            f2 = Math.max(gridBucket.getMaxDistSquare(), f2);
            n6 = (int)((float)n6 + gridBucket.getTotalValue());
        }
        if (n6 > 0) {
            fArray[0] = fArray[0] / (float)n6;
            fArray[1] = fArray[1] / (float)n6;
        }
        float f3 = distType.equals((Object)DistType.MaxDist) ? (float)Math.sqrt(f2) : (f = (float)Math.sqrt((double)rtSpatialObject.getArea() / Math.PI));
        float f4 = fArray[0] - rtPixelFloat.x;
        float f5 = fArray[1] - rtPixelFloat.y;
        float f6 = DistributionBalanceAngleCalculator.calculateBalance(f4, f5, f3);
        return new float[]{DistributionBalanceAngleCalculator.calculateDistribution(list), f6, DistributionBalanceAngleCalculator.calculateAngle(f6, f4, f5, DegreeType.Compass)};
    }

    private static float calculateDistribution(List<GridBucket> list) {
        int n = list.size();
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = true;
        for (GridBucket gridBucket : list) {
            double d3 = gridBucket.getAverageValue();
            if (bl) {
                d = d3;
                bl = false;
            } else if (d3 > d) {
                d = d3;
            }
            d2 += d3 - 0.0;
        }
        if ((d2 /= (double)n) <= 0.0) {
            return 1.0f;
        }
        return (float)(d2 / (d - 0.0));
    }

    private static float calculateBalance(float f, float f2, float f3) {
        double d = Math.sqrt(f * f + f2 * f2);
        return (float)(1.0 - d / (double)f3);
    }

    private static float calculateAngle(float f, double d, double d2, DegreeType degreeType) {
        if (f == 1.0f) {
            return 360.0f;
        }
        float f2 = (float)Math.toDegrees(Math.atan2(-d2, d));
        if (degreeType.equals((Object)DegreeType.Compass)) {
            f2 = 90.0f - f2;
        }
        if (f2 < 0.0f) {
            f2 += 360.0f;
        }
        return f2;
    }

    public static String formatDirection(float f) {
        StringBuilder stringBuilder = new StringBuilder();
        if (f < 360.0f) {
            stringBuilder.append((int)f);
            stringBuilder.append("\u00b0");
            stringBuilder.append(" ");
        }
        stringBuilder.append(DistributionBalanceAngleCalculator.toDirection(f, DegreeType.Compass));
        return stringBuilder.toString();
    }

    public static String toDirection(float f, DegreeType degreeType) {
        if (f == 360.0f) {
            return "C";
        }
        double d = 22.5;
        String[] stringArray = degreeType.getDirections();
        int n = 1;
        while (n < stringArray.length) {
            if ((double)f >= d && (double)f < d + 45.0) {
                return stringArray[n];
            }
            ++n;
            d += 45.0;
        }
        return stringArray[0];
    }

    private List<GridBucket> createGridBuckets(Rectangle rectangle, int n, int n2) {
        int[][] nArray = this.splitLength(rectangle.x, rectangle.width, n2);
        int[][] nArray2 = this.splitLength(rectangle.y, rectangle.height, n);
        ArrayList<GridBucket> arrayList = new ArrayList<GridBucket>();
        for (int[] nArray3 : nArray2) {
            for (int[] nArray4 : nArray) {
                arrayList.add(new GridBucket(nArray4[1], nArray3[1], nArray4[0], nArray3[0]));
            }
        }
        return arrayList;
    }

    public int[][] splitLength(int n, int n2, int n3) {
        int[][] nArray = new int[n3][2];
        double d = (double)n2 / (double)n3;
        int n4 = (int)Math.ceil(d);
        double d2 = 0.0;
        int n5 = 0;
        while (n5 < n3) {
            nArray[n5][0] = (int)d2 + n;
            nArray[n5][1] = n4;
            ++n5;
            d2 += d;
        }
        return nArray;
    }

    private class GridBucket {
        private final int xStart;
        private final int xEnd;
        private final int yStart;
        private final int yEnd;
        private final List<Pixel2D> pixels = new ArrayList<Pixel2D>();
        private float totalValue;
        private float averageValue;
        private double maxDistSquare;

        public GridBucket(int n, int n2, int n3, int n4) {
            this.xStart = n3;
            this.xEnd = this.xStart + n;
            this.yStart = n4;
            this.yEnd = this.yStart + n2;
        }

        public void calculate(float[] fArray, RtPixelFloat rtPixelFloat, Rectangle rectangle) {
            if (!this.pixels.isEmpty()) {
                for (Pixel2D pixel2D : this.pixels) {
                    float f = DistributionBalanceAngleCalculator.this.getNormalizedValue(pixel2D.y, pixel2D.x);
                    this.totalValue += f;
                    double d = (double)(pixel2D.x - rectangle.x) + 0.5;
                    double d2 = (double)(pixel2D.y - rectangle.y) + 0.5;
                    fArray[0] = (float)((double)fArray[0] + d * (double)f);
                    fArray[1] = (float)((double)fArray[1] + d2 * (double)f);
                    double d3 = d - (double)rtPixelFloat.x;
                    double d4 = d2 - (double)rtPixelFloat.y;
                    this.maxDistSquare = Math.max(d3 * d3 + d4 * d4, this.maxDistSquare);
                }
                this.averageValue = this.totalValue / (float)this.pixels.size();
            }
        }

        public float getTotalValue() {
            return this.totalValue;
        }

        public float getAverageValue() {
            return this.averageValue;
        }

        public float getMaxDistSquare() {
            return (float)this.maxDistSquare;
        }

        public void addPixelIfWithinBounds(int n, int n2) {
            if (this.within(n, this.xStart, this.xEnd) && this.within(n2, this.yStart, this.yEnd)) {
                this.pixels.add(new Pixel2D(this, n, n2));
            }
        }

        private boolean within(int n, int n2, int n3) {
            return n >= n2 && n < n3;
        }

        public String toString() {
            return "[" + this.xStart + "-" + this.xEnd + "," + this.yStart + "-" + this.yEnd + "] " + this.getAverageValue();
        }

        public class Pixel2D
        implements Cloneable {
            public int x;
            public int y;

            public Pixel2D(GridBucket gridBucket, int n, int n2) {
                this.x = n;
                this.y = n2;
            }

            public String toString() {
                return this.x + "," + this.y;
            }
        }
    }

    public static enum DistType {
        MaxDist,
        Radius;

    }

    public static enum DegreeType {
        Compass("N", "NE", "E", "SE", "S", "SW", "W", "NW"),
        Degree("E", "NE", "N", "NW", "W", "SW", "S", "SE");

        private final String[] directions;

        private DegreeType(String ... stringArray) {
            this.directions = stringArray;
        }

        public String[] getDirections() {
            return this.directions;
        }
    }
}

