/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.spatial;

import java.util.Arrays;
import java.util.List;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BandNamesParameter;
import se.prediktera.breeze.common.util.StringHelper;

public class PixelStatisticsDescriptor
extends AbstractDescriptor {
    public PixelStatisticsDescriptor(AbstractDescriptorInfo abstractDescriptorInfo) {
        super(abstractDescriptorInfo);
        this.addParameter(new BandNamesParameter("band", "Wavelength", 0, null));
        this.addOutput("average");
        this.addOutput("min");
        this.addOutput("max");
        this.addOutput("std");
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return "Pixel - " + StringHelper.formatLabel(this.getOutputName(n));
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "statistics";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new PixelStatisticsDescriptor(this);
        }

        public String toString() {
            return "PixelStatistics";
        }

        @Override
        public String getDescription() {
            return "Statistics of pixels for given band";
        }

        @Override
        public String getShortDescription() {
            return "Statistics of pixels (band)";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Spatial;
        }

        @Override
        public String getHelp() {
            return "summary-statistics-of-pixels-quantification-of-pro";
        }

        @Override
        public List<String> getKeywords() {
            return Arrays.asList("average", "min", "max", "std");
        }
    }
}

