/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.spatial;

import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.AbstractModelDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.realtime.descriptor.spatial.DistributionBalanceAngleCalculator;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;

public class PlsPredDistributionDescriptor
extends AbstractModelDescriptor {
    public PlsPredDistributionDescriptor(AbstractDescriptorInfo abstractDescriptorInfo) {
        super(abstractDescriptorInfo);
        this.addParameter(new TextParameter("grid", "3x3"));
        this.addOutput("distribution");
        this.addOutput("balance");
        this.addOutput("direction");
    }

    @Override
    public BasicAnalyse.ModelType getModelType() {
        return BasicAnalyse.ModelType.Quantification;
    }

    @Override
    public Factor getVisualizationFactor(int n) {
        return null;
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        if (n == 2) {
            return DistributionBalanceAngleCalculator.formatDirection(f);
        }
        return RtDataFormat.toPercent(f, false);
    }

    @Override
    public String getUnit(FunctionTreeNode functionTreeNode, int n) {
        return n != 2 ? "%" : null;
    }

    @Override
    public MinMax getMinMax(int n) {
        return n != 2 ? new MinMax(0.0f, 1.0f) : null;
    }

    @Override
    public boolean isAverage() {
        return false;
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "dist";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new PlsPredDistributionDescriptor(this);
        }

        public String toString() {
            return "PlsPredDistribution";
        }

        @Override
        public String getDescription() {
            return "Distribution statistics of pixels (quantification of properties)";
        }

        @Override
        public String getShortDescription() {
            return "Distribution statistics";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Statistic;
        }

        @Override
        public String getHelp() {
            return "distribution-of-subsamples";
        }
    }
}

