/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.spatial;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.RtFramesAndRefs;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.OptionParameter;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.image.RtSpatialObject;

public class SpatialDescriptor
extends AbstractDescriptor {
    private final BooleanParameter siUnitParameter = new BooleanParameter("siunit", "SI Unit", "Ratio of \"Field Of View\" and Camera width", true);
    private final SiTypeParameter siTypeParameter;

    public SpatialDescriptor(AbstractDescriptorInfo abstractDescriptorInfo) {
        super(abstractDescriptorInfo);
        this.addParameter(this.siUnitParameter);
        this.siTypeParameter = new SiTypeParameter();
        this.addParameter(this.siTypeParameter);
        this.siTypeParameter.setVisible(this.siUnitParameter::getValueBool);
        for (Unit unit : Unit.values()) {
            this.addOutput(unit.toString());
        }
    }

    @Override
    public float[] perform(BreezeProgress breezeProgress, FunctionTreeNode functionTreeNode, DescriptorInterface descriptorInterface, RtFramesAndRefs rtFramesAndRefs, RtSpatialObject rtSpatialObject) {
        return this.getObjectResult(rtSpatialObject, rtSpatialObject.getResolution());
    }

    private float[] getObjectResult(RtSpatialObject rtSpatialObject, float f) {
        return this.convertToSI(new float[]{rtSpatialObject.getArea(), rtSpatialObject.getHeight(), rtSpatialObject.getWidth(), rtSpatialObject.getCircumference(), rtSpatialObject.getRegularity(), rtSpatialObject.getRoundness(), rtSpatialObject.getOrientation(), rtSpatialObject.getD1(), rtSpatialObject.getD2(), rtSpatialObject.getCenterPoint().x, rtSpatialObject.getCenterPoint().y}, f);
    }

    private float[] convertToSI(float[] fArray, float f) {
        if (f == 1.0f) {
            return fArray;
        }
        Unit[] unitArray = Unit.values();
        for (int i = 0; i < fArray.length; ++i) {
            if (!unitArray[i].isSi()) continue;
            int n = i;
            fArray[n] = fArray[n] * f;
            if (!unitArray[i].isArea()) continue;
            int n2 = i;
            fArray[n2] = fArray[n2] * f;
        }
        return fArray;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        String string = StringHelper.formatLabel(this.getOutputString(n));
        if (this.siUnitParameter.getValueBool()) {
            return string + " (" + this.siTypeParameter.getValueStr() + ")";
        }
        return string;
    }

    @Override
    public String getUnformattedValue(float f, int n, int n2) {
        return RtDataFormat.toString(f, n2);
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        Unit unit = Unit.values()[n];
        if (unit.isPercent()) {
            return RtDataFormat.toPercent(f);
        }
        String string = super.getStringValue(f, n, n2);
        if (unit.isDegree()) {
            return string + "\u00b0";
        }
        return string;
    }

    @Override
    public String getUnit(FunctionTreeNode functionTreeNode, int n) {
        return Unit.values()[n].getUnit(this.siUnitParameter.getValueBool(), this.siTypeParameter.getValueStr());
    }

    @Override
    public String getShapeType() {
        return "descriptor_spatial";
    }

    public static class SiTypeParameter
    extends OptionParameter<OptionParameter.Option> {
        public SiTypeParameter() {
            super("sitype", "SI Type", SiUnit.mm.getUnit(), "");
            for (SiUnit siUnit : SiUnit.values()) {
                this.add(new OptionParameter.Option(siUnit.getUnit(), siUnit.getDescription()));
            }
        }
    }

    public static enum Unit {
        Area(true, true, false),
        Length(true),
        Width(true),
        Circumference(true),
        Regularity(false, false, true),
        Roundness(false, false, true),
        Angle(false),
        D1(true),
        D2(true),
        X(true),
        Y(true),
        MaxBorderDistance(true),
        BoundingBoxArea(true, true, false);

        private final boolean si;
        private final boolean area;
        private final boolean percent;

        private Unit(boolean bl) {
            this(bl, false, false);
        }

        private Unit(boolean bl, boolean bl2, boolean bl3) {
            this.si = bl;
            this.area = bl2;
            this.percent = bl3;
        }

        public String getUnit(boolean bl, String string) {
            if (this.si) {
                if (bl) {
                    if (this.area) {
                        return string + "\u00b2";
                    }
                    return string;
                }
                return "px";
            }
            return null;
        }

        public boolean isDegree() {
            return this.equals((Object)Angle);
        }

        public boolean requireRotation() {
            return this.equals((Object)D1) || this.equals((Object)D2) || this.equals((Object)Angle);
        }

        public boolean requireRadius() {
            return this.equals((Object)Roundness);
        }

        public boolean requireBorder() {
            return this.equals((Object)Circumference) || this.equals((Object)Regularity);
        }

        public float getValue(RtSpatialObject rtSpatialObject) {
            return switch (this.ordinal()) {
                case 0 -> rtSpatialObject.getArea();
                case 3 -> rtSpatialObject.getCircumference();
                case 7 -> rtSpatialObject.getD1();
                case 8 -> rtSpatialObject.getD2();
                case 1 -> rtSpatialObject.getHeight();
                case 6 -> rtSpatialObject.getOrientation();
                case 4 -> rtSpatialObject.getRegularity();
                case 5 -> rtSpatialObject.getRoundness();
                case 2 -> rtSpatialObject.getWidth();
                case 9 -> rtSpatialObject.getCenterPoint().x;
                case 10 -> rtSpatialObject.getCenterPoint().y;
                case 11 -> rtSpatialObject.getMax();
                default -> 0.0f;
            };
        }

        @Generated
        public boolean isSi() {
            return this.si;
        }

        @Generated
        public boolean isArea() {
            return this.area;
        }

        @Generated
        public boolean isPercent() {
            return this.percent;
        }
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "spatial";
        }

        @Override
        public SpatialDescriptor createFunction() {
            return new SpatialDescriptor(this);
        }

        public String toString() {
            return "Spatial";
        }

        @Override
        public String getDescription() {
            return "Spatial values from sample";
        }

        @Override
        public String getShortDescription() {
            return "Shape and size";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Spatial;
        }

        @Override
        public String getHelp() {
            return "spatial-values-from-sample";
        }

        @Override
        public List<String> getKeywords() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("pixels");
            arrayList.add("si");
            for (Unit unit : Unit.values()) {
                arrayList.add(unit.name());
            }
            return arrayList;
        }
    }

    public static enum SiUnit {
        mm("mm", 1.0),
        cm("cm", 0.1),
        meter("m", 0.001),
        feet("ft", 0.0032808398950131233, 0.003281),
        inches("\"", 0.03937007874015748, 0.0394);

        private final String unit;
        private final double factor;
        private final double oldFactor;

        private SiUnit(String string2, double d) {
            this(string2, d, d);
        }

        private SiUnit(String string2, double d, double d2) {
            this.unit = string2;
            this.factor = d;
            this.oldFactor = d2;
        }

        public boolean checkOldFactor() {
            return this.equals((Object)feet) || this.equals((Object)inches);
        }

        public String getDescription() {
            if (this.equals((Object)mm)) {
                return "millimeter (mm)";
            }
            if (this.equals((Object)cm)) {
                return "centimeter (cm)";
            }
            String string = this.name();
            if (string.equals(this.unit)) {
                return string;
            }
            return string + " (" + this.unit + ")";
        }

        public static SiUnit parse(String string) {
            for (SiUnit siUnit : SiUnit.values()) {
                if (!siUnit.name().equalsIgnoreCase(string)) continue;
                return siUnit;
            }
            return mm;
        }

        public String toString() {
            return this.unit;
        }

        public static double convert(double d, SiUnit siUnit, SiUnit siUnit2) {
            return d * siUnit2.getFactor() / siUnit.getFactor();
        }

        @Generated
        public String getUnit() {
            return this.unit;
        }

        @Generated
        public double getFactor() {
            return this.factor;
        }

        @Generated
        public double getOldFactor() {
            return this.oldFactor;
        }
    }
}

