/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.spatial.expression;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.realtime.descriptor.parameter.ExpressionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.spatial.expression.CategoryExpressionParameter;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;

public class CatClassExpression
extends ExpressionParameter.Expression<BasicSample> {
    private CatClass catClass;
    private String id;

    public CatClassExpression(CatClass catClass, CategoryExpressionParameter categoryExpressionParameter) {
        this.catClass = catClass;
    }

    public CatClassExpression(Node node, CategoryExpressionParameter categoryExpressionParameter) {
        super(node);
        this.id = XmlParserHelper.getAttribute(node, "id");
        if (this.id.startsWith("##")) {
            this.catClass = CatClass.FromAdded(this.id);
            this.id = this.catClass.getName();
        }
    }

    public CatClassExpression clone(FunctionParameter functionParameter) {
        CatClassExpression catClassExpression = (CatClassExpression)super.clone(functionParameter);
        return catClassExpression;
    }

    @Override
    public Element save(Element element) {
        Element element2 = super.save(element);
        element2.setAttribute("id", this.getSaveId());
        return element2;
    }

    public String getSaveId() {
        if (this.catClass != null) {
            if (this.catClass.getFactor() == null) {
                return "##" + this.catClass.getColorString() + "##" + this.catClass.getName();
            }
            return this.catClass.getName();
        }
        return this.id;
    }

    public void setCatClass(CatClass catClass) {
        this.catClass = catClass;
    }

    public CatClass getCatClass() {
        return this.catClass;
    }

    public int getIndex() {
        return this.catClass.getValueIdx();
    }

    public String getId() {
        if (this.catClass != null) {
            return this.catClass.getName();
        }
        return this.id;
    }

    public boolean isAdded() {
        return this.catClass == null || this.catClass.isAdded();
    }
}

