/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.spatial.expression;

import java.util.ArrayList;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.ExpressionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TransformationParameter;
import se.prediktera.breeze.common.realtime.descriptor.spatial.expression.CatClassExpression;

public class CategoryExpressionParameter
extends ExpressionParameter<CatClassExpression> {
    public CatClassExpression selectedExpression;
    private CategoryFactor factor;

    public CategoryExpressionParameter(TransformationParameter transformationParameter) {
        super("Expression", "id", "Example: roundness > 0.5 and (area / circumference) > 0.5");
    }

    public void configure(CategoryFactor categoryFactor) {
        this.factor = categoryFactor;
        if (categoryFactor != null) {
            Object object;
            ArrayList<CatClassExpression> arrayList = new ArrayList<CatClassExpression>();
            for (CatClassExpression object2 : this.expressionLists) {
                object = object2.getCatClass();
                if (object != null && ((CatClass)object).getFactor() == null) continue;
                arrayList.add(object2);
            }
            for (CatClass catClass : categoryFactor.getLeafs()) {
                if (catClass.isNoClass() || !catClass.isIncluded()) continue;
                object = this.get(catClass);
                if (object != null) {
                    ((CatClassExpression)object).setCatClass(catClass);
                    arrayList.remove(object);
                    continue;
                }
                this.add(new CatClassExpression(catClass, this));
            }
            this.expressionLists.removeAll(arrayList);
        }
    }

    public CatClassExpression get(CatClass catClass) {
        for (CatClassExpression catClassExpression : this.expressionLists) {
            if (!catClassExpression.getId().equals(catClass.getName())) continue;
            return catClassExpression;
        }
        return null;
    }

    @Override
    protected CatClassExpression createList(Node node) {
        return new CatClassExpression(node, this);
    }

    public int getMaxSize() {
        int n = 0;
        if (this.factor != null) {
            n = this.factor.getMaxSize();
        }
        return Math.max(n, this.getExpressionLists().size() + 1);
    }
}

