/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.spatial.expression;

import java.awt.Color;
import java.awt.Graphics;
import java.util.List;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.PropertyFactorParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.WorkflowAnalyseParameter;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.util.CustomRenderingDescriptor;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.sample.Sample;

public class DataSlicingDescriptor
extends AbstractDescriptor
implements CustomRenderingDescriptor,
ThumbnailDescriptor {
    private final String version = "1";
    private WorkflowAnalyseParameter analyseParameter = new WorkflowAnalyseParameter("analyse", BreezeMasterCache.getRtAnalyseListOrNull());
    private final DataSlicingParameter parameter;
    private PropertyFactorParameter idParameter;

    public DataSlicingDescriptor(AbstractDescriptorInfo abstractDescriptorInfo) {
        super(abstractDescriptorInfo);
        this.addParameter(this.analyseParameter);
        this.analyseParameter.setVisible(false);
        this.idParameter = new PropertyFactorParameter("id", "Classification descriptor", 0);
        this.addParameter(this.idParameter);
        this.parameter = new DataSlicingParameter();
        this.addParameter(this.parameter);
        this.addOutput("value");
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        Factor factor = this.getFactor(n);
        if (n == 0 && factor instanceof CategoryFactor) {
            CategoryFactor categoryFactor = (CategoryFactor)factor;
            int n3 = (int)f;
            if (n3 >= 0 && n3 < categoryFactor.getClassCount()) {
                return categoryFactor.getClasses().get(n3).getName();
            }
        }
        return super.getStringValue(f, n, n2);
    }

    private int getParameterHashCode(String string, FunctionTreeNodeWithId functionTreeNodeWithId) {
        int n = StringHelper.hashCode(string);
        n += StringHelper.hashCode(functionTreeNodeWithId.getUid());
        return n += FunctionParameter.hashCode(this.idParameter, this.parameter);
    }

    private RtAnalyse getOrCreateAnalyse(final FunctionTreeNodeWithId functionTreeNodeWithId) {
        String string = this.getStudyId();
        return MembersSetting.createAnalyse(functionTreeNodeWithId, "DataSlice_" + this.getParameterHashCode(string, functionTreeNodeWithId), this.analyseParameter, new MembersSetting.CreateAnalyseCallback(){
            final /* synthetic */ DataSlicingDescriptor this$0;
            {
                this.this$0 = dataSlicingDescriptor;
            }

            @Override
            public RtAnalyse create(String string) {
                RtAnalyse rtAnalyse = new RtAnalyse(string, "DataSlicing", BasicAnalyse.ModelMethod.ClassificationDataSlicing, this.this$0.getStudyId(), "1");
                RtModelParameters rtModelParameters = new RtModelParameters();
                RtModelParameters.RtModel rtModel = new RtModelParameters.RtModel("DataSlicing");
                rtModelParameters.addModel(rtModel);
                rtAnalyse.setModelParameters(rtModelParameters);
                return rtAnalyse;
            }

            @Override
            public void deferredCreate(RtAnalyse rtAnalyse) {
                PropertyFactorParameter.NodePropertyAnalyse nodePropertyAnalyse = this.this$0.idParameter.getNodePropertyAnalyse(functionTreeNodeWithId);
                CategoryFactor categoryFactor = this.this$0.parameter.createCategoryFactor(rtAnalyse.getUid());
                RtModelParameters.RtModuleSetup rtModuleSetup = new RtModelParameters.RtModuleSetup("Base");
                List<CatClass> list = categoryFactor.getClasses();
                RtModelParameters.RtModel rtModel = rtAnalyse.getRtModel();
                rtModuleSetup.add(new RtModelParameters.RtParameterScalar("slices", list.size()));
                int n = 0;
                for (CatClass catClass : list) {
                    if (!(catClass instanceof DataSlicingParameter.DataSliceCatClass)) continue;
                    DataSlicingParameter.DataSliceCatClass dataSliceCatClass = (DataSlicingParameter.DataSliceCatClass)catClass;
                    String string = n > 0 ? Integer.valueOf(n + 1) : "";
                    rtModuleSetup.add(new RtModelParameters.RtParameterScalar("from" + String.valueOf(string), dataSliceCatClass.from));
                    rtModuleSetup.add(new RtModelParameters.RtParameterScalar("to" + String.valueOf(string), dataSliceCatClass.to));
                    ++n;
                }
                rtModel.getModules().add(rtModuleSetup);
                rtAnalyse.getCategoryFactors().add(categoryFactor);
                if (nodePropertyAnalyse != null) {
                    rtModuleSetup.add(new RtModelParameters.RtParameterString("analyseUid", nodePropertyAnalyse.analyse().getUid()));
                    rtModuleSetup.add(new RtModelParameters.RtParameterScalar("factorIndex", nodePropertyAnalyse.getFactorIndex()));
                }
                rtModel.getModules().add(rtModuleSetup);
            }
        });
    }

    @Override
    public RtAnalyse getAnalyse() {
        RtAnalyse rtAnalyse = this.getOrCreateAnalyse(this.getNode());
        this.analyseParameter.setValue(rtAnalyse);
        return rtAnalyse;
    }

    @Override
    public Factor getFactor(int n) {
        return this.getAnalyse().getFactor();
    }

    @Override
    public boolean hasThumbnail(int n) {
        return true;
    }

    @Override
    public ThumbnailDescriptor.ThumbType getThumbType(int n) {
        return ThumbnailDescriptor.ThumbType.ThumbClassification;
    }

    @Override
    public boolean renderCellAt(int n) {
        return true;
    }

    @Override
    public void renderCell(Sample sample, float f, Graphics graphics, int n, int n2, int n3) {
        Factor factor = this.getFactor(n3);
        if (factor instanceof CategoryFactor) {
            CategoryFactor categoryFactor = (CategoryFactor)factor;
            CatClass.render(graphics, categoryFactor.getClassByValueIdx((int)f), n2);
        }
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return "Data slicing";
    }

    @Override
    public CustomRenderingDescriptor.RenderData getStringValueAndOptionalBoxColor(String string, FunctionResult functionResult) {
        return new CustomRenderingDescriptor.RenderData(string, Optional.of(this.getCategoryColorHexString(functionResult)));
    }

    private String getCategoryColorHexString(FunctionResult functionResult) {
        return RtPerfectSpread.getColorToString(((CategoryFactor)functionResult.getFactor()).getClassByValueIdx((int)functionResult.getValue()).getColor());
    }

    @Override
    public CustomRenderingDescriptor.RenderData getSubStringValueAndOptionalBoxColor(String string, FunctionResult functionResult) {
        return new CustomRenderingDescriptor.RenderData(string);
    }

    public static class DataSlicingParameter
    extends TextParameter {
        public CatClass selected;

        public DataSlicingParameter() {
            super("dataslicing", "Data slicing", "", "");
        }

        public CategoryFactor createCategoryFactor(String string) {
            CategoryFactor categoryFactor = CategoryFactor.withNoClass("DataSlicing", "DataSlicing", Color.black);
            String string2 = this.getText();
            if (string2 != null && string2.length() > 0) {
                JSONArray jSONArray = new JSONArray(string2.replaceAll("'", "\""));
                for (int i = 0; i < jSONArray.length(); ++i) {
                    categoryFactor.addClass(DataSliceCatClass.fromJSON(jSONArray.getJSONObject(i), categoryFactor));
                }
            }
            return categoryFactor;
        }

        public String getUpdatedText(CategoryFactor categoryFactor) {
            JSONArray jSONArray = new JSONArray();
            for (CatClass catClass : categoryFactor.getClasses()) {
                if (!(catClass instanceof DataSliceCatClass)) continue;
                DataSliceCatClass dataSliceCatClass = (DataSliceCatClass)catClass;
                jSONArray.put((Object)dataSliceCatClass.toJSON());
            }
            return jSONArray.toString().replaceAll("\"", "'");
        }

        public static class DataSliceCatClass
        extends CatClass {
            public double from;
            public double to;

            public DataSliceCatClass(String string, CategoryFactor categoryFactor) {
                super(string, categoryFactor);
            }

            public JSONObject toJSON() {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("n", (Object)this.getName());
                jSONObject.put("c", (Object)RtPerfectSpread.getColorToString(this.getColor()));
                jSONObject.put("f", this.from);
                jSONObject.put("t", this.to);
                return jSONObject;
            }

            public static DataSliceCatClass fromJSON(JSONObject jSONObject, CategoryFactor categoryFactor) {
                DataSliceCatClass dataSliceCatClass = new DataSliceCatClass(jSONObject.optString("n", "name"), categoryFactor);
                dataSliceCatClass.setColor(RtPerfectSpread.getColorFromString(jSONObject.optString("c", "red")));
                dataSliceCatClass.from = jSONObject.optDouble("f", 0.0);
                dataSliceCatClass.to = jSONObject.optDouble("t", 0.0);
                return dataSliceCatClass;
            }
        }
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "data-slicing";
        }

        @Override
        public DataSlicingDescriptor createFunction() {
            return new DataSlicingDescriptor(this);
        }

        public String toString() {
            return "DataSlicing";
        }

        @Override
        public String getDescription() {
            return "Classification by data slicing of property";
        }

        @Override
        public String getShortDescription() {
            return "Data slicing";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Expression;
        }

        @Override
        public String getHelp() {
            return "data-slicing";
        }
    }
}

