/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.spatial.expression;

import java.awt.Graphics;
import java.util.List;
import java.util.Optional;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TransformationParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.WorkflowAnalyseParameter;
import se.prediktera.breeze.common.realtime.descriptor.spatial.expression.CategoryExpressionParameter;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.util.CustomRenderingDescriptor;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.main.play.edit.FunctionParameterCustomInput;

public class ExpressionClassificationDescriptor
extends AbstractDescriptor
implements CustomRenderingDescriptor,
FunctionParameterCustomInput.ExpressionClassificationFactorInterface {
    private final String version = "1";
    private WorkflowAnalyseParameter analyseParameter;
    private final TransformationParameter transformationParameter = new TransformationParameter();
    private final CategoryExpressionParameter parameter;

    public ExpressionClassificationDescriptor(AbstractDescriptorInfo abstractDescriptorInfo) {
        super(abstractDescriptorInfo);
        this.analyseParameter = new WorkflowAnalyseParameter("analyse", BreezeMasterCache.getRtAnalyseListOrNull());
        this.addParameter(this.analyseParameter);
        this.analyseParameter.setVisible(false);
        this.parameter = new CategoryExpressionParameter(this.transformationParameter);
        this.addParameter(this.parameter);
        this.addParameter(this.transformationParameter);
        this.addOutput("value");
    }

    @Override
    public List<ModelProperties.TransformationProperties> getTransformations() {
        return this.transformationParameter.getTransformations();
    }

    @Override
    public boolean childDescriptorsAreInput() {
        return true;
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        CategoryFactor categoryFactor = this.getFactor(null);
        if (n == 0 && categoryFactor instanceof CategoryFactor) {
            CategoryFactor categoryFactor2 = categoryFactor;
            int n3 = (int)f;
            if (n3 >= 0 && n3 < categoryFactor2.getClassCount()) {
                return categoryFactor2.getClasses().get(n3).getName();
            }
        }
        return super.getStringValue(f, n, n2);
    }

    public void setFactor(CategoryFactor categoryFactor) {
        this.getParameterByName("factor").setValue(categoryFactor);
    }

    @Override
    public CategoryExpressionParameter getExpression() {
        return this.parameter;
    }

    private RtAnalyse getOrCreateAnalyse(FunctionTreeNodeWithId functionTreeNodeWithId) {
        return MembersSetting.createAnalyse(functionTreeNodeWithId, "ExpClaObj_" + functionTreeNodeWithId.getUid(), this.analyseParameter, string -> {
            RtAnalyse rtAnalyse = new RtAnalyse(string, "Expression", BasicAnalyse.ModelMethod.ClassificationObject, this.getStudyId(), "1");
            RtModelParameters rtModelParameters = new RtModelParameters();
            rtModelParameters.addModel(new RtModelParameters.RtModel("Expression"));
            rtAnalyse.setModelParameters(rtModelParameters);
            rtAnalyse.getCategoryFactors().add(CategoryFactor.withNoClass("Expression", string));
            return rtAnalyse;
        });
    }

    @Override
    public RtAnalyse getAnalyse() {
        RtAnalyse rtAnalyse = this.getOrCreateAnalyse(this.getNode());
        this.analyseParameter.setValue(rtAnalyse);
        return rtAnalyse;
    }

    @Override
    public Factor getFactor(int n) {
        return this.getFactor(this.getNode());
    }

    @Override
    public CategoryFactor getFactor(FunctionTreeNode functionTreeNode) {
        RtAnalyse rtAnalyse = this.getAnalyse();
        if (rtAnalyse != null) {
            return rtAnalyse.getCategoryFactor();
        }
        return null;
    }

    @Override
    public boolean renderCellAt(int n) {
        return true;
    }

    @Override
    public void renderCell(Sample sample, float f, Graphics graphics, int n, int n2, int n3) {
        CategoryFactor categoryFactor = this.getFactor(null);
        if (categoryFactor != null) {
            CatClass.render(graphics, categoryFactor.getClassByValueIdx((int)f), n2);
        }
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return "Expression";
    }

    @Override
    public CustomRenderingDescriptor.RenderData getStringValueAndOptionalBoxColor(String string, FunctionResult functionResult) {
        return new CustomRenderingDescriptor.RenderData(string, Optional.of(this.getCategoryColorHexString(functionResult)));
    }

    private String getCategoryColorHexString(FunctionResult functionResult) {
        return RtPerfectSpread.getColorToString(((CategoryFactor)functionResult.getFactor()).getClassByValueIdx((int)functionResult.getValue()).getColor());
    }

    @Override
    public CustomRenderingDescriptor.RenderData getSubStringValueAndOptionalBoxColor(String string, FunctionResult functionResult) {
        return new CustomRenderingDescriptor.RenderData(string);
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "cmd";
        }

        @Override
        public ExpressionClassificationDescriptor createFunction() {
            return new ExpressionClassificationDescriptor(this);
        }

        public String toString() {
            return "ExpressionClassification";
        }

        @Override
        public String getDescription() {
            return "Classification using expression";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Expression;
        }

        @Override
        public String getHelp() {
            return "classification-of-categories-using-expression";
        }
    }
}

