/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.spatial.expression;

import java.awt.Graphics;
import java.util.List;
import java.util.Optional;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.IDParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TransformationParameter;
import se.prediktera.breeze.common.realtime.descriptor.spatial.expression.CategoryExpressionParameter;
import se.prediktera.breeze.common.util.CustomRenderingDescriptor;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.main.play.edit.FunctionParameterCustomInput;

public class ExpressionUpdateClassificationDescriptor
extends AbstractDescriptor
implements CustomRenderingDescriptor,
FunctionParameterCustomInput.ExpressionClassificationFactorInterface {
    private final IDParameter idParameter;
    private final TransformationParameter transformationParameter = new TransformationParameter();
    private final CategoryExpressionParameter parameter;
    private final BooleanParameter replaceParameter;

    public ExpressionUpdateClassificationDescriptor(AbstractDescriptorInfo abstractDescriptorInfo) {
        super(abstractDescriptorInfo);
        this.idParameter = new IDParameter.IDClassifcationParameter("id", "Classification descriptor", null);
        this.addParameter(this.idParameter);
        this.parameter = new CategoryExpressionParameter(this.transformationParameter);
        this.addParameter(this.parameter);
        this.addParameter(this.transformationParameter);
        this.replaceParameter = new BooleanParameter("replace", "Replace", "Replace classification descriptor values", true);
        this.addParameter(this.replaceParameter);
        this.addOutput("value");
    }

    @Override
    public List<ModelProperties.TransformationProperties> getTransformations() {
        return this.transformationParameter.getTransformations();
    }

    @Override
    public boolean childDescriptorsAreInput() {
        return true;
    }

    @Override
    public boolean hasResult(int n) {
        return !this.replaceParameter.getValueBool();
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        CategoryFactor categoryFactor = this.getFactor(this.getNode());
        if (n == 0 && categoryFactor instanceof CategoryFactor) {
            CatClass catClass;
            CategoryFactor categoryFactor2 = categoryFactor;
            int n3 = (int)f;
            if (n3 >= 0 && n3 < categoryFactor2.getClassCount() && (catClass = categoryFactor2.getClassByValueIdx(n3)) != null) {
                return catClass.getName();
            }
        }
        return super.getStringValue(f, n, n2);
    }

    public void setFactor(CategoryFactor categoryFactor) {
        this.getParameterByName("factor").setValue(categoryFactor);
    }

    @Override
    public CategoryExpressionParameter getExpression() {
        return this.parameter;
    }

    @Override
    public Factor getFactor(int n) {
        return this.getFactor(this.getNode());
    }

    @Override
    public CategoryFactor getFactor(FunctionTreeNode functionTreeNode) {
        Factor factor;
        FunctionTreeNodeWithId functionTreeNodeWithId = this.idParameter.getNode(functionTreeNode);
        if (functionTreeNodeWithId != null && (factor = functionTreeNodeWithId.getFactor()) instanceof CategoryFactor) {
            CategoryFactor categoryFactor = (CategoryFactor)factor;
            return categoryFactor;
        }
        return null;
    }

    @Override
    public boolean renderCellAt(int n) {
        return true;
    }

    @Override
    public void renderCell(Sample sample, float f, Graphics graphics, int n, int n2, int n3) {
        CategoryFactor categoryFactor = this.getFactor(this.getNode());
        if (categoryFactor != null) {
            CatClass.render(graphics, categoryFactor.getClassByValueIdx((int)f), n2);
        }
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return "Shape / Inclusion";
    }

    @Override
    public CustomRenderingDescriptor.RenderData getStringValueAndOptionalBoxColor(String string, FunctionResult functionResult) {
        return new CustomRenderingDescriptor.RenderData(string, Optional.of(this.getCategoryColorHexString(functionResult)));
    }

    private String getCategoryColorHexString(FunctionResult functionResult) {
        return RtPerfectSpread.getColorToString(((CategoryFactor)functionResult.getFactor()).getClassByValueIdx((int)functionResult.getValue()).getColor());
    }

    @Override
    public CustomRenderingDescriptor.RenderData getSubStringValueAndOptionalBoxColor(String string, FunctionResult functionResult) {
        return new CustomRenderingDescriptor.RenderData(string);
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "cmd";
        }

        @Override
        public ExpressionUpdateClassificationDescriptor createFunction() {
            return new ExpressionUpdateClassificationDescriptor(this);
        }

        public String toString() {
            return "ExpressionUpdateClassification";
        }

        @Override
        public String getDescription() {
            return "Update classification using expression";
        }

        @Override
        public String getShortDescription() {
            return "Update classification";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Expression;
        }

        @Override
        public String getHelp() {
            return "update-classification-of-categories-using-expressi";
        }
    }
}

