/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.spectralLibraries;

import java.awt.Color;
import java.util.Optional;
import lombok.Generated;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.realtime.unmixing.GroupingUtils;
import se.prediktera.breeze.common.util.BreezeColor;

public class GroupCatClass
extends CatClass {
    private CatClass groupClass;
    private GroupingUtils.Group group;

    public GroupCatClass(String string, CategoryFactor categoryFactor, GroupingUtils.Grouping grouping) {
        super(string, categoryFactor);
        Optional<GroupingUtils.Group> optional = grouping.getGroupFromEndMember(string);
        if (optional.isPresent()) {
            this.groupClass = optional.get().getCatClass(categoryFactor);
            this.setGroupName(this.groupClass.getGroupName());
            this.setGroupColor(this.groupClass.getColorString());
            this.group = optional.get();
        }
    }

    public GroupCatClass(CategoryFactor categoryFactor, GroupingUtils.Group group) {
        super(group.getGroupName(), categoryFactor);
        this.group = group;
        this.groupClass = group.getCatClass(categoryFactor);
        this.setGroupName(this.groupClass.getGroupName());
        this.setGroupColor(this.groupClass.getColorString());
    }

    @Override
    public boolean isGrouped() {
        return this.group != null && !this.group.getGrouping().isNone();
    }

    @Override
    public String getName() {
        if (this.groupClass != null) {
            return this.groupClass.getName();
        }
        return super.getName();
    }

    public String getActualClassName() {
        return super.getName();
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        if (this.group != null) {
            this.group.setGroupName(string);
        }
    }

    @Override
    public String getGroupName() {
        if (this.groupClass != null) {
            return this.groupClass.getName();
        }
        return super.getGroupName();
    }

    @Override
    public Color getColor() {
        if (this.groupClass != null) {
            return this.groupClass.getColor();
        }
        return super.getColor();
    }

    @Override
    public String getGroupColor() {
        if (this.groupClass != null) {
            return BreezeColor.colorToHex(this.groupClass.getColor());
        }
        return super.getGroupColor();
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
        if (this.group != null) {
            this.group.setColorHex(BreezeColor.colorToHex(color));
        }
    }

    public boolean isSameGroup(CatClass catClass) {
        return this.getGroupName().equals(catClass.getGroupName()) && this.getGroupColor().equals(catClass.getGroupColor());
    }

    @Generated
    public CatClass getGroupClass() {
        return this.groupClass;
    }

    @Generated
    public GroupingUtils.Group getGroup() {
        return this.group;
    }
}

