/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.summary;

import se.prediktera.breeze.common.entry.ObjectWithChildren;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.RtFramesAndRefs;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.parameter.IDParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.image.RtSpatialObject;

public class CountEntryDescriptor
extends AbstractDescriptor {
    private final NumberParameter depthParameter;
    private int depth = 1;

    public CountEntryDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addParameter(new IDParameter.SegmentationIdParameter("id", "Segmentation", "", true));
        this.depthParameter = new NumberParameter("depth", null, 1.0, null);
        this.addParameter(this.depthParameter);
        this.addOutput("count");
    }

    @Override
    public float[] perform(BreezeProgress breezeProgress, FunctionTreeNode functionTreeNode, DescriptorInterface descriptorInterface, RtFramesAndRefs rtFramesAndRefs, RtSpatialObject rtSpatialObject) {
        this.depth = this.depthParameter.getValueInt();
        return new float[]{this.countRecursive((ObjectWithChildren)((Object)descriptorInterface), 1)};
    }

    private int countRecursive(ObjectWithChildren objectWithChildren, int n) {
        if (this.depth < 0) {
            if (n > 2 && objectWithChildren.getChildCount() == 0) {
                return 1;
            }
        } else if (n == this.depth) {
            return objectWithChildren.getChildCount();
        }
        int n2 = 0;
        for (ObjectWithChildren objectWithChildren2 : objectWithChildren.getChildList()) {
            n2 += this.countRecursive(objectWithChildren2, n + 1);
        }
        return n2;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return RtDataFormat.initialLetter(this.getOutputString(n));
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "count";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new CountEntryDescriptor(this);
        }

        public String toString() {
            return "CountEntry";
        }

        @Override
        public String getDescription() {
            return "Number of subsamples";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Statistic;
        }

        @Override
        public String getHelp() {
            return "number-of-subsamples";
        }
    }
}

