/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.summary;

import java.util.List;
import se.prediktera.breeze.common.entry.ObjectWithChildren;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.RtFramesAndRefs;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.image.RtSpatialObject;

public class CountSamplesDescriptor
extends AbstractDescriptor {
    public CountSamplesDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addOutput("count");
    }

    @Override
    public float[] perform(BreezeProgress breezeProgress, FunctionTreeNode functionTreeNode, DescriptorInterface descriptorInterface, RtFramesAndRefs rtFramesAndRefs, RtSpatialObject rtSpatialObject) {
        return new float[]{this.countRecursive((ObjectWithChildren)((Object)descriptorInterface), 1)};
    }

    private int countRecursive(ObjectWithChildren objectWithChildren, int n) {
        if (objectWithChildren instanceof BasicSample && ((BasicSample)objectWithChildren).isRoot()) {
            if (objectWithChildren.getChildCount() == 0) {
                return 1;
            }
            return objectWithChildren.getChildCount();
        }
        int n2 = 0;
        List list = objectWithChildren.getChildList();
        for (ObjectWithChildren objectWithChildren2 : list) {
            n2 += this.countRecursive(objectWithChildren2, n + 1);
        }
        return n2;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return RtDataFormat.initialLetter(this.getOutputString(n));
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "count";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new CountSamplesDescriptor(this);
        }

        public String toString() {
            return "CountSamples";
        }

        @Override
        public String getDescription() {
            return "Number of subsamples";
        }

        @Override
        public boolean isVisibleInList() {
            return false;
        }

        @Override
        public String getHelp() {
            return "number-of-subsamples";
        }
    }
}

