/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.summary;

import java.text.SimpleDateFormat;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;

public class ObjectDescriptor
extends AbstractDescriptor {
    private final SimpleDateFormat timestampFormatter = new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss");

    public ObjectDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addOutput("StartLine");
        this.addOutput("EndLine");
        this.addOutput("StartTime");
        this.addOutput("EndTime");
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return StringHelper.formatLabel(this.getOutputString(n));
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        if (n > 1) {
            return this.timestampFormatter.format(new BufferedTcpStream.NanoTime((long)f).toTimestamp());
        }
        return super.getStringValue(f, n, n2);
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "crosshair";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new ObjectDescriptor(this);
        }

        public String toString() {
            return "Object";
        }

        @Override
        public String getShortDescription() {
            return "Object information";
        }

        @Override
        public String getDescription() {
            return "Object track information";
        }

        @Override
        public String getHelp() {
            return "object-track-information";
        }
    }
}

