/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.summary;

import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.parameter.OptionParameter;
import se.prediktera.breeze.common.util.StringHelper;

public class ReferenceDescriptor
extends AbstractDescriptor {
    private ReferenceOptionParameter optonParameter = new ReferenceOptionParameter(this);

    public ReferenceDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addParameter(this.optonParameter);
        this.addOutput("min");
        this.addOutput("mean");
        this.addOutput("median");
        this.addOutput("max");
        this.addOutput("std");
        this.addOutput("stderr");
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return StringHelper.formatLabel(this.optonParameter.getValueStr()) + " - " + StringHelper.formatLabel(this.getOutputString(n));
    }

    private class ReferenceOptionParameter
    extends OptionParameter {
        public ReferenceOptionParameter(ReferenceDescriptor referenceDescriptor) {
            super("type", "Reference type", "white", "");
            this.add(new OptionParameter.Option("white", "White"));
            this.add(new OptionParameter.Option("dark", "Dark"));
        }
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "white-dark";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new ReferenceDescriptor(this);
        }

        public String toString() {
            return "Reference";
        }

        @Override
        public String getShortDescription() {
            return "White / dark values";
        }

        @Override
        public String getDescription() {
            return "White and dark reference values";
        }

        @Override
        public String getHelp() {
            return "white-and-dark-reference-values";
        }
    }
}

