/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.summary;

import java.util.List;
import se.prediktera.breeze.common.entry.ObjectWithChildrenAndParent;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.RtFramesAndRefs;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.IDParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.SummaryParameter;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.image.RtSpatialObject;

public class SummaryDescriptor
extends AbstractDescriptor {
    private final IDParameter idParameter = new IDParameter.ChildIDParameter();
    private final SummaryParameter summaryParameter;
    private final BooleanParameter percentParameter;

    public SummaryDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addParameter(this.idParameter);
        this.summaryParameter = new SummaryParameter();
        this.addParameter(this.summaryParameter);
        this.percentParameter = new BooleanParameter("percent", false);
        this.addParameter(this.percentParameter);
        this.addOutput("value");
    }

    @Override
    public float[] perform(BreezeProgress breezeProgress, FunctionTreeNode functionTreeNode, DescriptorInterface descriptorInterface, RtFramesAndRefs rtFramesAndRefs, RtSpatialObject rtSpatialObject) {
        BasicSample basicSample;
        RtSpatialObject rtSpatialObject2;
        String string = this.idParameter.getId();
        SummaryParameter.Summary summary = this.summaryParameter.getOp();
        List list = ((ObjectWithChildrenAndParent)((Object)descriptorInterface)).getChildList();
        if (list.isEmpty()) {
            return new float[]{0.0f};
        }
        float f = this.getValue((ObjectWithChildrenAndParent)list.get(0), string);
        for (int i = 1; i < list.size(); ++i) {
            f = summary.perform(f, this.getValue((ObjectWithChildrenAndParent)list.get(i), string));
        }
        if (summary.equals((Object)SummaryParameter.Summary.AVERAGE)) {
            f /= (float)list.size();
        }
        if (this.percentParameter.getValueBool() && descriptorInterface instanceof BasicSample && (rtSpatialObject2 = (basicSample = (BasicSample)descriptorInterface).getCachedSpatialObject()) != null) {
            float f2 = rtSpatialObject2.getResolution();
            f /= (float)rtSpatialObject2.getArea() * f2 * f2;
        }
        return new float[]{f};
    }

    private float getValue(ObjectWithChildrenAndParent objectWithChildrenAndParent, String string) {
        DescriptorInterface descriptorInterface = (DescriptorInterface)((Object)objectWithChildrenAndParent);
        FunctionResult functionResult = descriptorInterface.getFunctionResult(string);
        if (functionResult != null) {
            return functionResult.getValue();
        }
        return 0.0f;
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        if (this.percentParameter.getValueBool()) {
            return RtDataFormat.toPercent(f, false);
        }
        return super.getStringValue(f, n, n2);
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        if (functionTreeNode != null) {
            FunctionTreeNode functionTreeNode2 = functionTreeNode.getParent();
            FunctionTreeNodeWithId functionTreeNodeWithId = functionTreeNode2.getNodeById(this.idParameter.getId());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.summaryParameter.getOp().getShortName());
            stringBuilder.append(" (");
            if (functionTreeNodeWithId != null) {
                stringBuilder.append(functionTreeNodeWithId.getNodeString(textType));
                BooleanParameter booleanParameter = (BooleanParameter)this.getParameterByIndex(2);
                if (booleanParameter.getValueBool()) {
                    stringBuilder.append("%");
                }
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
        return super.getNodeString(functionTreeNode, n, textType);
    }

    @Override
    public String getUnit(FunctionTreeNode functionTreeNode, int n) {
        if (this.percentParameter.getValueBool()) {
            return "%";
        }
        FunctionTreeNode functionTreeNode2 = functionTreeNode.getParent();
        FunctionTreeNodeWithId functionTreeNodeWithId = functionTreeNode2.getNodeById(this.idParameter.getId());
        if (functionTreeNodeWithId instanceof DescriptorTreeNode) {
            DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)functionTreeNodeWithId;
            return descriptorTreeNode.getUnit();
        }
        return super.getUnit(functionTreeNode, n);
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "sum";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new SummaryDescriptor(this);
        }

        public String toString() {
            return "Summary";
        }

        @Override
        public String getDescription() {
            return "Summary of subsamples";
        }

        @Override
        public String getHelp() {
            return "summary-of-subsamples";
        }
    }
}

