/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.usgs;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.realtime.descriptor.spatial.SpatialDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.usgs.DepthRegistrationPanel;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.measurement.Measurement;

public class CoreReg {
    public List<CoreLine> lines = new ArrayList<CoreLine>();
    public int lineWidth = 50;
    public String direction;
    public int version;

    public CoreReg() {
        this.version = 1;
    }

    public CoreReg(Node node) {
        this.lineWidth = XmlParserHelper.getIntAttribute(node, "width", 50);
        this.direction = XmlParserHelper.getAttribute(node, "direction", "vertical");
        this.version = XmlParserHelper.getIntAttribute(node, "version", 0);
        for (Node node2 : XmlParserHelper.getNodeList(node, "line")) {
            this.lines.add(new CoreLine(node2));
        }
    }

    public void writeXml(Element element) {
        Element element2 = XmlParserHelper.addElement(element, "depth");
        XmlParserHelper.setAttribute((Node)element2, "width", this.lineWidth);
        XmlParserHelper.setAttribute((Node)element2, "direction", this.direction);
        XmlParserHelper.setAttribute((Node)element2, "version", this.version);
        for (CoreLine coreLine : this.lines) {
            coreLine.writeXml(element2);
        }
    }

    public void setLines(int n, int n2) {
        int n3;
        if (n > this.lines.size()) {
            for (n3 = this.lines.size(); n3 < n; ++n3) {
                this.lines.add(new CoreLine(0));
            }
        } else {
            while (this.lines.size() > n) {
                this.lines.remove(n);
            }
        }
        if (this.lines.size() > 0) {
            n3 = n2 / n;
            int n4 = n3 / 2;
            for (int i = 0; i < this.lines.size(); ++i) {
                this.lines.get(i).setPosition(n4 + i * n3);
            }
        }
    }

    public boolean isVertical() {
        return !"horizontal".equalsIgnoreCase(this.direction);
    }

    public void sort() {
        this.lines.sort((coreLine, coreLine2) -> Float.compare(coreLine.position, coreLine2.position));
    }

    public CoreLine getLine(int n) {
        for (CoreLine coreLine : this.lines) {
            int n2 = coreLine.position - this.lineWidth / 2;
            if (n < n2 || n > n2 + this.lineWidth) continue;
            return coreLine;
        }
        return null;
    }

    public boolean hasData() {
        return this.lines.size() > 0;
    }

    public double getEndDepth(Measurement measurement) {
        return this.getEndDepth(measurement.getProperties().getPropertyDoubleLocal("logging/startDepth", 0.0));
    }

    public double getEndDepth(double d) {
        for (CoreLine coreLine : this.lines) {
            for (CoreType coreType : coreLine.areas) {
                if (coreType instanceof CompArea) {
                    CompArea compArea = (CompArea)coreType;
                    d += (double)compArea.number * compArea.stepLength;
                    continue;
                }
                if (coreType instanceof CoreArea) {
                    CoreArea coreArea = (CoreArea)coreType;
                    d += (double)coreArea.length();
                    continue;
                }
                if (!(coreType instanceof TrueDepth)) continue;
                TrueDepth trueDepth = (TrueDepth)coreType;
                d = trueDepth.depth;
            }
        }
        return d;
    }

    public static void updateStartEndDepth(List<Measurement> list) {
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            Measurement measurement = list.get(i);
            CoreReg coreReg = measurement.getCoreReg();
            if (i == 0) {
                d = measurement.getProperties().getPropertyDoubleLocal("logging/startDepth", 0.0);
            }
            if (coreReg.version == 0) {
                float f = RtDataFormat.toNumberFloat(measurement.getMetaProperties().getMetaValue("Resolution", "1"));
                SpatialDescriptor.SiUnit siUnit = measurement.getWorkflow().getDefaultUnit();
                if (coreReg.version == 0 && siUnit.checkOldFactor()) {
                    double d2 = (double)f * siUnit.getOldFactor();
                    double d3 = (double)f * siUnit.getFactor();
                    d = d * d2 / d3;
                    for (CoreLine coreLine : coreReg.lines) {
                        for (CoreType coreType : coreLine.areas) {
                            if (!(coreType instanceof TrueDepth)) continue;
                            TrueDepth trueDepth = (TrueDepth)coreType;
                            trueDepth.depth = trueDepth.depth * d2 / d3;
                        }
                    }
                }
                coreReg.version = 1;
            }
            double d4 = coreReg.getEndDepth(d);
            measurement.getProperties().setPropertyLocal("logging/startDepth", RtDataFormat.toStringAll(d));
            measurement.getProperties().setPropertyLocal("logging/endDepth", RtDataFormat.toStringAll(d4));
            measurement.save();
            d = d4;
        }
    }

    public static class CoreLine {
        public List<CoreType> areas = new ArrayList<CoreType>();
        public int position;

        public CoreLine(int n) {
            this.position = n;
        }

        public void setPosition(int n) {
            this.position = n;
        }

        public boolean isEdge(int n, int n2) {
            return n + 5 >= 0 && n - 5 <= 0 || n + 5 >= n2 && n - 5 <= n2;
        }

        public final CoreType getArea(int n) {
            for (CoreType coreType : this.areas) {
                if (!coreType.inside(n)) continue;
                return coreType;
            }
            return null;
        }

        public CoreLine(Node node) {
            this.position = XmlParserHelper.getIntAttribute(node, "position", this.areas.size());
            for (Node node2 : XmlParserHelper.getNodeList(node, "area")) {
                DepthRegistrationPanel.DepthMode depthMode = DepthRegistrationPanel.DepthMode.parse(XmlParserHelper.getAttribute(node2, "type"));
                switch (depthMode) {
                    case Core: 
                    case Rubble: 
                    case Loss: {
                        this.areas.add(new CoreArea(depthMode, this, node2));
                        break;
                    }
                    case True: {
                        this.areas.add(new TrueDepth(this, node2));
                        break;
                    }
                    case Comp: {
                        this.areas.add(new CompArea(this, node2));
                        break;
                    }
                    case Note: {
                        this.areas.add(new DepthNote(this, node2));
                    }
                }
            }
        }

        public void writeXml(Element element) {
            Element element2 = XmlParserHelper.addElement(element, "line");
            XmlParserHelper.setAttribute((Node)element2, "position", this.position);
            for (CoreType coreType : this.areas) {
                coreType.writeXml(element2);
            }
        }

        public void sortAndMerge() {
            this.areas.sort((coreType, coreType2) -> Float.compare(coreType.getSortPosition(), coreType2.getSortPosition()));
            for (int i = this.areas.size() - 1; i > 0; --i) {
                CoreArea coreArea;
                CoreArea coreArea2;
                CoreType coreType3 = this.areas.get(i - 1);
                CoreType coreType4 = this.areas.get(i);
                if (!coreType3.getMode().equals((Object)coreType4.getMode()) || !(coreType3 instanceof CoreArea) || !(coreArea2 = (CoreArea)coreType3).overlap(coreArea = (CoreArea)coreType4) && !coreArea.overlap(coreArea2)) continue;
                coreArea2.merge(coreArea);
                this.areas.remove(coreType4);
            }
        }

        public void addTrue(int n, double d) {
            this.areas.add(new TrueDepth(this, n, d));
            this.sortAndMerge();
        }

        public void addNote(int n, String string) {
            this.areas.add(new DepthNote(this, n, string));
            this.sortAndMerge();
        }

        public void addOrMerge(CoreArea coreArea) {
            if (coreArea.length() > 0) {
                this.areas.add(coreArea);
                this.sortAndMerge();
            }
        }

        public void split(CoreArea coreArea, CoreArea coreArea2) {
            this.areas.add(new CoreArea(coreArea.mode, this, coreArea2.end, coreArea.end));
            coreArea.end = coreArea2.start;
        }
    }

    public static abstract class CoreType {
        public final DepthRegistrationPanel.DepthMode mode;
        public final CoreLine line;

        public CoreType(DepthRegistrationPanel.DepthMode depthMode, CoreLine coreLine) {
            this.mode = depthMode;
            this.line = coreLine;
        }

        public Element writeXml(Element element) {
            Element element2 = XmlParserHelper.addElement(element, "area");
            element2.setAttribute("type", this.mode.toString());
            return element2;
        }

        protected abstract void moveEdge(DepthRegistrationPanel.EdgePos var1, int var2);

        protected abstract void move(int var1);

        protected abstract DepthRegistrationPanel.EdgePos getEdge(int var1);

        protected abstract boolean inside(int var1);

        abstract int getSortPosition();

        public DepthRegistrationPanel.DepthMode getMode() {
            return this.mode;
        }
    }

    public static class CompArea
    extends CoreArea {
        public double depth;
        public int number;
        public double stepLength;
        public double gap;

        public CompArea(CoreLine coreLine, int n, int n2) {
            super(DepthRegistrationPanel.DepthMode.Comp, coreLine, n, n2);
        }

        public CompArea(CoreLine coreLine, Node node) {
            super(DepthRegistrationPanel.DepthMode.Comp, coreLine, node);
            this.depth = XmlParserHelper.getDoubleAttribute(node, "depth", 0.0);
            this.number = XmlParserHelper.getIntAttribute(node, "number", 0);
            this.stepLength = XmlParserHelper.getDoubleAttribute(node, "stepLength", 0.0);
            this.gap = XmlParserHelper.getDoubleAttribute(node, "gap", 0.0);
        }

        @Override
        public Element writeXml(Element element) {
            Element element2 = super.writeXml(element);
            XmlParserHelper.setAttribute((Node)element2, "depth", this.depth);
            XmlParserHelper.setAttribute((Node)element2, "number", this.number);
            XmlParserHelper.setAttribute((Node)element2, "stepLength", this.stepLength);
            XmlParserHelper.setAttribute((Node)element2, "gap", this.gap);
            return element2;
        }
    }

    public static class CoreArea
    extends CoreType {
        public int start;
        public int end;

        public CoreArea(DepthRegistrationPanel.DepthMode depthMode, CoreLine coreLine, int n, int n2) {
            super(depthMode, coreLine);
            this.start = n;
            this.end = n2;
        }

        public CoreArea(DepthRegistrationPanel.DepthMode depthMode, CoreLine coreLine, Node node) {
            super(depthMode, coreLine);
            this.start = XmlParserHelper.getIntAttribute(node, "start", 0);
            this.end = XmlParserHelper.getIntAttribute(node, "end", 0);
        }

        @Override
        public Element writeXml(Element element) {
            Element element2 = super.writeXml(element);
            XmlParserHelper.setAttribute((Node)element2, "start", this.start);
            XmlParserHelper.setAttribute((Node)element2, "end", this.end);
            return element2;
        }

        @Override
        public void moveEdge(DepthRegistrationPanel.EdgePos edgePos, int n) {
            switch (edgePos) {
                case Start: {
                    this.start = n;
                    break;
                }
                case End: {
                    this.end = n;
                    break;
                }
            }
        }

        @Override
        protected void move(int n) {
            this.start += n;
            this.end += n;
        }

        @Override
        public DepthRegistrationPanel.EdgePos getEdge(int n) {
            if (n - 5 <= this.start && n + 5 >= this.start) {
                return DepthRegistrationPanel.EdgePos.Start;
            }
            if (n - 5 <= this.end && n + 5 >= this.end) {
                return DepthRegistrationPanel.EdgePos.End;
            }
            return DepthRegistrationPanel.EdgePos.None;
        }

        public boolean overlap(CoreArea coreArea) {
            return coreArea.start >= this.start && coreArea.start <= this.end || coreArea.end >= this.start && coreArea.end <= this.end;
        }

        public void merge(CoreArea coreArea) {
            this.start = Math.min(this.start, coreArea.start);
            this.end = Math.max(this.end, coreArea.end);
        }

        public void update(int n) {
            int n2 = this.start + (this.end - this.start) / 2;
            if (n < n2) {
                this.start = n;
            } else {
                this.end = n;
            }
        }

        public int length() {
            return this.end - this.start;
        }

        public Color getColor() {
            return this.mode.color;
        }

        @Override
        public int getSortPosition() {
            return this.end;
        }

        @Override
        protected boolean inside(int n) {
            return n + 5 >= this.start && n - 5 <= this.end;
        }
    }

    public static class TrueDepth
    extends CoreType {
        public int position;
        public double depth;

        public TrueDepth(CoreLine coreLine, int n, double d) {
            super(DepthRegistrationPanel.DepthMode.True, coreLine);
            this.position = n;
            this.depth = d;
        }

        public TrueDepth(CoreLine coreLine, Node node) {
            super(DepthRegistrationPanel.DepthMode.True, coreLine);
            this.position = XmlParserHelper.getIntAttribute(node, "position", 0);
            this.depth = XmlParserHelper.getDoubleAttribute(node, "depth", 0.0);
        }

        @Override
        public Element writeXml(Element element) {
            Element element2 = super.writeXml(element);
            XmlParserHelper.setAttribute((Node)element2, "position", this.position);
            XmlParserHelper.setAttribute((Node)element2, "depth", this.depth);
            return element2;
        }

        @Override
        public int getSortPosition() {
            return this.position;
        }

        @Override
        protected DepthRegistrationPanel.EdgePos getEdge(int n) {
            return this.inside(n) ? DepthRegistrationPanel.EdgePos.Start : DepthRegistrationPanel.EdgePos.None;
        }

        @Override
        protected boolean inside(int n) {
            return n + 5 >= this.position && n - 5 <= this.position;
        }

        @Override
        protected void moveEdge(DepthRegistrationPanel.EdgePos edgePos, int n) {
            this.position = n;
        }

        @Override
        protected void move(int n) {
            this.position += n;
        }
    }

    public static class DepthNote
    extends CoreType {
        public int position;
        public String value;

        public DepthNote(CoreLine coreLine, int n, String string) {
            super(DepthRegistrationPanel.DepthMode.Note, coreLine);
            this.position = n;
            this.value = string;
        }

        public DepthNote(CoreLine coreLine, Node node) {
            super(DepthRegistrationPanel.DepthMode.Note, coreLine);
            this.position = XmlParserHelper.getIntAttribute(node, "position", 0);
            this.value = XmlParserHelper.getAttribute(node, "value", "");
        }

        @Override
        public Element writeXml(Element element) {
            Element element2 = super.writeXml(element);
            XmlParserHelper.setAttribute((Node)element2, "position", this.position);
            XmlParserHelper.setAttribute((Node)element2, "value", this.value);
            return element2;
        }

        @Override
        public int getSortPosition() {
            return this.position;
        }

        @Override
        protected DepthRegistrationPanel.EdgePos getEdge(int n) {
            return this.inside(n) ? DepthRegistrationPanel.EdgePos.Start : DepthRegistrationPanel.EdgePos.None;
        }

        @Override
        protected boolean inside(int n) {
            return n + 5 >= this.position && n - 5 <= this.position;
        }

        @Override
        protected void moveEdge(DepthRegistrationPanel.EdgePos edgePos, int n) {
            this.position = n;
        }

        @Override
        protected void move(int n) {
            this.position += n;
        }
    }
}

