/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.usgs;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.realtime.descriptor.spatial.SpatialDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.usgs.CoreReg;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabelField;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.BreezeToggleButton;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.test.stubs.MeasurementWithoutIO;
import se.prediktera.map.common.error.ErrorHandler;

public class DepthRegistrationPanel
extends AbstractViewPanel {
    private final DepthRegistrationRenderPanel depthPanel;
    private final BreezeToggleButton coreButton;
    private final BreezeToggleButton rubbleButton;
    private final BreezeToggleButton lossButton;
    private final BreezeToggleButton trueButton;
    private final BreezeToggleButton compButton;
    private final BreezeToggleButton noteButton;
    private final BreezeButton deleteButton;
    private final PositionPanel statusBar = new PositionPanel();
    private final LoggingPanel loggingPanel;
    private final BreezeButton zoomInButton;
    private final BreezeButton zoomOutButton;
    private final BreezeButton linesButton;
    private final BreezeButton rotateButton;
    private Measurement measurement;
    private final BreezeButton applyChangesButton;

    public DepthRegistrationPanel(final BreezeMainPanel breezeMainPanel, Workflow workflow) {
        super(breezeMainPanel);
        this.setLayout(new GridBagLayout());
        this.setBackground(BreezeTheme.getInstance().getPanelBackground());
        this.depthPanel = new DepthRegistrationRenderPanel(breezeMainPanel, this.statusBar);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.linesButton = EntryMainHelper.createButton("setLines", "Lines", "setcomp", () -> BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Lines", "", (AbstractBreezeCustomPanel)new LinesPanel(), null, breezeActionEvent -> {
            ((LinesPanel)breezeActionEvent.getBreezeCustomPanel()).apply();
            this.getLoggingPanel().setMeasurement(this.measurement);
            this.depthPanel.reload();
        }));
        this.coreButton = new BreezeToggleButton("Core", "depthcore", buttonGroup, true, () -> this.depthPanel.setMode(DepthMode.Core));
        this.rubbleButton = new BreezeToggleButton("Rubble", "depthrubble", buttonGroup, false, () -> this.depthPanel.setMode(DepthMode.Rubble));
        this.lossButton = new BreezeToggleButton("Loss", "depthloss", buttonGroup, false, () -> this.depthPanel.setMode(DepthMode.Loss));
        this.trueButton = new BreezeToggleButton("True", "depthtrue", buttonGroup, false, () -> this.depthPanel.setMode(DepthMode.True));
        this.trueButton.setToolTipText("True depth marker");
        this.compButton = new BreezeToggleButton("Comp.", "depthcomp", buttonGroup, false, () -> this.depthPanel.setMode(DepthMode.Comp));
        this.compButton.setToolTipText("Compartments");
        this.noteButton = new BreezeToggleButton("Note", "depthnote", buttonGroup, false, () -> this.depthPanel.setMode(DepthMode.Note));
        this.zoomInButton = EntryMainHelper.createButton("Zoom in", "explore/zoom_in", this.depthPanel::zoomIn);
        this.zoomOutButton = EntryMainHelper.createButton("Zoom out", "explore/zoom_out", this.depthPanel::zoomOut);
        this.deleteButton = EntryMainHelper.createButton("Delete", "delete2", this.depthPanel::delete);
        this.rotateButton = EntryMainHelper.createButton("Rotate", "rotate", this.depthPanel::rotate);
        this.applyChangesButton = EntryMainHelper.createApplyButton(breezeMainPanel, new ProgressAction(this){
            final /* synthetic */ DepthRegistrationPanel this$0;
            {
                this.this$0 = depthRegistrationPanel;
            }

            @Override
            public void runAction() throws Exception {
                this.this$0.measurement.save();
                ApplyChanges.applyChanges((BreezeProgress)this.getProgressManager(), Measurement.getMeasurements(breezeMainPanel.getSelectedEntries()));
                breezeMainPanel.setDirty(true);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add(new BreezeScrollPane(this.depthPanel), gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(2, 0, 0, 0);
        this.add(this.statusBar, gridBagConstraints2);
        this.loggingPanel = new LoggingPanel(workflow, this);
        this.setRightSettingsPanel(this.loggingPanel);
        this.depthPanel.setFocusable(true);
        this.depthPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    DepthRegistrationPanel.this.deleteButton.doClick();
                }
            }
        });
    }

    @Override
    public boolean showRightSettingsPanel() {
        return true;
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        super.addComponent(breezeMainPanel);
        breezeMainPanel.addRightButton(this.linesButton);
        breezeMainPanel.addRightButton(new BreezeSeparator(1));
        breezeMainPanel.addRightButton(this.coreButton);
        breezeMainPanel.addRightButton(this.rubbleButton);
        breezeMainPanel.addRightButton(this.lossButton);
        breezeMainPanel.addRightButton(this.trueButton);
        breezeMainPanel.addRightButton(this.compButton);
        breezeMainPanel.addRightButton(this.noteButton);
        breezeMainPanel.addRightButton(new BreezeSeparator(1));
        breezeMainPanel.addRightButton(this.rotateButton);
        breezeMainPanel.addRightButton(this.zoomInButton);
        breezeMainPanel.addRightButton(this.zoomOutButton);
        breezeMainPanel.addRightButton(new BreezeSeparator(1));
        breezeMainPanel.addRightButton(this.deleteButton);
        breezeMainPanel.addRightButton(new BreezeSeparator(1));
        breezeMainPanel.addRightButton(this.applyChangesButton);
    }

    @Override
    public String getType() {
        return "DepthRegistration";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.measurement = Measurement.getMeasurement(object);
        if (this.measurement == null) {
            throw new ErrorHandler.InformationMessageException("No measurement avaiable");
        }
        this.depthPanel.setMeasurement(this.measurement);
        this.loggingPanel.setMeasurement(this.measurement);
        this.statusBar.setPositon(0, 0, 0.0);
    }

    @Override
    public WizardStep.LeaveResult leaveEntry(WizardStep.LeaveControlCallback leaveControlCallback) {
        if (this.measurement != null) {
            this.measurement.save();
        }
        return WizardStep.LeaveResult.Ok;
    }

    public LoggingPanel getLoggingPanel() {
        return this.loggingPanel;
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setTitle("Depth Registration");
        jFrame.setDefaultCloseOperation(3);
        MeasurementWithoutIO measurementWithoutIO = new MeasurementWithoutIO(){

            @Override
            public File getThumbnailFile() {
                return new File("E:\\Data\\BreezeDemo2222\\Record\\Study\\Group\\Box 128_ref\\measurement.jpg");
            }

            @Override
            public CoreReg getCoreReg() {
                CoreReg coreReg = super.getCoreReg();
                coreReg.setLines(3, 380);
                return coreReg;
            }
        };
        EntryMainPanel entryMainPanel = new EntryMainPanel(){};
        DepthRegistrationPanel depthRegistrationPanel = new DepthRegistrationPanel(entryMainPanel, measurementWithoutIO.getWorkflow());
        depthRegistrationPanel.addComponent(entryMainPanel);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)((Object)depthRegistrationPanel), "Center");
        jPanel.add((Component)entryMainPanel.getRightButtonPanel(), "South");
        depthRegistrationPanel.showEntry(measurementWithoutIO, null);
        jFrame.getContentPane().add((Component)jPanel, "Center");
        jFrame.setSize(1000, 500);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public static String format(double d) {
        return String.format("%.3f", d);
    }

    public static class PositionPanel
    extends JPanel {
        private final BreezeLabelField xLabel;
        private final BreezeLabelField yLabel;

        public PositionPanel() {
            this.setLayout(new GridBagLayout());
            this.setBackground(BreezeTheme.getInstance().getPanelBackground150());
            this.xLabel = new BreezeLabelField("X", 20, "0", 60);
            this.yLabel = new BreezeLabelField("Y", 20, "0", 60);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(2, 5, 2, 0);
            this.add((Component)this.xLabel, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 0);
            gridBagConstraints2.anchor = 17;
            this.add((Component)this.yLabel, gridBagConstraints2);
        }

        public void setPositon(int n, int n2, double d) {
            this.xLabel.setValue((double)n * d);
            this.yLabel.setValue((double)n2 * d);
        }
    }

    private class DepthRegistrationRenderPanel
    extends JPanel {
        private BufferedImage bufferedImage;
        private BufferedImage image;
        private CoreReg coreReg = new CoreReg();
        private CoreReg.CoreLine curLine;
        private CoreReg.CoreType curArea;
        private CoreReg.CoreArea newArea;
        private CoreReg.CoreArea emptyArea;
        private EdgePos dragEdge;
        private CoreReg.CoreType dragArea;
        private int dragPosition;
        private CoreReg.CoreLine dragLine;
        private DepthMode mode = DepthMode.Core;
        private boolean rotate = true;
        private float scale = 2.0f;
        private Measurement measurement;
        private MeasurementDepthInfo measurementDepthInfo;
        private double actualDepth;
        private final Color stringBackgroundColor = new Color(255, 255, 255, 150);
        private int offset;

        public DepthRegistrationRenderPanel(final BreezeMainPanel breezeMainPanel, final PositionPanel positionPanel) {
            this.setBackground(BreezeTheme.getInstance().getPanelBackground());
            this.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ DepthRegistrationRenderPanel this$1;
                {
                    this.this$1 = depthRegistrationRenderPanel;
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.this$1.requestFocus();
                    if (this.this$1.newArea != null) {
                        if (this.this$1.curLine != null) {
                            this.this$1.curLine.addOrMerge(this.this$1.newArea);
                        }
                        this.this$1.saveAndRepaint();
                        CoreReg.CoreArea coreArea = this.this$1.newArea;
                        if (coreArea instanceof CoreReg.CompArea) {
                            CoreReg.CompArea compArea = (CoreReg.CompArea)coreArea;
                            BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Compartments", "", (AbstractBreezeCustomPanel)new CompartmentPanel(this.this$1.measurement, this.this$1.measurementDepthInfo, null), null, breezeActionEvent -> {
                                ((CompartmentPanel)breezeActionEvent.getBreezeCustomPanel()).apply(compArea);
                                this.this$1.saveAndRepaint();
                            });
                        }
                        this.this$1.newArea = null;
                    } else if (this.this$1.emptyArea != null) {
                        if (this.this$1.curLine != null && this.this$1.emptyArea.length() > 0 && this.this$1.curArea instanceof CoreReg.CoreArea) {
                            this.this$1.curLine.split((CoreReg.CoreArea)this.this$1.curArea, this.this$1.emptyArea);
                            this.this$1.curLine.sortAndMerge();
                        }
                        this.this$1.emptyArea = null;
                        this.this$1.saveAndRepaint();
                    } else {
                        this.this$1.curLine = this.this$1.coreReg.getLine(this.this$1.getPositionW(mouseEvent));
                        int n = this.this$1.getPosition(mouseEvent);
                        CoreReg.CoreType coreType = this.this$1.curArea = this.this$1.curLine != null ? this.this$1.curLine.getArea(n) : null;
                        if (mouseEvent.getClickCount() >= 2 && this.this$1.curLine != null) {
                            if (this.this$1.curArea instanceof CoreReg.TrueDepth || this.this$1.curArea == null && this.this$1.mode.equals((Object)DepthMode.True)) {
                                CoreReg.TrueDepth trueDepth = (CoreReg.TrueDepth)this.this$1.curArea;
                                BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Depth marker", "Enter true depth (" + String.valueOf((Object)this.this$1.measurementDepthInfo.unit) + ")", trueDepth != null ? DepthRegistrationPanel.format(trueDepth.depth * this.this$1.measurementDepthInfo.factor) : "", breezeActionEvent -> {
                                    double d = (double)RtDataFormat.toNumberFloat(breezeActionEvent.result().toString()) / this.this$1.measurementDepthInfo.factor;
                                    if (trueDepth != null) {
                                        trueDepth.depth = d;
                                    } else {
                                        this.this$1.curLine.addTrue(n, d);
                                    }
                                    this.this$1.saveAndRepaint();
                                });
                            } else if (this.this$1.curArea instanceof CoreReg.DepthNote || this.this$1.curArea == null && this.this$1.mode.equals((Object)DepthMode.Note)) {
                                CoreReg.DepthNote depthNote = (CoreReg.DepthNote)this.this$1.curArea;
                                BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_AREA_OPTION, "Depth note", "Enter note", depthNote != null ? depthNote.value : "", breezeActionEvent -> {
                                    String string = breezeActionEvent.result().toString();
                                    if (depthNote != null) {
                                        depthNote.value = string;
                                    } else {
                                        this.this$1.curLine.addNote(n, string);
                                    }
                                    this.this$1.saveAndRepaint();
                                });
                            } else {
                                CoreReg.CoreType coreType2 = this.this$1.curArea;
                                if (coreType2 instanceof CoreReg.CompArea) {
                                    CoreReg.CompArea compArea = (CoreReg.CompArea)coreType2;
                                    BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Compartments", "", (AbstractBreezeCustomPanel)new CompartmentPanel(this.this$1.measurement, this.this$1.measurementDepthInfo, compArea), null, breezeActionEvent -> {
                                        ((CompartmentPanel)breezeActionEvent.getBreezeCustomPanel()).apply(compArea);
                                        this.this$1.saveAndRepaint();
                                    });
                                } else if (this.this$1.mode.isArea()) {
                                    if (this.this$1.curArea == null) {
                                        this.this$1.newArea = this.createArea(n);
                                    } else {
                                        this.this$1.emptyArea = this.createArea(n);
                                    }
                                }
                            }
                        } else if (this.this$1.curArea != null) {
                            EdgePos edgePos = this.this$1.curArea.getEdge(n);
                            if (!edgePos.equals((Object)EdgePos.None)) {
                                this.this$1.dragEdge = edgePos;
                            } else {
                                this.this$1.dragArea = this.this$1.curArea;
                                this.this$1.dragPosition = n;
                            }
                        } else if (this.this$1.curLine != null && this.this$1.curLine.isEdge(n, this.this$1.getMaxPosition())) {
                            this.this$1.dragLine = this.this$1.curLine;
                        }
                        this.this$1.repaint();
                    }
                }

                private CoreReg.CoreArea createArea(int n) {
                    if (this.this$1.mode.equals((Object)DepthMode.Comp)) {
                        return new CoreReg.CompArea(this.this$1.curLine, n, n);
                    }
                    return new CoreReg.CoreArea(this.this$1.mode, this.this$1.curLine, n, n);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (this.this$1.dragEdge != null) {
                        this.this$1.dragEdge = null;
                        this.this$1.curLine.sortAndMerge();
                        this.this$1.saveAndRepaint();
                    }
                    if (this.this$1.dragArea != null) {
                        this.this$1.dragArea = null;
                        this.this$1.curLine.sortAndMerge();
                        this.this$1.saveAndRepaint();
                    }
                    if (this.this$1.dragLine != null) {
                        this.this$1.dragLine = null;
                        this.this$1.coreReg.sort();
                        this.this$1.saveAndRepaint();
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){
                final /* synthetic */ DepthRegistrationRenderPanel this$1;
                {
                    this.this$1 = depthRegistrationRenderPanel;
                }

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    int n = this.this$1.getPosition(mouseEvent);
                    int n2 = this.this$1.getPositionW(mouseEvent);
                    positionPanel.setPositon(n, n2, this.this$1.measurementDepthInfo.factor);
                    if (this.this$1.newArea != null) {
                        this.this$1.newArea.update(n);
                        this.this$1.repaint();
                    } else if (this.this$1.emptyArea != null) {
                        this.this$1.emptyArea.update(n);
                        this.this$1.repaint();
                    } else {
                        CoreReg.CoreLine coreLine = this.this$1.coreReg.getLine(n2);
                        CoreReg.CoreType coreType = coreLine != null ? coreLine.getArea(n) : null;
                        this.this$1.setCursor(this.getCursor(n, coreLine, coreType));
                    }
                }

                private Cursor getCursor(int n, CoreReg.CoreLine coreLine, CoreReg.CoreType coreType) {
                    if (coreType != null) {
                        EdgePos edgePos = coreType.getEdge(n);
                        if (!edgePos.equals((Object)EdgePos.None)) {
                            if (this.this$1.isRotate()) {
                                return Cursor.getPredefinedCursor(10);
                            }
                            return Cursor.getPredefinedCursor(8);
                        }
                        return Cursor.getPredefinedCursor(12);
                    }
                    if (coreLine != null && coreLine.isEdge(n, this.this$1.getMaxPosition())) {
                        if (this.this$1.isRotate()) {
                            return Cursor.getPredefinedCursor(8);
                        }
                        return Cursor.getPredefinedCursor(10);
                    }
                    return Cursor.getDefaultCursor();
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    int n = this.this$1.getPosition(mouseEvent);
                    if (this.this$1.dragEdge != null) {
                        this.this$1.curArea.moveEdge(this.this$1.dragEdge, n);
                        this.this$1.repaint();
                    }
                    if (this.this$1.dragArea != null) {
                        this.this$1.dragArea.move(n - this.this$1.dragPosition);
                        this.this$1.repaint();
                        this.this$1.dragPosition = n;
                    }
                    if (this.this$1.dragLine != null) {
                        this.this$1.dragLine.setPosition(this.this$1.getPositionW(mouseEvent));
                        this.this$1.repaint();
                    }
                }
            });
        }

        public void setMeasurement(Measurement measurement) {
            this.measurement = measurement;
            this.updateFactor(measurement);
            this.setBufferedImage(ThumbnailManager.getInstance(0).getImage(measurement.getThumbnailFile()), measurement.getCoreReg());
        }

        public void reload() {
            this.setMeasurement(this.measurement);
        }

        public void updateFactor(Measurement measurement) {
            this.measurementDepthInfo = new MeasurementDepthInfo(measurement);
        }

        public double getFactor() {
            return this.measurementDepthInfo.factor;
        }

        private void saveAndRepaint() {
            DepthRegistrationPanel.this.loggingPanel.setEndDepth(this.measurement);
            this.measurement.save();
            this.repaint();
        }

        private boolean isRotate() {
            if (this.rotate) {
                return this.coreReg.isVertical();
            }
            return !this.coreReg.isVertical();
        }

        public void rotate() {
            this.rotate = !this.rotate;
            this.setBufferedImage(this.image, this.coreReg);
        }

        public void setBufferedImage(BufferedImage bufferedImage, CoreReg coreReg) {
            this.image = bufferedImage;
            this.bufferedImage = this.rotate ? ImageHelper.rotate(bufferedImage, coreReg.isVertical() ? -90.0 : 90.0) : bufferedImage;
            this.coreReg = coreReg;
            this.setScale(this.scale);
        }

        public void zoomIn() {
            this.setScale(this.scale * 1.1f);
        }

        public void zoomOut() {
            this.setScale(this.scale * 0.9f);
        }

        public void setScale(float f) {
            this.scale = f;
            this.setPreferredSize(new Dimension((int)((float)this.bufferedImage.getWidth() * f), (int)((float)this.bufferedImage.getHeight() * f)));
            this.revalidate();
            this.repaint();
        }

        private int getPositionW(MouseEvent mouseEvent) {
            if (this.isRotate()) {
                return (int)((float)mouseEvent.getPoint().y / this.scale);
            }
            return this.bufferedImage.getWidth() - (int)((float)mouseEvent.getPoint().x / this.scale);
        }

        private int getPosition(MouseEvent mouseEvent) {
            if (this.isRotate()) {
                return (int)Math.max(0.0f, (float)mouseEvent.getPoint().x / this.scale);
            }
            return (int)Math.max(0.0f, (float)mouseEvent.getPoint().y / this.scale);
        }

        public int getMaxPosition() {
            if (this.isRotate()) {
                return this.bufferedImage.getWidth();
            }
            return this.bufferedImage.getHeight();
        }

        public int getMaxPositionOrigWidth() {
            if (this.coreReg.isVertical()) {
                return this.image.getWidth();
            }
            return this.image.getHeight();
        }

        public void delete() {
            if (this.curArea != null) {
                this.curArea.line.areas.remove(this.curArea);
                this.saveAndRepaint();
                this.curArea = null;
            }
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.scale(this.scale, this.scale);
            graphics2D.drawImage(this.bufferedImage, 0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight(), null);
            int n = this.coreReg.lineWidth;
            BasicStroke basicStroke = new BasicStroke((float)n / 50.0f, 2, 0, 10.0f);
            BasicStroke basicStroke2 = new BasicStroke((float)n / 25.0f, 2, 0, 10.0f);
            this.actualDepth = this.measurementDepthInfo.startDepth * this.measurementDepthInfo.factor;
            int n2 = n / 5;
            int n3 = n / 5;
            this.offset = n2 / 5;
            graphics2D.setFont(new Font("Tahoma", 0, n3));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n4 = fontMetrics.getHeight();
            for (CoreReg.CoreLine coreLine : this.coreReg.lines) {
                graphics2D.setStroke(basicStroke);
                int n5 = (this.isRotate() ? coreLine.position : this.bufferedImage.getWidth() - coreLine.position) - n / 2;
                for (CoreReg.CoreType coreType : coreLine.areas) {
                    int n6;
                    int n7;
                    int n8;
                    String string;
                    GeneralPath generalPath;
                    if (coreType instanceof CoreReg.CoreArea) {
                        CoreReg.CoreArea coreArea = (CoreReg.CoreArea)coreType;
                        if (coreType instanceof CoreReg.CompArea) {
                            CoreReg.CompArea compArea = (CoreReg.CompArea)coreType;
                            this.drawComp(graphics2D, n5, compArea, coreArea == this.curArea);
                            continue;
                        }
                        if (coreType == this.curArea && this.emptyArea != null) {
                            this.drawArea(graphics2D, n5, coreArea.start, this.emptyArea.start, coreArea.getColor(), false);
                            this.drawArea(graphics2D, n5, this.emptyArea.end, coreArea.end, coreArea.getColor(), false);
                            continue;
                        }
                        this.drawArea(graphics2D, n5, coreArea, coreArea == this.curArea);
                        continue;
                    }
                    if (coreType instanceof CoreReg.TrueDepth) {
                        CoreReg.TrueDepth trueDepth = (CoreReg.TrueDepth)coreType;
                        graphics2D.setColor(Color.black);
                        int n9 = trueDepth.position;
                        generalPath = new GeneralPath();
                        if (this.isRotate()) {
                            graphics2D.drawLine(n9, n5, n9, n5 + n - this.offset);
                            generalPath.moveTo(n9, n5 - this.offset);
                            generalPath.lineTo((double)n9 + (double)n2 / 1.5, (double)(n5 - n2 - this.offset));
                            generalPath.lineTo((double)n9 - (double)n2 / 1.5, (double)(n5 - n2 - this.offset));
                            generalPath.closePath();
                        } else {
                            graphics2D.drawLine(n5 - this.offset, n9, n5 + n, n9);
                            generalPath.moveTo(n5 - this.offset, n9);
                            generalPath.lineTo((double)(n5 - this.offset - n2), (double)n9 + (double)n2 / 1.5);
                            generalPath.lineTo((double)(n5 - this.offset - n2), (double)n9 - (double)n2 / 1.5);
                            generalPath.closePath();
                        }
                        graphics2D.setColor(trueDepth == this.curArea ? DepthMode.True.color.brighter() : DepthMode.True.color);
                        graphics2D.fill(generalPath);
                        graphics2D.setColor(Color.black);
                        graphics2D.draw(generalPath);
                        graphics2D.setColor(Color.black);
                        this.actualDepth = trueDepth.depth * this.measurementDepthInfo.factor;
                        string = DepthRegistrationPanel.format(this.actualDepth);
                        n8 = (int)((double)fontMetrics.stringWidth(string) * 1.1);
                        if (this.isRotate()) {
                            n7 = n9 + 1;
                            n6 = n5 + n4;
                        } else {
                            n7 = n5 + this.offset;
                            n6 = n9 + n4 + 1;
                        }
                        graphics2D.setColor(this.stringBackgroundColor);
                        graphics2D.fillRect(n7, n6 - n4, n8, n4);
                        graphics2D.setColor(Color.black);
                        graphics2D.drawString(string, n7 + (int)((double)n8 * 0.05), n6 - (int)((double)n4 * 0.2));
                        continue;
                    }
                    if (!(coreType instanceof CoreReg.DepthNote)) continue;
                    CoreReg.DepthNote depthNote = (CoreReg.DepthNote)coreType;
                    graphics2D.setColor(Color.black);
                    int n10 = depthNote.position;
                    generalPath = new GeneralPath();
                    if (this.isRotate()) {
                        graphics2D.drawLine(n10, n5 - 1, n10, n5 + n - this.offset);
                        generalPath.moveTo((double)n10 - (double)n2 / 1.5, (double)(n5 - this.offset));
                        generalPath.lineTo((double)n10 + (double)n2 / 1.5, (double)(n5 - this.offset));
                        generalPath.lineTo((double)n10 + (double)n2 / 1.5, (double)(n5 - n2 - this.offset));
                        generalPath.lineTo((double)n10 - (double)n2 / 1.5, (double)(n5 - n2 - this.offset));
                        generalPath.closePath();
                    } else {
                        graphics2D.drawLine(n5 - this.offset, n10, n5 + n, n10);
                        generalPath.moveTo((double)(n5 - this.offset), (double)n10 - (double)n2 / 1.5);
                        generalPath.lineTo((double)(n5 - this.offset - n2), (double)n10 - (double)n2 / 1.5);
                        generalPath.lineTo((double)(n5 - this.offset - n2), (double)n10 + (double)n2 / 1.5);
                        generalPath.lineTo((double)(n5 - this.offset), (double)n10 + (double)n2 / 1.5);
                        generalPath.closePath();
                    }
                    graphics2D.setColor(depthNote == this.curArea ? DepthMode.Note.color.brighter() : DepthMode.Note.color);
                    graphics2D.fill(generalPath);
                    graphics2D.setColor(Color.black);
                    graphics2D.draw(generalPath);
                    graphics2D.setColor(Color.black);
                    string = StringUtils.abbreviate((String)depthNote.value, (int)10);
                    n8 = (int)((double)fontMetrics.stringWidth(string) * 1.1);
                    if (this.isRotate()) {
                        n7 = n10 + 1;
                        n6 = n5 + n4;
                    } else {
                        n7 = n5 + this.offset;
                        n6 = n10 + n4 + 1;
                    }
                    graphics2D.setColor(this.stringBackgroundColor);
                    graphics2D.fillRect(n7, n6 - n4, n8, n4);
                    graphics2D.setColor(Color.black);
                    graphics2D.drawString(string, n7 + (int)((double)n8 * 0.05), n6 - (int)((double)n4 * 0.2));
                }
                if (coreLine == this.curLine && this.newArea != null) {
                    this.drawArea(graphics2D, n5, this.newArea, false);
                }
                graphics2D.setColor(Color.white);
                graphics2D.setStroke(basicStroke2);
                if (this.isRotate()) {
                    graphics2D.drawRect(1, n5, this.bufferedImage.getWidth() - 2, n);
                    continue;
                }
                graphics2D.drawRect(n5, 1, n, this.bufferedImage.getHeight() - 2);
            }
        }

        private void drawArea(Graphics2D graphics2D, int n, CoreReg.CoreArea coreArea, boolean bl) {
            this.drawArea(graphics2D, n, coreArea.start, coreArea.end, coreArea.getColor(), bl);
        }

        private void drawArea(Graphics2D graphics2D, int n, int n2, int n3, Color color, boolean bl) {
            int n4;
            int n5;
            int n6;
            int n7;
            graphics2D.setColor(bl ? color.brighter() : color);
            if (this.isRotate()) {
                graphics2D.fillRect(n2, n, n3 - n2, this.coreReg.lineWidth);
            } else {
                graphics2D.fillRect(n, n2, this.coreReg.lineWidth, n3 - n2);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n8 = fontMetrics.getHeight();
            String string = DepthRegistrationPanel.format(this.actualDepth);
            int n9 = (int)((double)fontMetrics.stringWidth(string) * 1.1);
            this.actualDepth += (double)(n3 - n2) * this.measurementDepthInfo.factor;
            String string2 = DepthRegistrationPanel.format(this.actualDepth);
            int n10 = (int)((double)fontMetrics.stringWidth(string2) * 1.1);
            if (this.isRotate()) {
                n7 = n2;
                n6 = n + this.coreReg.lineWidth;
                n5 = n3 - n10;
                n4 = n + n8;
            } else {
                n7 = n + this.offset;
                n6 = n2 + n8;
                n5 = n + this.coreReg.lineWidth - n10;
                n4 = n3;
            }
            graphics2D.setColor(this.stringBackgroundColor);
            graphics2D.fillRect(n7, n6 - n8, n9, n8);
            graphics2D.fillRect(n5, n4 - n8, n10, n8);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(string, n7 + (int)((double)n9 * 0.05), n6 - (int)((double)n8 * 0.2));
            graphics2D.drawString(string2, n5 + (int)((double)n10 * 0.05), n4 - (int)((double)n8 * 0.2));
        }

        private void drawComp(Graphics2D graphics2D, int n, CoreReg.CompArea compArea, boolean bl) {
            this.actualDepth = compArea.depth * this.measurementDepthInfo.factor;
            Color color = compArea.getColor();
            int n2 = compArea.start;
            int n3 = compArea.end;
            graphics2D.setColor(bl ? color.brighter() : color);
            if (this.isRotate()) {
                graphics2D.fillRect(n2, n, n3 - n2, this.coreReg.lineWidth);
            } else {
                graphics2D.fillRect(n, n2, this.coreReg.lineWidth, n3 - n2);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n4 = fontMetrics.getHeight();
            double d = compArea.gap;
            double d2 = ((double)(n3 - n2) - d * ((double)compArea.number - 1.0)) / (double)compArea.number;
            for (int i = 0; i < compArea.number; ++i) {
                int n5;
                int n6;
                int n7;
                int n8;
                int n9 = (int)((double)compArea.start + (d2 + d) * (double)i);
                int n10 = (int)((double)n9 + d2);
                graphics2D.setColor(DepthMode.Rubble.color);
                if (this.isRotate()) {
                    graphics2D.fillRect(n9, n, n10 - n9, this.coreReg.lineWidth);
                } else {
                    graphics2D.fillRect(n, n9, this.coreReg.lineWidth, n10 - n9);
                }
                String string = DepthRegistrationPanel.format(this.actualDepth);
                int n11 = (int)((double)fontMetrics.stringWidth(string) * 1.1);
                this.actualDepth += compArea.stepLength * this.measurementDepthInfo.factor;
                String string2 = DepthRegistrationPanel.format(this.actualDepth);
                int n12 = (int)((double)fontMetrics.stringWidth(string2) * 1.1);
                if (this.isRotate()) {
                    n8 = n9;
                    n7 = n + this.coreReg.lineWidth;
                    n6 = n10 - n12;
                    n5 = n + n4;
                } else {
                    n8 = n + this.offset;
                    n7 = n9 + n4;
                    n6 = n + this.coreReg.lineWidth - n12;
                    n5 = n10;
                }
                graphics2D.setColor(this.stringBackgroundColor);
                graphics2D.fillRect(n8, n7 - n4, n11, n4);
                graphics2D.fillRect(n6, n5 - n4, n12, n4);
                graphics2D.setColor(Color.black);
                graphics2D.drawString(string, n8 + (int)((double)n11 * 0.05), n7 - (int)((double)n4 * 0.2));
                graphics2D.drawString(string2, n6 + (int)((double)n12 * 0.05), n5 - (int)((double)n4 * 0.2));
            }
        }

        @Generated
        public void setMode(DepthMode depthMode) {
            this.mode = depthMode;
        }
    }

    private static class LoggingPanel
    extends DefaultSettingsPanel {
        private final DepthRegistrationRenderPanel depthPanel;
        private final List<BreezeInputField.Number> loggingFields = new ArrayList<BreezeInputField.Number>();
        private Measurement measurement;
        private final BreezeLabel warningLabel = new BreezeLabel("Warning, update depths", ImageHelper.getResourceIcon("warningSmall"), 12);

        public LoggingPanel(Workflow workflow, DepthRegistrationPanel depthRegistrationPanel) {
            this.depthPanel = depthRegistrationPanel.depthPanel;
            DefaultSettingsPanel.SectionPanel sectionPanel = this.addSection("Logging");
            SpatialDescriptor.SiUnit siUnit = workflow.getDefaultUnit();
            for (Workflow.Logging logging : workflow.getLoggins()) {
                BreezeInputField.Number number = new BreezeInputField.Number(logging.formatName(), 0.0, siUnit.getUnit(), textActionEvent -> {
                    this.measurement.getProperties().setPropertyLocal("logging/" + logging.name(), RtDataFormat.toStringAll(textActionEvent.getValue() / this.depthPanel.getFactor()));
                    this.measurement.save();
                    this.depthPanel.updateFactor(this.measurement);
                    this.depthPanel.repaint();
                });
                number.setName(logging.name());
                sectionPanel.addComponentHorizontal(number);
                this.loggingFields.add(number);
            }
            sectionPanel.addComponentHorizontal(new BreezeSeparator());
            sectionPanel.addComponentHorizontal(EntryMainHelper.createButton("Update start and end depths", "material/sync", () -> BreezeOptionDialog.showDialog(depthRegistrationPanel.getFrame(), depthRegistrationPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Update start/end depths", "Do you want to update the start and end depth for all measurements in the group?", null, breezeActionEvent -> {
                CoreReg.updateStartEndDepth(this.measurement.getParent().getChildList());
                depthRegistrationPanel.showEntry(this.measurement, null);
            })));
            sectionPanel.addComponentHorizontal(this.warningLabel);
            this.warningLabel.setVisible(false);
        }

        public void setEndDepth(Measurement measurement) {
            double d = measurement.getCoreReg().getEndDepth(measurement);
            measurement.getProperties().setPropertyLocal("logging/endDepth", RtDataFormat.toStringAll(d));
            this.setMeasurement(measurement);
        }

        public void setMeasurement(Measurement measurement) {
            this.measurement = measurement;
            SpatialDescriptor.SiUnit siUnit = measurement.getWorkflow().getDefaultUnit();
            for (BreezeInputField.Number number : this.loggingFields) {
                number.setValue(DepthRegistrationPanel.format(measurement.getProperties().getPropertyDoubleLocal("logging/" + number.getName(), 0.0) * this.depthPanel.getFactor()));
                number.setUnit(siUnit.getUnit());
            }
            this.warningLabel.setVisible(measurement.getCoreReg().version == 0);
        }
    }

    public static enum DepthMode {
        Core(255, 204, 0, 100),
        True(0, 204, 255, 255),
        Rubble(0, 204, 255, 100),
        Loss(205, 0, 0, 100),
        Comp(205, 204, 255, 150),
        Note(247, 241, 138, 255);

        public Color color;

        private DepthMode(int n2, int n3, int n4, int n5) {
            this.color = new Color(n2, n3, n4, n5);
        }

        public boolean isArea() {
            return this.equals((Object)Core) || this.equals((Object)Rubble) || this.equals((Object)Loss) || this.equals((Object)Comp);
        }

        public static DepthMode parse(String string) {
            for (DepthMode depthMode : DepthMode.values()) {
                if (!string.equalsIgnoreCase(depthMode.name())) continue;
                return depthMode;
            }
            return Core;
        }
    }

    public class LinesPanel
    extends AbstractBreezeCustomPanel {
        private final BreezeInputField linesInputField = new BreezeInputField.Number("Enter number of lines", 0.0, "");
        private final BreezeInputField lineWidthInputField = new BreezeInputField.Number("Line width", 0.0, "");
        private final BreezeComboBoxInputField<String> directionInputField = new BreezeComboBoxInputField("Direction");

        public LinesPanel() {
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.linesInputField, GridBagHelper.create(0, new Insets(36, 0, 0, 0)));
            this.add((Component)this.lineWidthInputField, GridBagHelper.create(1, new Insets(36, 0, 0, 0)));
            this.directionInputField.addItem("Vertical");
            this.directionInputField.addItem("Horizontal");
            GridBagConstraints gridBagConstraints = GridBagHelper.createLast(2, new Insets(36, 0, 0, 0));
            gridBagConstraints.fill = 2;
            this.add(this.directionInputField, gridBagConstraints);
            this.setPreferredSize(new Dimension(500, 500));
            CoreReg coreReg = DepthRegistrationPanel.this.measurement.getCoreReg();
            if (coreReg.hasData()) {
                this.linesInputField.setValue(coreReg.lines.size());
                this.lineWidthInputField.setValue(coreReg.lineWidth);
                this.directionInputField.setValue(coreReg.direction);
            } else {
                XmlProperties xmlProperties = DepthRegistrationPanel.this.measurement.getWorkflow().getProperties();
                this.linesInputField.setValue(xmlProperties.getPropertyIntLocal("depth/lines", 3));
                this.lineWidthInputField.setValue(xmlProperties.getPropertyIntLocal("depth/width", 50));
                this.directionInputField.setValue(xmlProperties.getPropertyLocal("depth/direction", "Vertical"));
            }
            this.linesInputField.requestFocusAndSelectAll();
        }

        public void apply() {
            Object object;
            Entry entry;
            CoreReg coreReg = DepthRegistrationPanel.this.measurement.getCoreReg();
            boolean bl = coreReg.hasData();
            coreReg.lineWidth = this.lineWidthInputField.getNumberInt();
            coreReg.direction = this.directionInputField.getSelectedItem();
            coreReg.setLines(this.linesInputField.getNumberInt(), DepthRegistrationPanel.this.depthPanel.getMaxPositionOrigWidth());
            if (!bl && (entry = DepthRegistrationPanel.this.measurement.getPrevious()) != null) {
                object = ((Measurement)entry).getCoreReg();
                MeasurementDepthInfo measurementDepthInfo = new MeasurementDepthInfo(DepthRegistrationPanel.this.measurement);
                double d = ((CoreReg)object).getEndDepth((Measurement)entry);
                measurementDepthInfo.updateDepth(d);
                if (((CoreReg)object).lines.size() == coreReg.lines.size()) {
                    for (int i = 0; i < coreReg.lines.size(); ++i) {
                        coreReg.lines.get(i).setPosition(((CoreReg)object).lines.get((int)i).position);
                    }
                }
            }
            DepthRegistrationPanel.this.measurement.save();
            entry = DepthRegistrationPanel.this.measurement.getWorkflow();
            object = ((Workflow)entry).getProperties();
            ((XmlProperties)object).setPropertyLocal("depth/lines", String.valueOf(coreReg.lines.size()));
            ((XmlProperties)object).setPropertyLocal("depth/width", String.valueOf(coreReg.lineWidth));
            ((XmlProperties)object).setPropertyLocal("depth/direction", coreReg.direction);
            ((Workflow)entry).save();
        }

        @Override
        public boolean usePreferredSize() {
            return true;
        }

        @Override
        public Object getResult() {
            return null;
        }
    }

    public static class MeasurementDepthInfo {
        public final SpatialDescriptor.SiUnit unit;
        public final double startDepth;
        public final double factor;
        private final Measurement measurement;

        public MeasurementDepthInfo(Measurement measurement) {
            this.measurement = measurement;
            float f = RtDataFormat.toNumberFloat(measurement.getMetaProperties().getMetaValue("Resolution", "1"));
            this.unit = measurement.getWorkflow().getDefaultUnit();
            this.startDepth = measurement.getProperties().getPropertyDoubleLocal("logging/startDepth", 0.0);
            CoreReg coreReg = measurement.getCoreReg();
            this.factor = coreReg.version == 0 && this.unit.checkOldFactor() ? (double)f * this.unit.getOldFactor() : (double)f * this.unit.getFactor();
        }

        public void updateDepth(double d) {
            this.measurement.getProperties().setPropertyLocal("logging/startDepth", RtDataFormat.toStringAll(d));
            this.measurement.getProperties().setPropertyLocal("logging/endDepth", "0");
        }
    }

    public static class CompartmentPanel
    extends AbstractBreezeCustomPanel {
        private final BreezeInputField startPositionInputField = new BreezeInputField.Number("Start position", 0.0, "");
        private final BreezeInputField compartmentsInputField = new BreezeInputField.Number("Number of compartments", 1.0, "");
        private final BreezeInputField stepInputField = new BreezeInputField.Number("Compartment interval length", 1.0, " ");
        private final BreezeInputField gapInputField = new BreezeInputField.Number("Gap", 1.0, "");
        private final Measurement measurement;
        private final MeasurementDepthInfo depthInfo;

        public CompartmentPanel(Measurement measurement, MeasurementDepthInfo measurementDepthInfo, CoreReg.CompArea compArea) {
            this.measurement = measurement;
            this.depthInfo = measurementDepthInfo;
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            this.startPositionInputField.setUnit(measurementDepthInfo.unit.getUnit());
            this.startPositionInputField.setUnitLabelWidth(50);
            this.add((Component)this.startPositionInputField, GridBagHelper.create(0, new Insets(24, 0, 0, 0)));
            this.compartmentsInputField.setUnitLabelWidth(50);
            this.add((Component)this.compartmentsInputField, GridBagHelper.create(1, new Insets(24, 0, 0, 0)));
            this.stepInputField.setUnit(measurementDepthInfo.unit.getUnit());
            this.stepInputField.setUnitLabelWidth(50);
            this.add((Component)this.stepInputField, GridBagHelper.create(2, new Insets(24, 0, 0, 0)));
            this.gapInputField.setUnit(measurementDepthInfo.unit.getUnit());
            this.gapInputField.setUnitLabelWidth(50);
            this.add((Component)this.gapInputField, GridBagHelper.createLast(3, new Insets(24, 0, 0, 0)));
            this.setPreferredSize(new Dimension(500, 500));
            if (compArea != null) {
                this.startPositionInputField.setValue(compArea.depth * measurementDepthInfo.factor);
                this.compartmentsInputField.setValue(compArea.number);
                this.stepInputField.setValue(compArea.stepLength * measurementDepthInfo.factor);
                this.gapInputField.setValue(compArea.gap * measurementDepthInfo.factor);
            } else {
                XmlProperties xmlProperties = measurement.getWorkflow().getProperties();
                this.compartmentsInputField.setValue(xmlProperties.getPropertyIntLocal("depth/compNumber", 10));
                this.stepInputField.setValue(xmlProperties.getPropertyDoubleLocal("depth/compStepLength", 15.0) * measurementDepthInfo.factor);
                this.gapInputField.setValue(xmlProperties.getPropertyDoubleLocal("depth/compGap", 5.0) * measurementDepthInfo.factor);
            }
            this.startPositionInputField.requestFocusAndSelectAll();
        }

        public void apply(CoreReg.CompArea compArea) {
            compArea.depth = this.startPositionInputField.getNumber() / this.depthInfo.factor;
            compArea.number = this.compartmentsInputField.getNumberInt();
            compArea.stepLength = this.stepInputField.getNumber() / this.depthInfo.factor;
            compArea.gap = this.gapInputField.getNumber() / this.depthInfo.factor;
            Workflow workflow = this.measurement.getWorkflow();
            XmlProperties xmlProperties = workflow.getProperties();
            xmlProperties.setPropertyLocal("depth/compNumber", RtDataFormat.toString(compArea.number));
            xmlProperties.setPropertyLocal("depth/compStepLength", RtDataFormat.toString(compArea.stepLength));
            xmlProperties.setPropertyLocal("depth/compGap", RtDataFormat.toString(compArea.gap));
            workflow.save();
        }

        @Override
        public boolean usePreferredSize() {
            return true;
        }

        @Override
        public Object getResult() {
            return null;
        }
    }

    public static enum EdgePos {
        Start,
        End,
        None;

    }
}

