/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.usgs;

import java.awt.Graphics;
import java.util.Optional;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.AbstractModelDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.ClassParameterDescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AddParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.util.CustomRenderingDescriptor;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.map.register.RegInfo;

public class DominantMineralDescriptor
extends AbstractModelDescriptor
implements ClassParameterDescriptorInterface,
CustomRenderingDescriptor,
AddParameter.AddFunctionWithAliasInterface {
    private NumberParameter numberParameter = new NumberParameter("number", "Number", 10.0, "", new MinMax(1.0f, 10.0f));

    public DominantMineralDescriptor(AbstractDescriptorInfo abstractDescriptorInfo) {
        super(abstractDescriptorInfo);
        this.addParameter(this.numberParameter);
        this.addParameter(new AddParameter(this, "", true, this.numberParameter));
        for (int i = 1; i <= 10; ++i) {
            this.addOutput("dominant" + i + "Class");
            this.addOutput("dominant" + i + "Percent");
        }
    }

    @Override
    public AddParameter.AddNodeList getAddNodes() {
        AddParameter.AddNodeList addNodeList = new AddParameter.AddNodeList();
        for (int i = 1; i < this.numberParameter.getValueInt() * 2; ++i) {
            DescriptorTreeNode descriptorTreeNode = new DescriptorTreeNode();
            DominantMineralDescriptor dominantMineralDescriptor = (DominantMineralDescriptor)this.clone();
            descriptorTreeNode.setFunction(dominantMineralDescriptor);
            descriptorTreeNode.setIndex(i);
            addNodeList.add(new AddParameter.AddNode(descriptorTreeNode, this.getNode()));
        }
        return addNodeList;
    }

    @Override
    public boolean support(AbstractBreezeFunction abstractBreezeFunction) {
        return abstractBreezeFunction instanceof DominantMineralDescriptor;
    }

    @Override
    public boolean showOutputs() {
        return false;
    }

    @Override
    public boolean isVisible(int n) {
        return n == 0;
    }

    @Override
    public BasicAnalyse.ModelType getModelType() {
        return BasicAnalyse.ModelType.Classification;
    }

    @Override
    public Factor getFactor(int n) {
        if (n % 2 == 0) {
            return super.getFactor(n);
        }
        return null;
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        CategoryFactor categoryFactor;
        CatClass catClass;
        Factor factor = this.getFactor(n);
        if (n % 2 == 0 && factor instanceof CategoryFactor && (catClass = (categoryFactor = (CategoryFactor)factor).getClassByValueIdx((int)f)) != null) {
            return catClass.getName();
        }
        return RtDataFormat.toPercent(f, false);
    }

    @Override
    public String getUnit(FunctionTreeNode functionTreeNode, int n) {
        if (n % 2 == 0) {
            return "";
        }
        return "%";
    }

    @Override
    public MinMax getMinMax(int n) {
        if (n % 2 == 0) {
            return null;
        }
        return MinMax.Percent;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        if (textType.equals((Object)FunctionTreeNode.TextType.Table)) {
            return this.format(functionTreeNode, StringHelper.formatLabel(this.getOutputName(n)));
        }
        return "Dominant mineral";
    }

    @Override
    public CategoryFactor getCategoryFactor(FunctionTreeNode functionTreeNode) {
        Factor factor = this.getFactor(functionTreeNode.getIndex());
        if (factor instanceof CategoryFactor) {
            CategoryFactor categoryFactor = (CategoryFactor)factor;
            return categoryFactor;
        }
        return null;
    }

    @Override
    public boolean renderCellAt(int n) {
        return n % 2 == 0;
    }

    @Override
    public void renderCell(Sample sample, float f, Graphics graphics, int n, int n2, int n3) {
        CategoryFactor categoryFactor;
        if (n3 % 2 == 0 && (categoryFactor = (CategoryFactor)this.getFactor(n3)) != null) {
            CatClass.render(graphics, categoryFactor.getClassByValueIdx((int)f), n2);
        }
    }

    @Override
    public CustomRenderingDescriptor.RenderData getStringValueAndOptionalBoxColor(String string, FunctionResult functionResult) {
        if (functionResult.getIndex() % 2 == 0) {
            return new CustomRenderingDescriptor.RenderData(string, Optional.of(FunctionResult.getCategoryColorHexString(functionResult)));
        }
        return new CustomRenderingDescriptor.RenderData(string, Optional.empty(), true);
    }

    @Override
    public boolean isCalculatePixel() {
        return true;
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "count";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new DominantMineralDescriptor(this);
        }

        public String toString() {
            return "DominantMineral";
        }

        @Override
        public String getDescription() {
            return "Dominant mineral class and percent";
        }

        @Override
        public String getShortDescription() {
            return "Dominant mineral";
        }

        @Override
        public RegInfo.LicenseFeature getLicenseFeature() {
            return RegInfo.LicenseFeature.Geo;
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Geo;
        }

        @Override
        public String getHelp() {
            return "dominant-mineral";
        }
    }
}

