/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.usgs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.map.common.error.ErrorHandler;

public class MicaCommandFile {
    public Alias alias;
    public HashMap<Integer, GlobalNotFeature> globalNotFeatures = new HashMap();
    public List<MicaReference> references = new ArrayList<MicaReference>();
    public int[] deletedChannels;
    public String fileDnColors;

    public MicaCommandFile(List<String> list) {
        Lines lines = new Lines(this, list);
        for (int i = 0; i < lines.size(); ++i) {
            int n;
            String string = lines.next();
            if (string.startsWith("FILE_DN_COLORS:")) {
                this.fileDnColors = MicaCommandFile.getValue(string);
                continue;
            }
            if (string.startsWith("DELETED_CHANNELS:")) {
                this.deletedChannels = MicaCommandFile.getInts(MicaCommandFile.getValue(string), ",");
                continue;
            }
            if (string.startsWith("NUM_ALIAS:")) {
                n = MicaCommandFile.getInt(string);
                this.alias = new Alias(lines, n);
                continue;
            }
            if (string.startsWith("NUM_NOT_FEATURES:")) {
                n = MicaCommandFile.getInt(string);
                this.globalNotFeatures = MicaCommandFile.readGlobalNotFeatures(this.alias, lines, n);
                continue;
            }
            if (string.startsWith("NUM_REFERENCE_ENTRIES:")) {
                n = MicaCommandFile.getInt(string);
                this.references = MicaCommandFile.readReferences(this.alias, lines, n);
                continue;
            }
            if (string.startsWith("END_CMDFILE:")) break;
        }
    }

    private static HashMap<Integer, GlobalNotFeature> readGlobalNotFeatures(Alias alias, Lines lines, int n) {
        HashMap<Integer, GlobalNotFeature> hashMap = new HashMap<Integer, GlobalNotFeature>();
        while (hashMap.size() < n) {
            String string = lines.next();
            if (!string.startsWith("NOT_FEATURE_ID:")) continue;
            GlobalNotFeature globalNotFeature = new GlobalNotFeature(alias, lines);
            hashMap.put(globalNotFeature.id, globalNotFeature);
            if (hashMap.size() != n) continue;
            break;
        }
        return hashMap;
    }

    private static List<MicaReference> readReferences(Alias alias, Lines lines, int n) {
        ArrayList<MicaReference> arrayList = new ArrayList<MicaReference>();
        while (arrayList.size() < n) {
            String string = lines.next();
            if (!string.startsWith("REFERENCE_SPECPR_RECORD:")) continue;
            arrayList.add(new MicaReference(alias, lines));
            if (arrayList.size() != n) continue;
            break;
        }
        return arrayList;
    }

    private static String getValue(String string) {
        return string.split(":", 2)[1].trim();
    }

    private static int getInt(String string) {
        return RtDataFormat.toNumberInt(MicaCommandFile.getValue(string));
    }

    private static double getFloat(String string) {
        return RtDataFormat.toNumber(MicaCommandFile.getValue(string));
    }

    private static String[] getStrings(String string) {
        return MicaCommandFile.getStrings(string, " ");
    }

    private static String[] getStrings(String string2, String string3) {
        return (String[])Arrays.stream(string2.split(string3)).filter(string -> string.trim().length() > 0).toArray(String[]::new);
    }

    private static int[] getInts(String string, String string2) {
        String[] stringArray = MicaCommandFile.getStrings(string, string2);
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = RtDataFormat.toNumberInt(stringArray[i]);
        }
        return nArray;
    }

    private static double getNumber(Alias alias, String string) {
        return RtDataFormat.toNumber(MicaCommandFile.getAliasOrValue(alias, string));
    }

    private static double[] getNumbers(Alias alias, String string) {
        String[] stringArray = MicaCommandFile.getStrings(string);
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dArray[i] = RtDataFormat.toNumber(MicaCommandFile.getAliasOrValue(alias, stringArray[i]));
        }
        return dArray;
    }

    private static String getAliasOrValue(Alias alias, String string) {
        if (string.startsWith("[")) {
            return (String)alias.get(string);
        }
        return string;
    }

    private class Lines {
        private final List<String> lines;
        private int ii;
        private String current;

        public Lines(MicaCommandFile micaCommandFile, List<String> list) {
            this.lines = list;
        }

        public int size() {
            return this.lines.size();
        }

        private String previous() {
            int n = this.ii - 2;
            if (n >= 0 && n < this.lines.size()) {
                return this.lines.get(n);
            }
            return "";
        }

        private String current() {
            return this.current;
        }

        private String next() {
            while (this.ii < this.lines.size()) {
                String string;
                if ((string = this.lines.get(this.ii++)).startsWith(";")) continue;
                this.current = string;
                return this.current;
            }
            throw new ErrorHandler.InformationMessageException("No more lines to read");
        }

        private String next(String string) {
            String string2 = this.next().trim();
            while (!string2.startsWith(string)) {
                string2 = this.next().trim();
            }
            return string2;
        }

        private String peek() {
            int n = this.ii;
            while (n < this.lines.size()) {
                String string;
                if ((string = this.lines.get(n++)).startsWith(";")) continue;
                return string;
            }
            return "";
        }
    }

    private static class Alias
    extends HashMap<String, String> {
        public Alias(Lines lines, int n) {
            while (this.size() < n) {
                String string = lines.next();
                if (!string.startsWith("ALIAS:")) continue;
                String string2 = MicaCommandFile.getValue(string);
                String[] stringArray = MicaCommandFile.getStrings(string2);
                this.put(stringArray[0], stringArray[1]);
            }
        }
    }

    public static class GlobalNotFeature {
        public final int id;
        public final String file;
        public final int record;
        public final double[] continuumEndpts;

        public GlobalNotFeature(Alias alias, Lines lines) {
            this.id = MicaCommandFile.getInt(lines.current());
            String[] stringArray = MicaCommandFile.getStrings(MicaCommandFile.getValue(lines.next()));
            this.file = MicaCommandFile.getAliasOrValue(alias, stringArray[0]);
            this.record = RtDataFormat.toNumberInt(stringArray[1]);
            this.continuumEndpts = MicaCommandFile.getNumbers(alias, MicaCommandFile.getValue(lines.next()));
        }
    }

    public static class MicaReference {
        public final String file;
        public final int record;
        public final String title;
        public final String name;
        public final List<DiagnosticFeature> features = new ArrayList<DiagnosticFeature>();
        public final List<NotFeature> notFeatures = new ArrayList<NotFeature>();
        public double[] weightFitDepthConstains;

        public MicaReference(Alias alias, Lines lines) {
            int n;
            this.title = this.getTitle(lines.previous());
            String[] stringArray = MicaCommandFile.getStrings(MicaCommandFile.getValue(lines.current()));
            this.file = MicaCommandFile.getAliasOrValue(alias, stringArray[0]);
            this.record = RtDataFormat.toNumberInt(stringArray[1]);
            this.name = MicaCommandFile.getValue(lines.next());
            int[] nArray = MicaCommandFile.getInts(MicaCommandFile.getValue(lines.next()), " ");
            for (n = 0; n < nArray[0]; ++n) {
                this.features.add(new DiagnosticFeature(alias, lines));
            }
            for (n = 0; n < nArray[1]; ++n) {
                this.notFeatures.add(new NotFeature(alias, lines));
            }
            this.weightFitDepthConstains = MicaCommandFile.getNumbers(alias, MicaCommandFile.getValue(lines.next()));
        }

        private String getTitle(String string) {
            if (string.startsWith(";....")) {
                String string2 = string.split("=", 2)[1].trim();
                if (string2.startsWith("\"") && string2.endsWith("\"")) {
                    return string2.substring(1, string2.length() - 1);
                }
                return string2;
            }
            return null;
        }
    }

    public static class NotFeature {
        public String type;
        public final int globalId;
        public final double fitContraints;
        public final double[] relativeDepthContains;
        public final double[] absolutDepthContains;

        public NotFeature(Alias alias, Lines lines) {
            this.type = MicaCommandFile.getValue(lines.next("FEATURE_TYPE"));
            this.globalId = MicaCommandFile.getInt(lines.next());
            this.fitContraints = MicaCommandFile.getNumber(alias, MicaCommandFile.getValue(lines.next()));
            String string = lines.next();
            if (string.startsWith("NOT_FEATURE_ABSOLUTE_DEPTH_CONSTRAINTS")) {
                this.relativeDepthContains = null;
                this.absolutDepthContains = MicaCommandFile.getNumbers(alias, MicaCommandFile.getValue(string));
            } else {
                this.relativeDepthContains = MicaCommandFile.getNumbers(alias, MicaCommandFile.getValue(string));
                this.absolutDepthContains = null;
            }
        }
    }

    public static class DiagnosticFeature {
        public final String type;
        public final double weight;
        public final double[] continuumEndpts;
        public final double[] continuumConstrains;
        public final double fitContraints;
        public final double[] depthContains;

        public DiagnosticFeature(Alias alias, Lines lines) {
            this.type = MicaCommandFile.getValue(lines.next("FEATURE_TYPE"));
            this.weight = MicaCommandFile.getFloat(lines.next());
            this.continuumEndpts = MicaCommandFile.getNumbers(alias, MicaCommandFile.getValue(lines.next()));
            this.continuumConstrains = MicaCommandFile.getNumbers(alias, MicaCommandFile.getValue(lines.next()));
            this.fitContraints = MicaCommandFile.getNumber(alias, MicaCommandFile.getValue(lines.next()));
            this.depthContains = MicaCommandFile.getNumbers(alias, MicaCommandFile.getValue(lines.next()));
        }
    }
}

