/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.usgs;

import java.awt.Color;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.usgs.MicaCommandFile;
import se.prediktera.breeze.common.realtime.descriptor.usgs.SpecprRecord;
import se.prediktera.breeze.common.realtime.descriptor.usgs.UsgsMicaFile;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;

public class MicaEndMemberSetup
extends RtModelParameters.RtModuleSetup {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private final InformationPanel.InformationList information = new InformationPanel.InformationList();
    private final UsgsMicaFile.EndMemberReference endMemberReference;

    public MicaEndMemberSetup(MicaCommandFile micaCommandFile, UsgsMicaFile.EndMemberReference endMemberReference, MicaCommandFile.MicaReference micaReference, ByteBuffer byteBuffer, UsgsMicaFile.DnColors dnColors, double d) throws IOException {
        super("endMember");
        MicaCommandFile.GlobalNotFeature globalNotFeature;
        MicaCommandFile.NotFeature notFeature;
        Color color;
        Object object;
        this.endMemberReference = endMemberReference;
        SpecprRecord specprRecord = new SpecprRecord(byteBuffer, micaReference.record);
        double[] dArray = SpecprRecord.readData(byteBuffer, new SpecprRecord(byteBuffer, (int)specprRecord.irwav));
        this.add(new RtModelParameters.RtParameterVector("wavelength", MicaEndMemberSetup.scale(dArray, d)));
        this.add(new RtModelParameters.RtParameterVector("vector", SpecprRecord.readData(byteBuffer, specprRecord)));
        this.add(new RtModelParameters.RtParameterString("name", micaReference.name));
        this.add(new RtModelParameters.RtParameterString("title", micaReference.title));
        List<MicaCommandFile.DiagnosticFeature> list = micaReference.features;
        this.add(new RtModelParameters.RtParameterScalar("numberOfRegions", list.size()));
        double[] dArray2 = new double[list.size() * 2];
        double[] dArray3 = new double[list.size() * 2];
        double[] dArray4 = new double[list.size()];
        double[] dArray5 = new double[list.size() * 8];
        double[] dArray6 = new double[list.size()];
        double[] dArray7 = new double[list.size() * 2];
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            dArray2[i * 2] = ((MicaCommandFile.DiagnosticFeature)object).continuumEndpts[0];
            dArray2[i * 2 + 1] = ((MicaCommandFile.DiagnosticFeature)object).continuumEndpts[1];
            dArray3[i * 2] = ((MicaCommandFile.DiagnosticFeature)object).continuumEndpts[((MicaCommandFile.DiagnosticFeature)object).continuumEndpts.length - 2];
            dArray3[i * 2 + 1] = ((MicaCommandFile.DiagnosticFeature)object).continuumEndpts[((MicaCommandFile.DiagnosticFeature)object).continuumEndpts.length - 1];
            dArray4[i] = ((MicaCommandFile.DiagnosticFeature)object).weight;
            System.arraycopy(((MicaCommandFile.DiagnosticFeature)object).continuumConstrains, 0, dArray5, i * 8, 8);
            dArray6[i] = ((MicaCommandFile.DiagnosticFeature)object).fitContraints;
            System.arraycopy(((MicaCommandFile.DiagnosticFeature)object).depthContains, 0, dArray7, i * 2, 2);
        }
        this.add(new RtModelParameters.RtParameterVector("leftpos", MicaEndMemberSetup.scale(dArray2, d)));
        this.add(new RtModelParameters.RtParameterVector("rightpos", MicaEndMemberSetup.scale(dArray3, d)));
        if (dnColors != null && (color = (Color)dnColors.get(micaReference.name)) != null) {
            this.add(new RtModelParameters.RtParameterVector("rgb", new int[]{color.getRed(), color.getGreen(), color.getBlue()}));
        }
        this.add(new RtModelParameters.RtParameterVector("featureweight", dArray4));
        this.add(new RtModelParameters.RtParameterVector("continuumconstraints", dArray5));
        this.add(new RtModelParameters.RtParameterVector("fitconstraints", dArray6));
        this.add(new RtModelParameters.RtParameterVector("depthconstraints", dArray7));
        this.add(new RtModelParameters.RtParameterVector("weightedfitdepthconstraints", micaReference.weightFitDepthConstains));
        List<MicaCommandFile.NotFeature> list2 = micaReference.notFeatures;
        this.add(new RtModelParameters.RtParameterScalar("numberOfNotFeatures", list2.size()));
        object = new double[list2.size() * 2];
        double[] dArray8 = new double[list2.size() * 2];
        double[] dArray9 = new double[list2.size()];
        double[] dArray10 = new double[list2.size() * 2];
        double[] dArray11 = new double[list2.size()];
        for (int i = 0; i < list2.size(); ++i) {
            String string = "notFeature" + (i + 1);
            notFeature = list2.get(i);
            globalNotFeature = micaCommandFile.globalNotFeatures.get(notFeature.globalId);
            if (globalNotFeature == null) {
                throw new RuntimeException("Global feature with id = " + notFeature.globalId + " is missing for not feature");
            }
            SpecprRecord specprRecord2 = new SpecprRecord(byteBuffer, globalNotFeature.record);
            double[] dArray12 = SpecprRecord.readData(byteBuffer, new SpecprRecord(byteBuffer, (int)specprRecord2.irwav));
            this.add(new RtModelParameters.RtParameterVector(string + "wavelength", MicaEndMemberSetup.scale(dArray12, d)));
            this.add(new RtModelParameters.RtParameterVector(string + "vector", SpecprRecord.readData(byteBuffer, specprRecord2)));
            object[i * 2] = globalNotFeature.continuumEndpts[0];
            object[i * 2 + 1] = globalNotFeature.continuumEndpts[1];
            dArray8[i * 2] = globalNotFeature.continuumEndpts[globalNotFeature.continuumEndpts.length - 2];
            dArray8[i * 2 + 1] = globalNotFeature.continuumEndpts[globalNotFeature.continuumEndpts.length - 1];
            dArray9[i] = notFeature.fitContraints;
            for (int j = 0; j < 2; ++j) {
                dArray10[i * 2 + j] = notFeature.relativeDepthContains != null ? notFeature.relativeDepthContains[j] : -99.0;
            }
            dArray11[i] = notFeature.absolutDepthContains != null ? notFeature.absolutDepthContains[0] : -99.0;
        }
        if (list2.size() > 0) {
            this.add(new RtModelParameters.RtParameterVector("notFeatureLeftPos", MicaEndMemberSetup.scale((double[])object, d)));
            this.add(new RtModelParameters.RtParameterVector("notFeatureRightPos", MicaEndMemberSetup.scale(dArray8, d)));
            this.add(new RtModelParameters.RtParameterVector("notFeatureFitconstraints", dArray9));
            this.add(new RtModelParameters.RtParameterVector("notFeatureRelativeDepthconstraints", dArray10));
            this.add(new RtModelParameters.RtParameterVector("notFeatureAbsolutDepthconstraints", dArray11));
            double[] dArray13 = new double[list2.size()];
            Arrays.fill(dArray13, -99.0);
            for (int i = 0; i < list2.size(); ++i) {
                int n;
                notFeature = list2.get(i);
                if (notFeature.relativeDepthContains == null) continue;
                globalNotFeature = micaCommandFile.globalNotFeatures.get(notFeature.globalId);
                if (globalNotFeature.record == -99 || (n = MicaEndMemberSetup.getReferenceIndexForNotFeature(micaCommandFile.references, globalNotFeature.record)) < 0) continue;
                dArray13[i] = n;
            }
            this.add(new RtModelParameters.RtParameterVector("notFeatureRelativeDepthConstraintRecord", dArray13));
        }
        this.information.add("Title", micaReference.title);
        this.information.add("Record", specprRecord.number);
        this.information.add("Username", specprRecord.username);
        this.information.add("Channels", specprRecord.itchan);
        this.information.add("Measured", sdf.format(MicaEndMemberSetup.getDate(specprRecord.jdateb / 10L)));
        this.information.add("Processed", sdf.format(MicaEndMemberSetup.getDate(specprRecord.jdatea / 10L)));
    }

    public UsgsMicaFile.EndMemberReference getEndMemberReference() {
        return this.endMemberReference;
    }

    public InformationPanel.InformationList getInformation() {
        return this.information;
    }

    private static int getReferenceIndexForNotFeature(List<MicaCommandFile.MicaReference> list, int n) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).record != n) continue;
            return i;
        }
        return -1;
    }

    public static double[] scale(double[] dArray, double d) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d;
        }
        return dArray;
    }

    public static Date getDate(double d) {
        double d2 = d + 5.787037037037037E-6;
        int n = (int)d2;
        if (n >= 588829) {
            int n2 = (int)(((double)(n - 1867216) - 0.25) / 36524.25);
            n = n + 1 + n2 - n2 / 4;
        }
        int n3 = n + 1524;
        int n4 = (int)(6680.0 + ((double)(n3 - 2439870) - 122.1) / 365.25);
        int n5 = 365 * n4 + n4 / 4;
        int n6 = (int)((double)(n3 - n5) / 30.6001);
        int n7 = n3 - n5 - (int)(30.6001 * (double)n6);
        int n8 = n6 - 1;
        if (n8 > 12) {
            n8 -= 12;
        }
        int n9 = n4 - 4715;
        if (n8 > 2) {
            --n9;
        }
        if (n9 <= 0) {
            --n9;
        }
        return new GregorianCalendar(n9, n8, n7).getTime();
    }
}

