/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.usgs;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.usgs.MicaEndMemberSetup;
import se.prediktera.breeze.common.realtime.descriptor.usgs.SpecprRecord;
import se.prediktera.breeze.common.realtime.descriptor.usgs.UsgsMicaFile;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.breeze.common.realtime.unmixing.SelectMembersPanel;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;
import se.prediktera.map.common.error.Logg;

public class SpecprFile {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private final List<Reference> references = new ArrayList<Reference>();
    private final double wf;

    public SpecprFile(File file, Workflow workflow) {
        this.wf = UsgsMicaFile.calculateWavelengthFactor(workflow);
        ByteBuffer byteBuffer = SpecprFile.readSpecprBuffer(file);
        int n = byteBuffer.capacity() / 1536;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            try {
                SpecprRecord specprRecord = new SpecprRecord(byteBuffer, i);
                if (specprRecord.data == null || specprRecord.irwav * 1536L >= (long)byteBuffer.capacity()) continue;
                RtModelParameters.RtModuleSetup rtModuleSetup = new RtModelParameters.RtModuleSetup("Data");
                SpecprRecord specprRecord2 = new SpecprRecord(byteBuffer, (int)specprRecord.irwav);
                if (specprRecord2.data == null) continue;
                double[] dArray = SpecprRecord.readData(byteBuffer, specprRecord2);
                rtModuleSetup.add(new RtModelParameters.RtParameterVector("wavelength", MicaEndMemberSetup.scale(dArray, this.wf)));
                rtModuleSetup.add(new RtModelParameters.RtParameterVector("vector", SpecprRecord.readData(byteBuffer, specprRecord)));
                Reference reference = new Reference(specprRecord.title);
                reference.setWavelength(rtModuleSetup.getVectorFloat("wavelength"));
                reference.setMatrix(new FloatMatrix(rtModuleSetup.getVectorFloat("vector")));
                reference.setColor(RtPerfectSpread.generateColor(i), true);
                SpecprFile.addRecordInformation(specprRecord, reference.getInformation());
                this.references.add(reference);
                continue;
            }
            catch (Exception exception) {
                if (!bl) continue;
                Logg.error((String)("Error parsing file: " + file.getAbsolutePath()), (Throwable)exception);
                bl = false;
            }
        }
    }

    public static void addRecordInformation(SpecprRecord specprRecord, InformationPanel.InformationList informationList) {
        informationList.add("Title", specprRecord.title);
        informationList.add("Record", specprRecord.number);
        informationList.add("Username", specprRecord.username);
        informationList.add("Channels", specprRecord.itchan);
        informationList.add("Measured", sdf.format(MicaEndMemberSetup.getDate(specprRecord.jdateb / 10L)));
        informationList.add("Processed", sdf.format(MicaEndMemberSetup.getDate(specprRecord.jdatea / 10L)));
    }

    public static ByteBuffer readSpecprBuffer(File file) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)file.length());
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 FileChannel fileChannel = fileInputStream.getChannel();){
                fileChannel.read(byteBuffer);
            }
            return byteBuffer;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public static void main(String[] stringArray) {
        SpecprFile specprFile = new SpecprFile(new File("C:/temp/usgs/s07hyspexvswir3177"), new WorkflowWithoutIO());
        JFrame jFrame = new JFrame("Test");
        jFrame.setDefaultCloseOperation(3);
        List<Reference> list = specprFile.getReferences();
        if (list.size() == 0) {
            System.exit(0);
        }
        jFrame.getContentPane().add(new SelectMembersPanel(null, list, null, null));
        jFrame.setSize(800, 800);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }
}

