/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.usgs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class SpecprRecord {
    public static final int lengthOfRecord = 1536;
    private static final double BAD_DATA_VALUE = -1.23E32;
    public int type;
    public final int number;
    public final byte[] header;
    public String title;
    public String username;
    public long iscta;
    public long isctb;
    public long jdatea;
    public long jdateb;
    public long istb;
    public long isra;
    public long isdec;
    public long itchan;
    public long irmas;
    public long revs;
    public long iband;
    public long iband2;
    public long irwav;
    public long irespt;
    public long irecno;
    public long itpntr;
    public String ihist;
    public String mhist;
    public long nruns;
    public long siangl;
    public long seangl;
    public long sphase;
    public long iwtrns;
    public long itimch;
    public float xnrm;
    public float scatin;
    public float timint;
    public float tempd;
    public long itxtpt;
    public Object itext;
    public long itxtch;
    public double[] data;
    public String tdata;

    public SpecprRecord(ByteBuffer byteBuffer, int n) throws IOException {
        this.number = n;
        byteBuffer.position(1536 * n);
        this.header = new byte[4];
        byteBuffer.get(this.header);
        int n2 = this.header[3] & 1;
        int n3 = this.header[3] >> 1 & 1;
        if (n2 == 0 && n3 == 0) {
            this.type = 1;
            this.title = this.readString(byteBuffer, 40);
            this.username = this.readString(byteBuffer, 8);
            this.iscta = this.readInt(byteBuffer);
            this.isctb = this.readInt(byteBuffer);
            this.jdatea = this.readInt(byteBuffer);
            this.jdateb = this.readInt(byteBuffer);
            this.istb = this.readInt(byteBuffer);
            this.isra = this.readInt(byteBuffer);
            this.isdec = this.readInt(byteBuffer);
            this.itchan = this.readInt(byteBuffer);
            this.irmas = this.readInt(byteBuffer);
            this.revs = this.readInt(byteBuffer);
            this.iband = this.readInt(byteBuffer);
            this.iband2 = this.readInt(byteBuffer);
            this.irwav = this.readInt(byteBuffer);
            this.irespt = this.readInt(byteBuffer);
            this.irecno = this.readInt(byteBuffer);
            this.itpntr = this.readInt(byteBuffer);
            this.ihist = this.readString(byteBuffer, 60);
            this.mhist = this.readString(byteBuffer, 296);
            this.nruns = this.readInt(byteBuffer);
            this.siangl = this.readInt(byteBuffer);
            this.seangl = this.readInt(byteBuffer);
            this.sphase = this.readInt(byteBuffer);
            this.iwtrns = this.readInt(byteBuffer);
            this.itimch = this.readInt(byteBuffer);
            this.xnrm = this.readFloat(byteBuffer);
            this.scatin = this.readFloat(byteBuffer);
            this.timint = this.readFloat(byteBuffer);
            this.tempd = this.readFloat(byteBuffer);
            this.data = new double[256];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = this.readFloat(byteBuffer);
            }
        } else if (n2 == 1 && n3 == 0) {
            this.type = 2;
            this.data = new double[383];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = this.readFloat(byteBuffer);
            }
        } else if (n2 == 0 && n3 == 1) {
            this.type = 3;
            this.title = this.readString(byteBuffer, 40);
            this.username = this.readString(byteBuffer, 8);
            this.itxtpt = this.readInt(byteBuffer);
            this.itxtch = this.readInt(byteBuffer);
            this.itext = this.readString(byteBuffer, 1476);
        } else if (n2 == 1 && n3 == 1) {
            this.type = 0;
            this.tdata = this.readString(byteBuffer, 1532);
        }
    }

    private long readInt(ByteBuffer byteBuffer) throws IOException {
        return byteBuffer.order(ByteOrder.BIG_ENDIAN).getInt();
    }

    private float readFloat(ByteBuffer byteBuffer) throws IOException {
        return byteBuffer.order(ByteOrder.BIG_ENDIAN).getFloat();
    }

    private String readString(ByteBuffer byteBuffer, int n) throws IOException {
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return new String(byArray, StandardCharsets.UTF_8);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Record:/t" + this.number + "/n");
        stringBuilder.append("Title:/t" + this.title + "/n");
        stringBuilder.append("User:/t" + this.username + "/n");
        stringBuilder.append("Text:/t" + String.valueOf(this.itext) + "/n");
        return stringBuilder.toString();
    }

    public static double[] readData(ByteBuffer byteBuffer, SpecprRecord specprRecord) throws IOException {
        int n = (int)specprRecord.itchan;
        double[] dArray = new double[n];
        int n2 = n;
        int n3 = 0;
        int n4 = specprRecord.data.length;
        SpecprRecord specprRecord2 = specprRecord;
        while (n2 > 0) {
            SpecprRecord.read(specprRecord2.data, dArray, Math.min(n2, n4), n3);
            if ((n2 -= n4) <= 0) continue;
            specprRecord2 = new SpecprRecord(byteBuffer, specprRecord2.number + 1);
            n3 += n4;
            n4 = specprRecord2.data.length;
        }
        return dArray;
    }

    private static void read(double[] dArray, double[] dArray2, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            if (!(dArray[i] > -1.23E32)) continue;
            dArray2[n2 + i] = dArray[i];
        }
    }

    public static List<SpecprRecord> writeData(ByteBuffer byteBuffer, int n, double[] dArray, int n2) throws IOException {
        ArrayList<SpecprRecord> arrayList = new ArrayList<SpecprRecord>();
        int n3 = n2;
        int n4 = 0;
        int n5 = n;
        while (n3 > 0) {
            SpecprRecord specprRecord = new SpecprRecord(byteBuffer, n5);
            arrayList.add(specprRecord);
            int n6 = specprRecord.data.length;
            int n7 = Math.min(n3, n6);
            SpecprRecord.write(dArray, specprRecord.data, n7, n4);
            SpecprRecordWriter.write(specprRecord, byteBuffer);
            n3 -= n7;
            n4 += n6;
            ++n5;
        }
        return arrayList;
    }

    private static void write(double[] dArray, double[] dArray2, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[n2 + i] > -1.23E32 ? dArray[n2 + i] : -1.23E32;
        }
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            ByteBuffer byteBuffer = ByteBuffer.allocate(15360);
            double[] dArray = new double[300];
            for (n = 0; n < dArray.length; ++n) {
                dArray[n] = n;
            }
            n = dArray.length;
            List<SpecprRecord> list = SpecprRecord.writeData(byteBuffer, 0, dArray, n);
            for (SpecprRecord specprRecord : list) {
                System.out.println(specprRecord);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static class SpecprRecordWriter {
        public static void write(SpecprRecord specprRecord, ByteBuffer byteBuffer) throws IOException {
            byteBuffer.position(1536 * specprRecord.number);
            byteBuffer.put(specprRecord.header);
            switch (specprRecord.type) {
                case 1: {
                    SpecprRecordWriter.writeString(byteBuffer, specprRecord.title, 40);
                    SpecprRecordWriter.writeString(byteBuffer, specprRecord.username, 8);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.iscta);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.isctb);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.jdatea);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.jdateb);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.istb);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.isra);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.isdec);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.itchan);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.irmas);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.revs);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.iband);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.iband2);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.irwav);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.irespt);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.irecno);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.itpntr);
                    SpecprRecordWriter.writeString(byteBuffer, specprRecord.ihist, 60);
                    SpecprRecordWriter.writeString(byteBuffer, specprRecord.mhist, 296);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.nruns);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.siangl);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.seangl);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.sphase);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.iwtrns);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.itimch);
                    SpecprRecordWriter.writeFloat(byteBuffer, specprRecord.xnrm);
                    SpecprRecordWriter.writeFloat(byteBuffer, specprRecord.scatin);
                    SpecprRecordWriter.writeFloat(byteBuffer, specprRecord.timint);
                    SpecprRecordWriter.writeFloat(byteBuffer, specprRecord.tempd);
                    for (double d : specprRecord.data) {
                        SpecprRecordWriter.writeFloat(byteBuffer, (float)d);
                    }
                    break;
                }
                case 2: {
                    for (double d : specprRecord.data) {
                        SpecprRecordWriter.writeFloat(byteBuffer, (float)d);
                    }
                    break;
                }
                case 3: {
                    SpecprRecordWriter.writeString(byteBuffer, specprRecord.title, 40);
                    SpecprRecordWriter.writeString(byteBuffer, specprRecord.username, 8);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.itxtpt);
                    SpecprRecordWriter.writeInt(byteBuffer, specprRecord.itxtch);
                    SpecprRecordWriter.writeString(byteBuffer, specprRecord.itext.toString(), 1476);
                    break;
                }
                case 0: {
                    SpecprRecordWriter.writeString(byteBuffer, specprRecord.tdata, 1532);
                }
            }
        }

        private static void writeInt(ByteBuffer byteBuffer, long l) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN).putInt((int)l);
        }

        private static void writeFloat(ByteBuffer byteBuffer, float f) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN).putFloat(f);
        }

        private static void writeString(ByteBuffer byteBuffer, String string, int n) throws IOException {
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            if (byArray.length > n) {
                throw new IOException("String is too long to write to buffer");
            }
            byteBuffer.put(byArray);
            if (byArray.length < n) {
                byteBuffer.put(new byte[n - byArray.length]);
            }
        }
    }
}

