/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.usgs;

import java.awt.Color;
import java.awt.Graphics;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyList;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AdditionalFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredQuantificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.OptionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.RuleImageParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TransformationParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.WorkflowAnalyseParameter;
import se.prediktera.breeze.common.realtime.descriptor.spectralLibraries.GroupCatClass;
import se.prediktera.breeze.common.realtime.descriptor.usgs.MicaEndMemberSetup;
import se.prediktera.breeze.common.realtime.descriptor.usgs.UsgsMicaFile;
import se.prediktera.breeze.common.realtime.unmixing.GroupingUtils;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.breeze.common.realtime.unmixing.SpectralLibraryGroupParameter;
import se.prediktera.breeze.common.util.CustomRenderingDescriptor;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.register.RegInfo;

public class UsgsDescriptor
extends AbstractDescriptor
implements ThumbnailDescriptor.ThumbnailQuantificationDescriptor,
CustomRenderingDescriptor,
RuleImageParameter.RuleImageFunction {
    private final String version = "1";
    private static File lastFolder = null;
    private final WorkflowAnalyseParameter analyseParameter;
    private final MembersSetting.EndMemberFileParameter[] fileParameters = new MembersSetting.EndMemberFileParameter[5];
    private final PlsPredQuantificationDescriptor.SmoothParameter smoothParameter;
    private final RuleImageParameter showRulesImagesParameter;
    private final TransformationParameter transformationParameter;
    private final NumberParameter thresholdParameter;
    private final BooleanParameter saveAllParameter;
    private final BooleanParameter showAverageParameter;
    private final SpectralLibraryGroupParameter spectralLibraryGroupParameter;
    private final UsgsGroupParameter deprecatedGroupingParameter;

    public UsgsDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.analyseParameter = new WorkflowAnalyseParameter("analyse", BreezeMasterCache.getRtAnalyseListOrNull());
        this.addParameter(this.analyseParameter);
        this.analyseParameter.setVisible(false);
        this.deprecatedGroupingParameter = new UsgsGroupParameter();
        this.addParameter(this.deprecatedGroupingParameter);
        this.deprecatedGroupingParameter.setVisible(false);
        for (int i = 0; i < this.fileParameters.length; ++i) {
            this.fileParameters[i] = new MembersSetting.EndMemberFileParameter("library" + String.valueOf(i > 0 ? Integer.valueOf(i + 1) : ""), "MICA file " + (i + 1), i == 0 ? UsgsDescriptor.getDefaultMica() : ""){

                @Override
                public void customizeDialog(jopensaveDialog jopensaveDialog2) {
                    jopensaveDialog2.addExtension("mcf", "USGS PRISM MICA files (*.mcf)");
                    if (jopensaveDialog2.getSelectedFile() == null) {
                        jopensaveDialog2.setCurrentDirectory(lastFolder);
                    }
                }

                @Override
                public void setValueStr(String string) {
                    super.setValueStr(string);
                    File file = new File(string);
                    if (file.exists()) {
                        lastFolder = file.getParentFile();
                    }
                }

                @Override
                protected List<Reference> parseReferences(Workflow workflow) {
                    return UsgsDescriptor.getReferences(this.getFile(UsgsDescriptor.this.getWorkflow()), workflow);
                }
            };
            this.addParameter(this.fileParameters[i]);
        }
        this.spectralLibraryGroupParameter = new SpectralLibraryGroupParameter(this.fileParameters);
        this.addParameter(this.spectralLibraryGroupParameter, 3);
        this.spectralLibraryGroupParameter.setValue(GroupingUtils.listGroupings(List.of(new File(UsgsDescriptor.getDefaultMica()))).stream().findFirst().orElse(GroupingUtils.NONE_GROUPING));
        this.transformationParameter = new TransformationParameter(true);
        this.addParameter(this.transformationParameter);
        this.thresholdParameter = new NumberParameter("threshold", "Threshold", 0.0, "Value between 0-1", new MinMax(0.0f, 1.0f));
        this.addParameter(this.thresholdParameter);
        this.showRulesImagesParameter = new RuleImageParameter(this, "Fit value images", "", false);
        this.addParameter(this.showRulesImagesParameter);
        this.showAverageParameter = new BooleanParameter("average", "Show majority class", "", false);
        this.addParameter(this.showAverageParameter);
        this.saveAllParameter = new BooleanParameter("saveall", "Save all statistics", "", false);
        this.addParameter(this.saveAllParameter);
        this.smoothParameter = new PlsPredQuantificationDescriptor.SmoothParameter();
        this.addParameter(this.smoothParameter);
        this.addOutput("type");
        this.addOutput("depth");
    }

    public static String getDefaultMica() {
        return FileHelper.getJarPath().resolve(Paths.get("Data", "mica", "mica_cmds_2micron_usgshyspex_vswir3177_v4a_mtnpass.mcf")).toString();
    }

    @Override
    public RtAnalyse getAnalyse() {
        FunctionTreeNodeWithId functionTreeNodeWithId = this.getNode();
        Workflow workflow = Workflow.getWorkflow(functionTreeNodeWithId);
        RtAnalyse rtAnalyse = this.getOrCreateAnalyse(functionTreeNodeWithId, workflow);
        this.analyseParameter.setValue(rtAnalyse);
        return rtAnalyse;
    }

    @Override
    public List<ModelProperties.TransformationProperties> getTransformations() {
        return this.transformationParameter.getTransformations();
    }

    public static List<Reference> getReferences(File file, Workflow workflow) {
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        for (UsgsMicaFile usgsMicaFile : UsgsDescriptor.getUsgsFiles(file, workflow)) {
            arrayList.addAll(usgsMicaFile.getReferences());
        }
        return arrayList;
    }

    public static List<UsgsMicaFile> getUsgsFiles(File file, Workflow workflow) {
        String string;
        ArrayList<UsgsMicaFile> arrayList = new ArrayList<UsgsMicaFile>();
        if (file != null && file.getParentFile() != null && (string = FileHelper.getFileExtension(file)).equalsIgnoreCase("mcf")) {
            arrayList.add(new UsgsMicaFile(file, workflow));
        }
        return arrayList;
    }

    @Override
    public Factor getFactor(int n) {
        RtAnalyse rtAnalyse = this.getAnalyse();
        if (n == 0) {
            return rtAnalyse.getCategoryFactor();
        }
        return rtAnalyse.getPropertyFactors().get(0);
    }

    private int getParameterHashCode(Workflow workflow, FunctionTreeNodeWithId functionTreeNodeWithId) {
        int n = StringHelper.hashCode(workflow.getStudyId());
        n += StringHelper.hashCode(functionTreeNodeWithId.getUid());
        for (MembersSetting.EndMemberFileParameter endMemberFileParameter : this.fileParameters) {
            n += endMemberFileParameter.getHashCode();
        }
        n = this.deprecatedGroupingParameter.hasCustomSettings() ? (n += this.deprecatedGroupingParameter.getHashCode()) : (n += this.spectralLibraryGroupParameter.getHashCode());
        return n += FunctionParameter.hashCode(this.transformationParameter, this.thresholdParameter, this.showRulesImagesParameter, this.saveAllParameter);
    }

    public SpectralLibraryGroupParameter getMineralGroup() {
        return this.spectralLibraryGroupParameter;
    }

    public RtAnalyse getOrCreateAnalyse(FunctionTreeNodeWithId functionTreeNodeWithId, Workflow workflow) {
        return MembersSetting.createAnalyse(functionTreeNodeWithId, "Usgs_" + this.getParameterHashCode(workflow, functionTreeNodeWithId), this.analyseParameter, string -> {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            ArrayList<Reference> arrayList = new ArrayList<Reference>();
            for (MembersSetting.EndMemberFileParameter object52 : this.fileParameters) {
                if (!object52.exists(workflow)) continue;
                arrayList.addAll(object52.read(workflow));
            }
            RtAnalyse rtAnalyse = new RtAnalyse(string, "Usgs (" + MembersSetting.getFirstName(arrayList) + ")", BasicAnalyse.ModelMethod.ClassificationUsgs, this.getStudyId(), "1");
            RtModelParameters rtModelParameters = new RtModelParameters();
            rtModelParameters.addModel(UsgsDescriptor.createRtModel(arrayList, this.thresholdParameter.getValue(), false));
            rtAnalyse.setModelParameters(rtModelParameters);
            CategoryFactor categoryFactor = CategoryFactor.withNoClass("Type", "UsgsType", Color.black);
            rtAnalyse.getCategoryFactors().add(categoryFactor);
            if (this.deprecatedGroupingParameter.shouldMigrate()) {
                this.migrateGroupParameter(workflow);
            }
            GroupingUtils.Grouping grouping = this.spectralLibraryGroupParameter.getGrouping();
            RtModelParameters.RtModuleSetup rtModuleSetup = rtModelParameters.getModel().getModule("Base");
            int n = rtModuleSetup.getScalarInt("endMembers");
            for (int propertyFactor = 1; propertyFactor <= n; ++propertyFactor) {
                object4 = (MicaEndMemberSetup)rtModelParameters.getModel().getModule("endMember" + propertyFactor);
                String i = ((RtModelParameters.RtModuleSetup)object4).getString("name");
                if (!grouping.isNone()) {
                    categoryFactor.addClass(new GroupCatClass(i, categoryFactor, grouping));
                    continue;
                }
                object3 = categoryFactor.addClass(i);
                object2 = ((MicaEndMemberSetup)object4).getEndMemberReference();
                if (((Reference)object2).isCustomColor()) {
                    ((CatClass)object3).setColor(((UsgsMicaFile.EndMemberReference)object2).getColor());
                    continue;
                }
                if (((RtModelParameters.RtModuleSetup)object4).hasParameter("rgb")) {
                    object = ((RtModelParameters.RtModuleSetup)object4).getVectorInt("rgb");
                    ((CatClass)object3).setColor(new Color(object[0], object[1], object[2]));
                    continue;
                }
                ((CatClass)object3).setColor(RtPerfectSpread.generateColor(propertyFactor));
            }
            PropertyFactor propertyFactor = new PropertyFactor("Fit", "UsgsFit", "");
            propertyFactor.setMax(1.0f);
            rtAnalyse.getPropertyFactors().add(propertyFactor);
            object4 = this.showRulesImagesParameter.getRuleImageRecords();
            if (this.showRulesImagesParameter.getValueBool()) {
                rtModuleSetup.add(new RtModelParameters.RtParameterScalar("ruleImages", 1.0));
                for (int n2 = 1; n2 <= n; ++n2) {
                    object3 = rtModelParameters.getModel().getModule("endMember" + n2);
                    object2 = ((RtModelParameters.RtModuleSetup)object3).getString("name");
                    if (!RuleImageParameter.RuleImageRecord.isIncluded((List<RuleImageParameter.RuleImageRecord>)object4, (String)object2)) continue;
                    object = new PropertyFactor("Fit: " + (String)object2, "Fit_" + StringHelper.removeSpace((String)object2), "");
                    ((Factor)object).setMax(1.0f);
                    rtAnalyse.getPropertyFactors().add((PropertyFactor)object);
                }
            }
            if (this.saveAllParameter.getValueBool()) {
                rtModuleSetup.add(new RtModelParameters.RtParameterScalar("saveAll", 1.0));
                if (this.saveAllParameter.getValueBool()) {
                    int n2;
                    for (n2 = 1; n2 <= n; ++n2) {
                        object3 = rtModelParameters.getModel().getModule("endMember" + n2);
                        object2 = ((RtModelParameters.RtModuleSetup)object3).getString("name");
                        if (!RuleImageParameter.RuleImageRecord.isIncluded((List<RuleImageParameter.RuleImageRecord>)object4, (String)object2)) continue;
                        object = new PropertyFactor("Depth: " + (String)object2, "Depth_" + StringHelper.removeSpace((String)object2), "");
                        ((Factor)object).setMax(1.0f);
                        rtAnalyse.getPropertyFactors().add((PropertyFactor)object);
                    }
                    for (n2 = 1; n2 <= n; ++n2) {
                        object3 = rtModelParameters.getModel().getModule("endMember" + n2);
                        object2 = ((RtModelParameters.RtModuleSetup)object3).getString("name");
                        if (!RuleImageParameter.RuleImageRecord.isIncluded((List<RuleImageParameter.RuleImageRecord>)object4, (String)object2)) continue;
                        object = new PropertyFactor("WeightedFitDepth: " + (String)object2, "WeightedFitDepth_" + StringHelper.removeSpace((String)object2), "");
                        ((Factor)object).setMax(1.0f);
                        rtAnalyse.getPropertyFactors().add((PropertyFactor)object);
                    }
                }
            }
            return rtAnalyse;
        });
    }

    private void migrateGroupParameter(Workflow workflow) {
        Logg.debug((String)("Migrating deprecated group parameter to spectral library group parameter. " + ((OptionParameter.Option)this.deprecatedGroupingParameter.getValueObj()).getDescription() + " (" + this.deprecatedGroupingParameter.getHashCode() + ")"), (Object[])new Object[0]);
        List<GroupingUtils.Grouping> list = GroupingUtils.listGroupings(this.spectralLibraryGroupParameter.getEndMemberFiles(workflow));
        GroupingUtils.Grouping grouping2 = list.stream().filter(grouping -> grouping.getGroupingName().equals(((OptionParameter.Option)this.deprecatedGroupingParameter.getValueObj()).getDescription())).findFirst().orElse(GroupingUtils.NONE_GROUPING);
        if (this.deprecatedGroupingParameter.hasCustomSettings()) {
            grouping2 = grouping2.copyWithNewIdAndSourceFile();
            grouping2.setGroupingName(grouping2.getGroupingName() + " (copy)");
            grouping2.setReadOnly(false);
            grouping2.setLegacyHashCode(Integer.toHexString(this.deprecatedGroupingParameter.getHashCode()));
            List<GroupingUtils.Group> list2 = grouping2.getGroups();
            List<String> list3 = this.deprecatedGroupingParameter.getSettingsColorList();
            IntStream.range(0, Math.min(list2.size(), list3.size())).forEach(n -> ((GroupingUtils.Group)list2.get(n)).setColorHex((String)list3.get(n)));
            list.add(grouping2);
            grouping2.saveToFile(true);
        }
        this.spectralLibraryGroupParameter.setValue(grouping2);
        this.deprecatedGroupingParameter.setValue(this.deprecatedGroupingParameter.getMigrateOption());
        this.deprecatedGroupingParameter.settings = null;
    }

    public static RtModelParameters.RtModel createRtModel(List<Reference> list, double d, boolean bl) {
        RtModelParameters.RtModel rtModel = new RtModelParameters.RtModel("Usgs");
        RtModelParameters.RtModuleSetup rtModuleSetup = new RtModelParameters.RtModuleSetup("Base");
        rtModuleSetup.add(new RtModelParameters.RtParameterScalar("threshold", d));
        RtModelParameters.RtParameterScalar rtParameterScalar = new RtModelParameters.RtParameterScalar("endMembers", 0.0);
        rtModuleSetup.add(rtParameterScalar);
        rtModel.getModules().add(rtModuleSetup);
        int n = 0;
        for (Reference reference : list) {
            if (!reference.isIncluded()) continue;
            MicaEndMemberSetup micaEndMemberSetup = ((UsgsMicaFile.EndMemberReference)reference).getOrParseEndMember();
            micaEndMemberSetup.setName("endMember" + ++n);
            rtModel.getModules().add(micaEndMemberSetup);
        }
        rtParameterScalar.setScalar(n);
        return rtModel;
    }

    @Override
    public boolean hasResult(int n) {
        return this.showAverageParameter.getValueBool();
    }

    @Override
    public boolean hasThumbnail(int n) {
        return true;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        if (textType.isTable()) {
            if (n == 0) {
                return "Type";
            }
            return "Depth";
        }
        return "USGS PRISM MICA";
    }

    @Override
    public ThumbnailDescriptor.ThumbType getThumbType(int n) {
        if (n == 0) {
            return ThumbnailDescriptor.ThumbType.ThumbClassification;
        }
        return ThumbnailDescriptor.ThumbType.ThumbQuantification;
    }

    @Override
    public int getSmooth() {
        return this.smoothParameter.getSmooth();
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        CategoryFactor categoryFactor;
        CatClass catClass;
        Factor factor = this.getFactor(n);
        if (n == 0 && factor instanceof CategoryFactor && (catClass = (categoryFactor = (CategoryFactor)factor).getClassByValueIdx((int)f)) != null) {
            return catClass.getName();
        }
        return super.getStringValue(f, n, n2);
    }

    @Override
    public boolean renderCellAt(int n) {
        return n == 0;
    }

    @Override
    public void renderCell(Sample sample, float f, Graphics graphics, int n, int n2, int n3) {
        CategoryFactor categoryFactor;
        if (n3 == 0 && (categoryFactor = (CategoryFactor)this.getFactor(n3)) != null) {
            CatClass.render(graphics, categoryFactor.getClassByValueIdx((int)f), n2);
        }
    }

    @Override
    public CustomRenderingDescriptor.RenderData getStringValueAndOptionalBoxColor(String string, FunctionResult functionResult) {
        if (functionResult.getIndex() == 0) {
            return new CustomRenderingDescriptor.RenderData(string, Optional.of(FunctionResult.getCategoryColorHexString(functionResult)));
        }
        return new CustomRenderingDescriptor.RenderData(string);
    }

    @Override
    public List<AdditionalFactor> getAdditionalFactors() {
        if (this.showRulesImagesParameter.getValueBool()) {
            PropertyList propertyList = this.getAnalyse().getPropertyFactors();
            ArrayList<AdditionalFactor> arrayList = new ArrayList<AdditionalFactor>();
            for (int i = 1; i < propertyList.size(); ++i) {
                arrayList.add(new AdditionalFactor(propertyList.get(i)));
            }
            return arrayList;
        }
        return null;
    }

    @Deprecated
    public static class UsgsGroupParameter
    extends OptionParameter<OptionParameter.Option> {
        private final OptionParameter.Option migrateOption;
        private String settings;

        public UsgsGroupParameter() {
            super("group", "Group", "99", "");
            this.add(new OptionParameter.Option("0", "Default mineral group"));
            this.add(new OptionParameter.Option("1", "Generalized mineral group"));
            this.add(new OptionParameter.Option("2", "None"));
            this.add(new OptionParameter.Option("3", "Custom"));
            this.migrateOption = new OptionParameter.Option("99", "Migrate");
            this.add(this.migrateOption);
        }

        public boolean shouldMigrate() {
            return !((OptionParameter.Option)this.getValueObj()).getName().equals(this.migrateOption.getName());
        }

        public boolean hasCustomSettings() {
            return StringUtils.isNotBlank((CharSequence)this.settings);
        }

        @Override
        public Element save(Element element) {
            return null;
        }

        @Override
        public void parse(Node node) {
            super.parse(node);
            this.settings = XmlParserHelper.getAttribute(node, "settings");
        }

        public List<String> getSettingsColorList() {
            if (StringUtils.isBlank((CharSequence)this.settings)) {
                return new ArrayList<String>();
            }
            Pattern pattern = Pattern.compile("'c':'(#.{6})'");
            List<String> list = pattern.matcher(this.settings).results().map(matchResult -> matchResult.group(1)).toList();
            return list;
        }

        public int getHashCode() {
            int n = this.getIndex();
            if (this.settings != null) {
                n += StringHelper.hashCode(this.settings);
            }
            return n;
        }

        @Generated
        public OptionParameter.Option getMigrateOption() {
            return this.migrateOption;
        }

        @Generated
        public String getSettings() {
            return this.settings;
        }
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "usgs-logo";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new UsgsDescriptor(this);
        }

        public String toString() {
            return "UsgsDescriptor";
        }

        @Override
        public String getShortDescription() {
            return "USGS PRISM MICA";
        }

        @Override
        public String getDescription() {
            return "Material Identification and Classification Algorithm Expert System";
        }

        @Override
        public RegInfo.LicenseFeature getLicenseFeature() {
            return RegInfo.LicenseFeature.Geo;
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Geo;
        }

        @Override
        public String getHelp() {
            return "usgs-prism-mica";
        }

        @Override
        public List<String> getKeywords() {
            return Arrays.asList("usgs", "prism", "mica");
        }
    }
}

