/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.usgs;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.swing.JFrame;
import lombok.Generated;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.realtime.descriptor.usgs.MicaCommandFile;
import se.prediktera.breeze.common.realtime.descriptor.usgs.MicaEndMemberSetup;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.breeze.common.realtime.unmixing.SelectMembersPanel;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.map.common.error.ErrorHandler;

public class UsgsMicaFile {
    private final File sourceFile;
    private final File dnColorsFile;
    private final MicaCommandFile mcf;
    private double wf;
    private ByteBuffer specprBuffer;
    private DnColors dnColors;

    public UsgsMicaFile(File file, Workflow workflow) {
        this.sourceFile = file;
        try {
            List<String> list = Files.readAllLines(file.toPath());
            this.mcf = new MicaCommandFile(list);
            this.dnColorsFile = new File(Optional.ofNullable(this.mcf.fileDnColors).orElse(""));
            if (this.mcf.references.isEmpty()) {
                throw new ErrorHandler.InformationMessageException("No references in command file");
            }
            this.wf = UsgsMicaFile.calculateWavelengthFactor(workflow);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static double calculateWavelengthFactor(Workflow workflow) {
        float[] fArray;
        if (workflow != null && (fArray = workflow.getBandValues()) != null && fArray[0] < 10.0f) {
            return 1.0;
        }
        return 1000.0;
    }

    public MicaEndMemberSetup parse(EndMemberReference endMemberReference, MicaCommandFile.MicaReference micaReference) {
        try {
            return new MicaEndMemberSetup(this.mcf, endMemberReference, micaReference, this.getOrReadSpecprBuffer(), this.getOrReadDnColors(), this.wf);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error parsing usgs mica file\n\nReason: " + exception.getMessage(), exception);
        }
    }

    public File getSpecprFile() {
        MicaCommandFile.MicaReference micaReference = this.mcf.references.getFirst();
        File file = Paths.get(micaReference.file, new String[0]).toFile();
        if (!file.exists()) {
            file = new File(this.sourceFile.getParentFile(), file.getName());
        }
        return file;
    }

    private ByteBuffer getOrReadSpecprBuffer() throws IOException {
        if (this.specprBuffer == null) {
            MicaCommandFile.MicaReference micaReference = this.mcf.references.getFirst();
            File file = this.getSpecprFile();
            if (!file.exists()) {
                throw new ErrorHandler.InformationMessageException("Cannot locate specpr file at " + micaReference.file + " or " + String.valueOf(file));
            }
            this.specprBuffer = ByteBuffer.allocate((int)file.length());
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 FileChannel fileChannel = fileInputStream.getChannel();){
                fileChannel.read(this.specprBuffer);
            }
        }
        return this.specprBuffer;
    }

    private DnColors getOrReadDnColors() {
        if (this.dnColors == null) {
            this.dnColors = UsgsMicaFile.readDnColors(this.sourceFile, this.mcf.fileDnColors);
        }
        return this.dnColors;
    }

    public static DnColors readDnColors(File file, String string) {
        Object object;
        String string2;
        File file2 = null;
        if (string != null) {
            file2 = new File(string);
            if (!file2.exists()) {
                file2 = new File(file.getParentFile(), file2.getName());
            }
            if (!file2.exists()) {
                string2 = FileHelper.getFileName(file);
                object = FileHelper.getFileExtension(file2);
                file2 = new File(file.getParentFile(), string2 + "." + (String)object);
            }
        }
        if (file2 == null || !file2.exists()) {
            string2 = FileHelper.getFileName(file);
            for (String string3 : object = new String[]{"clr", "txt"}) {
                File file3 = new File(file.getParentFile(), string2 + "." + string3);
                if (!file3.exists()) continue;
                file2 = file3;
                break;
            }
        }
        if (file2 != null && file2.exists()) {
            return new DnColors(file2);
        }
        return null;
    }

    public List<EndMemberReference> getReferences() {
        ArrayList<EndMemberReference> arrayList = new ArrayList<EndMemberReference>();
        for (int i = 0; i < this.mcf.references.size(); ++i) {
            arrayList.add(new EndMemberReference(this, this.mcf.references.get(i), i));
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        UsgsMicaFile usgsMicaFile = new UsgsMicaFile(new File("C:\\temp\\usgs\\mica_cmds_group2_hymap2007.mcf"), null);
        JFrame jFrame = new JFrame("Test");
        jFrame.setDefaultCloseOperation(3);
        List<EndMemberReference> list = usgsMicaFile.getReferences();
        if (list.size() == 0) {
            System.exit(0);
        }
        jFrame.getContentPane().add(new SelectMembersPanel(null, list, null, null));
        jFrame.setSize(800, 800);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    @Generated
    public File getSourceFile() {
        return this.sourceFile;
    }

    @Generated
    public File getDnColorsFile() {
        return this.dnColorsFile;
    }

    public static class DnColors
    extends HashMap<String, Color> {
        private final File file;

        public DnColors(File file) {
            this.file = file;
            try {
                for (String string : Files.readAllLines(file.toPath())) {
                    String[] stringArray = string.split(" +");
                    if (stringArray.length != 5) continue;
                    this.put(stringArray[0], new Color(DnColors.toColor(stringArray[2]), DnColors.toColor(stringArray[3]), DnColors.toColor(stringArray[4])));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public File getFile() {
            return this.file;
        }

        private static int toColor(String string) {
            int n = RtDataFormat.toNumberInt(string);
            if (n < 0) {
                return 0;
            }
            if (n > 255) {
                return 255;
            }
            return n;
        }
    }

    public static class EndMemberReference
    extends Reference {
        private MicaEndMemberSetup endMember;
        private final UsgsMicaFile micaFile;
        private final MicaCommandFile.MicaReference reference;
        private final int index;

        public EndMemberReference(UsgsMicaFile usgsMicaFile, MicaCommandFile.MicaReference micaReference, int n) {
            super(micaReference.name);
            this.micaFile = usgsMicaFile;
            this.reference = micaReference;
            this.index = n;
        }

        @Override
        public float[] getWavelength() {
            this.getOrParseEndMember();
            return super.getWavelength();
        }

        @Override
        public FloatMatrix getMatrix() {
            this.getOrParseEndMember();
            return super.getMatrix();
        }

        @Override
        public Color getColor() {
            this.getOrParseEndMember();
            return super.getColor();
        }

        @Override
        public CatClass getCatClass() {
            this.getOrParseEndMember();
            return super.getCatClass();
        }

        @Override
        public InformationPanel.InformationList getInformation() {
            return this.getOrParseEndMember().getInformation();
        }

        public MicaEndMemberSetup getOrParseEndMember() {
            if (this.endMember == null) {
                this.endMember = this.micaFile.parse(this, this.reference);
                this.wavelength = this.endMember.getVectorFloat("wavelength");
                this.matrix = new FloatMatrix(this.endMember.getVectorFloat("vector"));
                if (!this.isCustomColor()) {
                    if (this.endMember.hasParameter("rgb")) {
                        int[] nArray = this.endMember.getVectorInt("rgb");
                        this.setColor(new Color(nArray[0], nArray[1], nArray[2]), true);
                    } else {
                        this.setColor(RtPerfectSpread.generateColor(this.index), true);
                    }
                }
            }
            return this.endMember;
        }
    }
}

