/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.usgs;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import se.prediktera.breeze.common.realtime.descriptor.usgs.UsgsMicaFile;

public class UsgsMicaFileTest {
    private File tempDir;
    private File sourceFile;

    @Before
    public void setUp() throws IOException {
        this.tempDir = Files.createTempDirectory("dncolors-test", new FileAttribute[0]).toFile();
        this.sourceFile = new File(this.tempDir, "sample.mcf");
        Files.createFile(this.sourceFile.toPath(), new FileAttribute[0]);
    }

    @After
    public void tearDown() {
        File[] fileArray = this.tempDir.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                file.delete();
            }
        }
        this.tempDir.delete();
    }

    @Test
    public void usesExactFileDnColorsPath_WhenItExists() throws IOException {
        File file = new File(this.tempDir, "colors.clr");
        Files.createFile(file.toPath(), new FileAttribute[0]);
        UsgsMicaFile.DnColors dnColors = UsgsMicaFile.readDnColors(this.sourceFile, file.getAbsolutePath());
        MatcherAssert.assertThat((Object)dnColors, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)dnColors.getFile().getAbsolutePath(), (Matcher)Matchers.is((Object)file.getAbsolutePath()));
    }

    @Test
    public void fallsBackToSameFolder_SameFilename_WhenDirectPathMissing() throws IOException {
        File file = new File(this.tempDir, "colors.clr");
        Files.createFile(file.toPath(), new FileAttribute[0]);
        String string = new File(new File("C:/nonexistent/path"), "colors.clr").getAbsolutePath();
        UsgsMicaFile.DnColors dnColors = UsgsMicaFile.readDnColors(this.sourceFile, string);
        MatcherAssert.assertThat((Object)dnColors, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)dnColors.getFile().getAbsolutePath(), (Matcher)Matchers.is((Object)file.getAbsolutePath()));
    }

    @Test
    public void fallsBackToBaseNamePlusExtension_FromFileDnColors_WhenStillMissing() throws IOException {
        File file = new File(this.tempDir, "sample.cmap");
        Files.createFile(file.toPath(), new FileAttribute[0]);
        String string = new File(new File("Z:/nowhere"), "anything.cmap").getAbsolutePath();
        UsgsMicaFile.DnColors dnColors = UsgsMicaFile.readDnColors(this.sourceFile, string);
        MatcherAssert.assertThat((Object)dnColors, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)dnColors.getFile().getAbsolutePath(), (Matcher)Matchers.is((Object)file.getAbsolutePath()));
    }

    @Test
    public void triesFallbackExtensions_clr_Then_txt_WhenNoFileDnColorsProvided_clrWins() throws IOException {
        File file = new File(this.tempDir, "sample.clr");
        Files.createFile(file.toPath(), new FileAttribute[0]);
        UsgsMicaFile.DnColors dnColors = UsgsMicaFile.readDnColors(this.sourceFile, null);
        MatcherAssert.assertThat((Object)dnColors, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)dnColors.getFile().getAbsolutePath(), (Matcher)Matchers.is((Object)file.getAbsolutePath()));
    }

    @Test
    public void triesFallbackExtensions_txt_WhenNoClrPresent() throws IOException {
        File file = new File(this.tempDir, "sample.txt");
        Files.createFile(file.toPath(), new FileAttribute[0]);
        UsgsMicaFile.DnColors dnColors = UsgsMicaFile.readDnColors(this.sourceFile, null);
        MatcherAssert.assertThat((Object)dnColors, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)dnColors.getFile().getAbsolutePath(), (Matcher)Matchers.is((Object)file.getAbsolutePath()));
    }

    @Test
    public void returnsNull_WhenNothingMatches() {
        UsgsMicaFile.DnColors dnColors = UsgsMicaFile.readDnColors(this.sourceFile, null);
        MatcherAssert.assertThat((Object)dnColors, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }
}

