/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.usgs.groups;

import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.realtime.descriptor.usgs.UsgsDescriptor;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;

public class MicaGroups {
    private final CategoryFactor categoryDefault = new CategoryFactor("Default", "Default");
    private final CategoryFactor categoryTSG = new CategoryFactor("TSG", "TSG");
    private final CategoryFactor categoryCustom = new CategoryFactor("Custom", "Custom");
    private final HashMap<String, CatClass> hashMapDefault;
    private final HashMap<String, CatClass> hashMapTSG;
    private final HashMap<String, CatClass> hashMapCustom;
    private static MicaGroups instance;

    public static MicaGroups getInstance() {
        if (instance == null) {
            instance = new MicaGroups();
        }
        return instance;
    }

    private MicaGroups() {
        try {
            MicaGroups.parseCategories(this.categoryDefault, this.categoryTSG);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            this.parseIntoHashMap(hashMap, hashMap2);
            this.hashMapDefault = this.createMatch(this.categoryDefault, hashMap);
            this.hashMapTSG = this.createMatch(this.categoryTSG, hashMap2);
            this.hashMapCustom = new HashMap();
            this.parseCustom();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public CategoryFactor getCategory(int n) {
        if (n == 0) {
            return this.categoryDefault;
        }
        if (n == 1) {
            return this.categoryTSG;
        }
        return this.categoryCustom;
    }

    private void parseCustom() throws IOException {
        File file = new File(WorkspaceManager.getInstance().getWorkspace().getDataPath(), "custom_usgs_groups.csv");
        File file2 = new File(WorkspaceManager.getInstance().getWorkspace().getTempPath(), "prediktera_test_groupings.csv");
        if (file2.exists() && !file.exists()) {
            file = file2;
        }
        if (file.exists()) {
            List<String> list = Files.readAllLines(file.toPath());
            CatClass catClass = null;
            for (int i = 1; i < list.size(); ++i) {
                String[] stringArray = list.get(i).split(";", -1);
                String string = stringArray[0].trim();
                String string2 = stringArray[1].trim();
                if (!string2.isEmpty()) {
                    String string3 = stringArray[2].trim();
                    String string4 = stringArray[3].trim();
                    String string5 = stringArray[4].trim();
                    Color color = null;
                    if (!string3.isEmpty()) {
                        color = new Color(RtDataFormat.toNumberInt(string3), RtDataFormat.toNumberInt(string4), RtDataFormat.toNumberInt(string5));
                    }
                    catClass = this.categoryCustom.addClass(string2, color);
                }
                this.hashMapCustom.put(string, catClass);
            }
        }
    }

    private HashMap<String, CatClass> createMatch(CategoryFactor categoryFactor, HashMap<String, String> hashMap) {
        HashMap<String, CatClass> hashMap2 = new HashMap<String, CatClass>();
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            CatClass catClass = categoryFactor.getClass(entry.getValue());
            hashMap2.put(entry.getKey(), catClass);
        }
        return hashMap2;
    }

    private static void parseCategories(CategoryFactor categoryFactor, CategoryFactor categoryFactor2) throws IOException {
        List<String> list = MicaGroups.readLinesFromResource("MICA_mcf_groups_colors.csv");
        for (int i = 2; i < list.size(); ++i) {
            Object object;
            String[] stringArray = list.get(i).split(",", -1);
            String string = stringArray[0].trim();
            String string2 = stringArray[1].trim();
            String string3 = stringArray[2].trim();
            String string4 = stringArray[3].trim();
            Color color = null;
            if (!string2.isEmpty()) {
                color = new Color(RtDataFormat.toNumberInt(string2), RtDataFormat.toNumberInt(string3), RtDataFormat.toNumberInt(string4));
            }
            if (!string.isEmpty()) {
                object = categoryFactor.addClass(string);
                if (color != null) {
                    ((CatClass)object).setColor(color);
                }
            }
            if (((String)(object = stringArray[5].trim())).isEmpty()) continue;
            CatClass catClass = categoryFactor2.addClass((String)object);
            if (color == null) continue;
            catClass.setColor(color);
        }
    }

    private void parseIntoHashMap(HashMap<String, String> hashMap, HashMap<String, String> hashMap2) throws IOException {
        List<String> list = MicaGroups.readLinesFromResource("MICA_mcf_groups.csv");
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        for (int i = 2; i < list.size(); ++i) {
            String[] stringArray = list.get(i).split(",", -1);
            string = MicaGroups.add(hashMap, stringArray, 0, 5, string);
            string2 = MicaGroups.add(hashMap2, stringArray, 0, 6, string2);
            string3 = MicaGroups.add(hashMap, stringArray, 10, 15, string3);
            string4 = MicaGroups.add(hashMap2, stringArray, 10, 16, string4);
        }
    }

    public static CatClass getGroupClass(String string, int n) {
        CatClass catClass;
        MicaGroups micaGroups = MicaGroups.getInstance();
        HashMap<String, CatClass> hashMap = micaGroups.hashMapCustom;
        if (n == 3) {
            return hashMap.get(string);
        }
        HashMap<String, CatClass> hashMap2 = micaGroups.hashMapDefault;
        HashMap<String, CatClass> hashMap3 = micaGroups.hashMapTSG;
        if (n == 1 && (catClass = hashMap3.get(string)) != null) {
            return catClass;
        }
        return hashMap2.get(string);
    }

    private static String add(HashMap<String, String> hashMap, String[] stringArray, int n, int n2, String string) {
        String string2 = stringArray[n].trim();
        if (!string2.isEmpty()) {
            String string3;
            String string4 = stringArray[n2].trim();
            if (!string4.isEmpty()) {
                string = string4;
            }
            if ((string3 = hashMap.get(string2)) != null && !string.equals(string3)) {
                throw new RuntimeException("Ambiguous values for name: " + string2 + " = " + string + ", " + string3);
            }
            hashMap.put(string2, string);
        }
        return string;
    }

    /*
     * Exception decompiling
     */
    private static List<String> readLinesFromResource(String var0) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void saveGroup(List<Reference> list, File file, int n) {
        List list2;
        Object object;
        HashMap hashMap = new HashMap();
        for (Reference object2 : list) {
            CatClass catClass = MicaGroups.getGroupClass(object2.getName(), n);
            object = hashMap.get(catClass);
            if (!(object instanceof List)) continue;
            list2 = (List)object;
            list2.add(object2.getName());
        }
        try (PrintWriter printWriter = new PrintWriter(new FileWriter(file));){
            printWriter.println("Name;Group name;R;G;B");
            for (Map.Entry entry : hashMap.entrySet()) {
                list2 = (List)entry.getValue();
                object = (CatClass)entry.getKey();
                String string = ((CatClass)object).getName();
                Color color = ((CatClass)object).getColor();
                for (int i = 0; i < list2.size(); ++i) {
                    String string2 = (String)list2.get(i);
                    if (i == 0) {
                        printWriter.println(string2 + ";" + string + ";" + color.getRed() + ";" + color.getGreen() + ";" + color.getBlue());
                        continue;
                    }
                    printWriter.println(string2 + ";;;;");
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        MicaGroups.saveGroup(UsgsDescriptor.getReferences(new File(UsgsDescriptor.getDefaultMica()), new WorkflowWithoutIO()), new File("C:/tmp/groups.csv"), 3);
    }

    public static class MicaCatClass
    extends CatClass {
        private CatClass groupClass;

        public MicaCatClass(String string, CategoryFactor categoryFactor, int n, int n2) {
            this(string, categoryFactor, n, null, n2);
        }

        public MicaCatClass(String string, CategoryFactor categoryFactor, int n, CategoryFactor categoryFactor2, int n2) {
            super(string, categoryFactor);
            CatClass catClass;
            this.groupClass = MicaGroups.getGroupClass(string, n);
            if (this.groupClass != null && categoryFactor2 != null && (catClass = categoryFactor2.getClassByName(this.groupClass.getName())) != null) {
                this.groupClass = catClass;
            }
            if (this.groupClass != null) {
                this.setExtraInfo(this.groupClass.getName() + ":" + this.groupClass.getColorString());
            }
            this.setIndex(n2);
        }

        @Override
        public String getName() {
            if (this.groupClass != null) {
                return this.groupClass.getName();
            }
            return super.getName();
        }

        public String getActualClassName() {
            return super.getName();
        }

        @Override
        public Color getColor() {
            if (this.groupClass != null) {
                return this.groupClass.getColor();
            }
            return super.getColor();
        }

        @Generated
        public CatClass getGroupClass() {
            return this.groupClass;
        }
    }
}

