/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.usgs.groups;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.realtime.descriptor.usgs.groups.MicaGroups;

public class MicaGroupsTest {
    private final File groupingsFile = new File(WorkspaceManager.getInstance().getWorkspace().getTempPath(), "prediktera_test_groupings.csv");

    @Before
    public void setUp() throws Exception {
        MatcherAssert.assertThat((Object)this.groupingsFile.exists(), (Matcher)Matchers.is((Object)false));
        Files.writeString(this.groupingsFile.toPath(), (CharSequence)"N;G;R;G;B\nvegetation_npv_and_green;ASDF;255;255;255", new OpenOption[0]);
    }

    @After
    public void tearDown() throws Exception {
        Files.deleteIfExists(this.groupingsFile.toPath());
    }

    @Test
    public void micaCatClassTest() {
        CategoryFactor categoryFactor = new CategoryFactor("Test");
        MatcherAssert.assertThat((Object)new MicaGroups.MicaCatClass("calcite_abundant", categoryFactor, 0, 0).getName(), (Matcher)Matchers.is((Object)"Carbonate"));
        MatcherAssert.assertThat((Object)new MicaGroups.MicaCatClass("calcite.5+muscoviteMedAl.5", categoryFactor, 1, 0).getName(), (Matcher)Matchers.is((Object)"Carbonate+Mica"));
        MatcherAssert.assertThat((Object)new MicaGroups.MicaCatClass("calcite.22+dolomite.18+montmorilloniteNa.6", categoryFactor, 1, 0).getName(), (Matcher)Matchers.is((Object)"Carbonate+Mica"));
        MatcherAssert.assertThat((Object)new MicaGroups.MicaCatClass("vegetation_npv_and_green", categoryFactor, 3, 0).getName(), (Matcher)Matchers.is((Object)"ASDF"));
    }
}

