/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.frame;

import java.util.concurrent.LinkedBlockingQueue;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.frame.FrameReleasePool;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.PixelWidth;

public class FramePool
implements FrameReleasePool<RawFrame> {
    public static final int DEFAULT_INITIAL_POOL_SIZE = 300;
    public static int INITIAL_POOL_SIZE = 300;
    private final LinkedBlockingQueue<RawFrame> poolQueue = new LinkedBlockingQueue();
    private final BandCount frameRows;
    private final PixelWidth frameColumns;
    private final BandNames bandNames;
    private final DataSize dataSize;

    public FramePool(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, DataSize dataSize) {
        this(bandCount, pixelWidth, bandNames, dataSize, INITIAL_POOL_SIZE);
    }

    public FramePool(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, DataSize dataSize, int n) {
        this.frameRows = bandCount;
        this.frameColumns = pixelWidth;
        this.bandNames = bandNames;
        this.dataSize = dataSize;
        for (int i = 0; i < n; ++i) {
            this.poolQueue.add(Frame.createFrame(dataSize, bandCount, pixelWidth, bandNames));
        }
    }

    public RawFrame poll() {
        return this.poolQueue.poll();
    }

    public boolean isEmpty() {
        return this.poolQueue.isEmpty();
    }

    @Override
    public RawFrame getFrame() {
        RawFrame rawFrame = this.poolQueue.poll();
        if (rawFrame == null) {
            return Frame.createFrame(this.dataSize, this.frameRows, this.frameColumns, this.bandNames);
        }
        return rawFrame;
    }

    @Override
    public void returnFrame(RawFrame rawFrame) {
        this.poolQueue.add(rawFrame);
    }

    @Override
    public void setSize(int n) {
        while (this.poolQueue.size() > n) {
            this.poolQueue.remove();
        }
    }

    @Override
    public boolean equalDimension(BandCount bandCount, PixelWidth pixelWidth) {
        return this.frameRows.value == bandCount.value && this.frameColumns.value == pixelWidth.value;
    }

    @Override
    public void clear() {
        this.poolQueue.clear();
    }

    public BandCount getFrameRows() {
        return this.frameRows;
    }

    public PixelWidth getFrameColumns() {
        return this.frameColumns;
    }

    public DataSize getDataSize() {
        return this.dataSize;
    }

    @Override
    public void updateBandCount(BandCount bandCount) {
        throw new RuntimeException("Not implemented");
    }
}

