/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.frame;

import java.nio.ByteBuffer;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.frame.DoubleFrame;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.util.StrayLightManager;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.AverageFloatMatrix;
import se.prediktera.breeze.common.util.raw.RtReferenceTarget;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.util.raw.HySpexHeader;
import se.prediktera.breeze.util.raw.HySpexHelper;
import se.prediktera.map.common.error.ErrorHandler;

public class RefFrame {
    public final RtFrame minRefFrame;
    public final RtFrame oneDivAbsRefFrame;
    public final RtFrame minAfterRefFrame;

    public RefFrame(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, FloatMatrix floatMatrix3, int n) {
        this.minRefFrame = RtFrame.createRtMatrix(floatMatrix, n);
        this.oneDivAbsRefFrame = RtFrame.createRtMatrix(floatMatrix2, n);
        this.minAfterRefFrame = RtFrame.createRtMatrix(floatMatrix3, n);
    }

    public static RefFrame createRefFrameFromReferences(SpectralReference.WhiteReference whiteReference, SpectralReference.DarkReference darkReference, int n, int[] nArray, RtFramePredictor.RefSettings refSettings, StrayLightManager strayLightManager, boolean bl, Measurement measurement) {
        Object object;
        AverageFloatMatrix averageFloatMatrix = darkReference.isEmpty() ? null : AverageFloatMatrix.createCheckArray(darkReference.getMatrix(), nArray);
        FloatMatrix floatMatrix = null;
        if (refSettings.useDarkReferenceAfter || refSettings.convertTo.equals((Object)RtFramePredictor.ReferenceConvertTo.Radiance)) {
            object = RefFrame.readHySpexHeader(measurement);
            if (object != null) {
                if (refSettings.useDarkReferenceAfter && ((HySpexHeader)object).background != null) {
                    averageFloatMatrix = ((HySpexHeader)object).createMatrixBp(((HySpexHeader)object).crop(((HySpexHeader)object).background, refSettings.bounds), refSettings);
                    if (((HySpexHeader)object).backgroundLast != null && HySpexHelper.backgroundDifferent((HySpexHeader)object)) {
                        floatMatrix = ((HySpexHeader)object).createMatrixBp(((HySpexHeader)object).crop(((HySpexHeader)object).backgroundLast, refSettings.bounds), refSettings);
                    }
                }
                if (refSettings.convertTo.equals((Object)RtFramePredictor.ReferenceConvertTo.Radiance)) {
                    double[] dArray = ((HySpexHeader)object).QE;
                    double[] dArray2 = ((HySpexHeader)object).spectralCalib;
                    double[] dArray3 = ((HySpexHeader)object).calcSpectralDelta();
                    DoubleFrame doubleFrame = ((HySpexHeader)object).createFrame(((HySpexHeader)object).crop(((HySpexHeader)object).RE, refSettings.bounds), refSettings);
                    FloatMatrix floatMatrix2 = new FloatMatrix(doubleFrame.getRows().value, doubleFrame.getColumns().value);
                    double d = ((HySpexHeader)object).getScalingComp();
                    for (int i = 0; i < doubleFrame.getRows().value; ++i) {
                        double d2 = dArray[i] * dArray3[i] * dArray2[i];
                        if (d != 0.0) {
                            d2 *= d;
                        }
                        for (int j = 0; j < doubleFrame.getColumns().value; ++j) {
                            floatMatrix2.put(i, j, (float)(1.0 / (doubleFrame.getFrameValueNative(i, j) * d2)));
                        }
                    }
                    return new RefFrame(averageFloatMatrix, floatMatrix2, floatMatrix, n);
                }
            } else if (refSettings.convertTo.equals((Object)RtFramePredictor.ReferenceConvertTo.Radiance)) {
                throw new ErrorHandler.InformationMessageException("Radiance not support for this data");
            }
        }
        if (!whiteReference.isEmpty()) {
            object = AverageFloatMatrix.createCheckArray(whiteReference.getMatrix(), nArray);
            if (strayLightManager != null) {
                strayLightManager.applyWhite((FloatMatrix)object);
            }
            float f = 1.0f;
            IntegrationTime integrationTime = whiteReference.getIntegrationTime();
            IntegrationTime integrationTime2 = refSettings.integrationTime;
            if (integrationTime2 != null && integrationTime2.value > 0.0f && integrationTime != null && integrationTime.value > 0.0f) {
                f = integrationTime2.value / integrationTime.value;
            }
            return RefFrame.createRefFrame(averageFloatMatrix, floatMatrix, (FloatMatrix)object, n, f, nArray, whiteReference.getReferenceTarget(), bl);
        }
        return new RefFrame(averageFloatMatrix, null, floatMatrix, n);
    }

    public static HySpexHeader readHySpexHeader(SpectralReference.DarkReference darkReference) {
        return RefFrame.returnHySpexHeader(darkReference.readMeasurementRawHeader());
    }

    public static HySpexHeader readHySpexHeader(Measurement measurement) {
        return RefFrame.returnHySpexHeader(measurement.rawFile().readRawHeader());
    }

    private static HySpexHeader returnHySpexHeader(ByteBuffer byteBuffer) {
        if (byteBuffer != null && byteBuffer.capacity() > 0) {
            try {
                return new HySpexHeader(byteBuffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static RefFrame createRefFrame(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, FloatMatrix floatMatrix3, int n, float f, int[] nArray, RtReferenceTarget rtReferenceTarget, boolean bl) {
        if (floatMatrix != null && (floatMatrix.rows != floatMatrix3.rows || floatMatrix.columns != floatMatrix3.columns)) {
            throw new RuntimeException("Dark reference (" + floatMatrix.columns + "p x " + floatMatrix.rows + "w) has not the same dimensions as White reference (" + floatMatrix3.columns + "p x " + floatMatrix3.rows + "w)");
        }
        FloatMatrix floatMatrix4 = new FloatMatrix(floatMatrix3.rows, floatMatrix3.columns);
        float[] fArray = rtReferenceTarget != null ? rtReferenceTarget.getValuesInv() : null;
        int n2 = 0;
        for (int i = 0; i < floatMatrix3.getColumns(); ++i) {
            int n3 = 0;
            while (n3 < floatMatrix3.getRows()) {
                float f2 = floatMatrix3.get(n2);
                if (floatMatrix != null) {
                    f2 -= floatMatrix.get(n2);
                }
                if (f2 > 0.0f) {
                    if (fArray != null) {
                        float f3 = nArray != null ? fArray[nArray[n3]] : fArray[n3];
                        f2 *= f3;
                    }
                    f2 *= f;
                    if (bl) {
                        floatMatrix4.put(n2, 1.0f / f2);
                    } else {
                        floatMatrix4.put(n2, f2);
                    }
                }
                ++n3;
                ++n2;
            }
        }
        return new RefFrame(floatMatrix, floatMatrix4, floatMatrix2, n);
    }
}

