/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.frame;

import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.realtime.frame.FrameReleasePool;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.PixelWidth;

public class RtFrame
extends Frame {
    public final FloatMatrix[] floatMatrix;
    public final int blocks;
    public final int[] block;
    public final int[] blockOffset;
    public final int[] index;
    private final FrameReleasePool pool;

    public RtFrame(FloatMatrix floatMatrix, int n) {
        this(new BandCount(floatMatrix.rows), new PixelWidth(floatMatrix.columns), BandNames.fromIndex(floatMatrix.rows), n);
        this.copyFrom(floatMatrix);
    }

    public RtFrame(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, int n) {
        this(bandCount, pixelWidth, bandNames, n, null);
    }

    public RtFrame(Frame frame, int n) {
        this(frame.rows, frame.columns, frame.bandNames, n, null);
        for (int i = 0; i < frame.columns.value; ++i) {
            for (int j = 0; j < frame.rows.value; ++j) {
                this.setFrameValue(j, i, frame.getFrameValue(j, i));
            }
        }
    }

    public RtFrame(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, int n, FrameReleasePool frameReleasePool) {
        super(bandCount, pixelWidth, bandNames);
        int n2;
        int n3;
        this.blocks = n;
        if (n > pixelWidth.value) {
            throw new RuntimeException("blocks cannot be more then columns: blocks = " + n + " columns = " + pixelWidth.value);
        }
        this.floatMatrix = new FloatMatrix[n];
        int n4 = pixelWidth.value / n;
        int n5 = pixelWidth.value % n;
        for (n3 = 0; n3 < n; ++n3) {
            n2 = n4 + (n3 < n5 ? 1 : 0);
            this.floatMatrix[n3] = new FloatMatrix(bandCount.value, n2);
        }
        this.block = new int[pixelWidth.value];
        this.blockOffset = new int[n];
        this.index = new int[pixelWidth.value];
        n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            this.blockOffset[n2] = n3;
            for (int i = 0; i < this.floatMatrix[n2].columns; ++i) {
                this.block[n3 + i] = n2;
                this.index[n3 + i] = i;
            }
            n3 += this.floatMatrix[n2].columns;
        }
        this.pool = frameReleasePool;
    }

    public void copyFrom(FloatMatrix floatMatrix) {
        for (int i = 0; i < floatMatrix.columns; ++i) {
            for (int j = 0; j < floatMatrix.rows; ++j) {
                this.setFrameValue(j, i, floatMatrix.get(j, i));
            }
        }
    }

    public void copySpecificRows(int[] nArray, RtFrame rtFrame, int n) {
        FloatMatrix floatMatrix = this.getMatrix(n);
        FloatMatrix floatMatrix2 = rtFrame.getMatrix(n);
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < floatMatrix.columns; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                floatMatrix2.data[j + n3] = floatMatrix.data[nArray[j] + n2];
            }
            n2 += floatMatrix.rows;
            n3 += floatMatrix2.rows;
        }
    }

    @Override
    public final float getFrameValue(int n, int n2) {
        return this.floatMatrix[this.block[n2]].get(n, this.index[n2]);
    }

    public final FloatMatrix getMatrix(int n) {
        return this.floatMatrix[n];
    }

    @Override
    public final void setFrameValue(int n, int n2, float f) {
        this.floatMatrix[this.block[n2]].put(n, this.index[n2], f);
    }

    @Override
    public RtFrame copy() {
        RtFrame rtFrame = new RtFrame(this.getRows(), this.getColumns(), this.getBandNames(), this.getBlocks());
        for (int i = 0; i < this.floatMatrix.length; ++i) {
            rtFrame.floatMatrix[i] = this.floatMatrix[i].dup();
        }
        return rtFrame;
    }

    public int getBlocks() {
        return this.blocks;
    }

    public void releaseIntoPool() {
        if (this.pool != null) {
            this.pool.returnFrame(this);
        }
    }

    @Override
    public DataSize getType() {
        return DataSize.FLOAT_4;
    }

    public static RtFrame createRtMatrix(FloatMatrix floatMatrix, int n) {
        if (floatMatrix != null) {
            return new RtFrame(floatMatrix, n);
        }
        return null;
    }
}

