/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.frame;

import java.util.concurrent.LinkedBlockingQueue;
import se.prediktera.breeze.common.realtime.frame.FramePool;
import se.prediktera.breeze.common.realtime.frame.FrameReleasePool;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.PixelWidth;

public class RtFramePool
implements FrameReleasePool<RtFrame> {
    private final int blocks;
    private final LinkedBlockingQueue<RtFrame> poolQueue = new LinkedBlockingQueue();
    private final PixelWidth pixelWidth;
    private final BandNames bandNames;
    private BandCount bandCount;

    public RtFramePool(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, int n) {
        this.bandCount = bandCount;
        this.pixelWidth = pixelWidth;
        this.bandNames = bandNames;
        this.blocks = n;
        this.initiateFrames();
    }

    private void initiateFrames() {
        for (int i = 0; i < FramePool.INITIAL_POOL_SIZE; ++i) {
            this.poolQueue.add(this.createFrame(this.bandCount, this.pixelWidth, this.bandNames, this.blocks));
        }
    }

    protected RtFrame createFrame(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, int n) {
        return new RtFrame(bandCount, pixelWidth, bandNames, n, this);
    }

    @Override
    public RtFrame getFrame() {
        RtFrame rtFrame = this.poolQueue.poll();
        if (rtFrame == null) {
            return this.createFrame(this.bandCount, this.pixelWidth, this.bandNames, this.blocks);
        }
        return rtFrame;
    }

    @Override
    public void returnFrame(RtFrame rtFrame) {
        this.poolQueue.add(rtFrame);
    }

    @Override
    public void setSize(int n) {
        while (this.poolQueue.size() > n) {
            this.poolQueue.remove();
        }
    }

    @Override
    public boolean equalDimension(BandCount bandCount, PixelWidth pixelWidth) {
        return this.bandCount.value == bandCount.value && this.pixelWidth.value == pixelWidth.value;
    }

    @Override
    public void clear() {
        this.poolQueue.clear();
    }

    @Override
    public void updateBandCount(BandCount bandCount) {
        this.bandCount = bandCount;
        this.clear();
        this.initiateFrames();
    }
}

