/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.frame;

import se.prediktera.breeze.common.realtime.frame.FrameReleasePool;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.realtime.frame.RtFrameAbsorbance;
import se.prediktera.breeze.common.realtime.frame.RtFramePool;
import se.prediktera.breeze.common.realtime.frame.RtFramePoolSingle;
import se.prediktera.breeze.common.util.AbsorbanceToReflectance;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.PixelWidth;

public class RtFramePoolGlobalHandler {
    private static RtFramePoolGlobalHandler instance;
    private static final AbsorbanceToReflectance absToRef;
    private RtFramePool absorbancePool;

    public static RtFramePoolGlobalHandler getInstance() {
        if (instance == null) {
            instance = new RtFramePoolGlobalHandler();
        }
        return instance;
    }

    public static void clearInstance() {
        if (instance != null) {
            instance.clear();
        }
        instance = null;
    }

    public FrameReleasePool<RtFrame> createAbsorbancePool(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, int n, boolean bl) {
        if (bl) {
            if (this.absorbancePool != null) {
                if (this.absorbancePool.equalDimension(bandCount, pixelWidth)) {
                    return this.absorbancePool;
                }
                this.absorbancePool.clear();
                System.gc();
            }
            this.absorbancePool = new RtFramePool(this, bandCount, pixelWidth, bandNames, n){

                @Override
                protected RtFrame createFrame(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, int n) {
                    return new RtFrameAbsorbance(bandCount, pixelWidth, bandNames, n, this, absToRef);
                }
            };
            return this.absorbancePool;
        }
        return new RtFramePoolSingle(bandCount, pixelWidth, bandNames, n);
    }

    public FrameReleasePool<RtFrame> createRawPool(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, int n, boolean bl) {
        if (bl) {
            return new RtFramePool(bandCount, pixelWidth, bandNames, n);
        }
        return new RtFramePoolSingle(bandCount, pixelWidth, bandNames, n);
    }

    public void clear() {
        if (this.absorbancePool != null) {
            this.absorbancePool.clear();
        }
    }

    static {
        absToRef = new AbsorbanceToReflectance();
    }
}

