/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.frame;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.realtime.frame.RtModelFrame;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.PixelWidth;

public class RtFrameStack
implements FrameStack {
    private RawFrame frame;
    private FrameStack rawFrameStack;
    private RtFrame rawFrame;
    private RtFrame reflectanceFrame;
    private RtFrame absorbanceFrame;
    private final HashMap<String, RtModelFrame> modelFrameHashMap = new LinkedHashMap<String, RtModelFrame>();
    private final HashMap<String, RtFrame> frameHashMap = new LinkedHashMap<String, RtFrame>();
    private int pixelCountWithSample;
    private int usage;
    private long frameNumber;

    public RtFrameStack() {
    }

    public RtFrameStack(long l) {
        this.frameNumber = l;
    }

    public RtFrameStack(RtFrame rtFrame) {
        this.rawFrame = rtFrame;
    }

    public RtFrameStack(RtFrame rtFrame, RtFrame rtFrame2, String string, RtModelFrame rtModelFrame) {
        this.rawFrame = rtFrame;
        this.absorbanceFrame = rtFrame2;
        this.modelFrameHashMap.put(string, rtModelFrame);
    }

    public RtFrameStack(RtFrame rtFrame, RtFrame rtFrame2) {
        this.reflectanceFrame = rtFrame;
        this.absorbanceFrame = rtFrame2;
    }

    public void setRawFrame(RtFrame rtFrame) {
        this.rawFrame = rtFrame;
    }

    public void setRawFrameStack(FrameStack frameStack) {
        this.rawFrameStack = frameStack;
    }

    public void setReflectanceFrame(RtFrame rtFrame) {
        this.reflectanceFrame = rtFrame;
    }

    public void setAbsorbanceFrame(RtFrame rtFrame) {
        this.absorbanceFrame = rtFrame;
    }

    public void addModelFrame(RtModelFrame rtModelFrame) {
        this.modelFrameHashMap.put(rtModelFrame.getAnalyseUid(), rtModelFrame);
    }

    public void addFrame(String string, RtFrame rtFrame) {
        this.frameHashMap.put(string, rtFrame);
    }

    public void setFrame(RawFrame rawFrame) {
        this.frame = rawFrame;
    }

    @Override
    public RawFrame getFrame() {
        return this.frame;
    }

    public RtFrame rawFrame() {
        return this.rawFrame;
    }

    public RtFrame getReflectanceFrame() {
        return this.reflectanceFrame;
    }

    public RtFrame getAbsorbanceFrame() {
        return this.absorbanceFrame;
    }

    public RtModelFrame getModelFrame(String string) {
        RtModelFrame rtModelFrame = this.modelFrameHashMap.get(string);
        if (rtModelFrame == null) {
            throw new RuntimeException(String.format("No model frame found with uid %s", string));
        }
        return rtModelFrame;
    }

    public RtFrame getFrame(String string) {
        return this.frameHashMap.get(string);
    }

    public PixelWidth getWidth() {
        return this.rawFrame.getColumns();
    }

    public BandCount getBandCount() {
        return this.rawFrame.getRows();
    }

    public RtFrame getReflectanceOrRawFrame() {
        if (this.reflectanceFrame != null) {
            return this.reflectanceFrame;
        }
        return this.rawFrame;
    }

    public RtFrame getReferenceOrRawFrame() {
        if (this.absorbanceFrame != null) {
            return this.absorbanceFrame;
        }
        if (this.reflectanceFrame != null) {
            return this.reflectanceFrame;
        }
        return this.rawFrame;
    }

    public Collection<RtModelFrame> getModelFrames() {
        return this.modelFrameHashMap.values();
    }

    public boolean hasModelFrames() {
        return this.modelFrameHashMap.size() > 0;
    }

    public void increaseUsage() {
        ++this.usage;
    }

    public int getUsage() {
        return this.usage;
    }

    public void releaseFrames() {
        if (--this.usage <= 0) {
            this.releaseFramesNoUsage();
        }
    }

    public void releaseFramesNoUsage() {
        this.rawFrame.releaseIntoPool();
        if (this.reflectanceFrame != null) {
            this.reflectanceFrame.releaseIntoPool();
        }
        if (this.absorbanceFrame != null) {
            this.absorbanceFrame.releaseIntoPool();
        }
        for (RtModelFrame rtModelFrame : this.modelFrameHashMap.values()) {
            rtModelFrame.releaseIntoPool();
        }
    }

    @Override
    public long getInTime() {
        if (this.rawFrameStack != null) {
            return this.rawFrameStack.getInTime();
        }
        return 0L;
    }

    @Override
    public long getFrameNumber() {
        if (this.rawFrameStack != null) {
            return this.rawFrameStack.getFrameNumber();
        }
        return this.frameNumber;
    }

    public void setFrameNumber(long l) {
        this.frameNumber = l;
    }

    public void setPixelCountWithSample(int n) {
        this.pixelCountWithSample = n;
    }

    public int getPixelCountWithSample() {
        return this.pixelCountWithSample;
    }
}

