/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.frame;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.realtime.frame.RtFrameStack;
import se.prediktera.breeze.common.util.image.RtSpatialObject;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;

public class RtFrameStackList
implements Iterable<RtFrameStack> {
    private final List<RtFrameStack> frameStackList;
    private final Rectangle boundingBox;
    private final float[] average;

    public RtFrameStackList(List<RtFrameStack> list) {
        this(list, null, null);
    }

    public RtFrameStackList(List<RtFrameStack> list, Rectangle rectangle, float[] fArray) {
        this.frameStackList = list;
        this.boundingBox = rectangle;
        this.average = fArray;
    }

    public FrameCount frameCount() {
        return new FrameCount(this.frameStackList.size());
    }

    public FrameCount droppedFrames() {
        long l;
        if (this.frameStackList.size() > 0 && (l = this.frameStackList.get(this.frameStackList.size() - 1).getFrameNumber() - this.frameStackList.get(0).getFrameNumber() + 1L) > 0L) {
            return new FrameCount((int)(l - (long)this.frameStackList.size()));
        }
        return new FrameCount(0);
    }

    public boolean isEmpty() {
        return this.frameCount().value == 0;
    }

    public PixelWidth getWidth() {
        return this.frameStackList.get(0).getWidth();
    }

    public PixelWidth getBoundingBoxWidth() {
        if (this.boundingBox != null) {
            return new PixelWidth(this.boundingBox.width);
        }
        return this.getWidth();
    }

    public BandCount getBandCount() {
        return this.frameStackList.get(0).getBandCount();
    }

    public Rectangle getBoundingBox() {
        return this.boundingBox;
    }

    public boolean hasModelFrames() {
        return !this.isEmpty() && this.getFrameStack(0).hasModelFrames();
    }

    public RtFrameStack getFrameStack(int n) {
        return this.frameStackList.get(n);
    }

    public List<RtFrame> getRawFrameList() {
        ArrayList<RtFrame> arrayList = new ArrayList<RtFrame>(this.frameStackList.size());
        for (RtFrameStack rtFrameStack : this.frameStackList) {
            arrayList.add(rtFrameStack.rawFrame());
        }
        return arrayList;
    }

    public RealtimeFrameList getReflectanceOrRawFrameList() {
        RealtimeFrameList realtimeFrameList = new RealtimeFrameList(this.frameStackList.size());
        for (RtFrameStack rtFrameStack : this.frameStackList) {
            realtimeFrameList.add(rtFrameStack.getReflectanceOrRawFrame());
        }
        return realtimeFrameList;
    }

    public RealtimeFrameList getReferenceOrRawFrameList() {
        RealtimeFrameList realtimeFrameList = new RealtimeFrameList(this.frameStackList.size());
        for (RtFrameStack rtFrameStack : this.frameStackList) {
            realtimeFrameList.add(rtFrameStack.getReferenceOrRawFrame());
        }
        return realtimeFrameList;
    }

    public RealtimeFrameList getModelFrameList(String string) {
        RealtimeFrameList realtimeFrameList = new RealtimeFrameList(this.frameStackList.size());
        for (RtFrameStack rtFrameStack : this.frameStackList) {
            realtimeFrameList.add(rtFrameStack.getModelFrame(string));
        }
        return realtimeFrameList;
    }

    public RealtimeFrameList getFrameList(String string) {
        RealtimeFrameList realtimeFrameList = new RealtimeFrameList(this.frameStackList.size());
        for (RtFrameStack rtFrameStack : this.frameStackList) {
            realtimeFrameList.add(rtFrameStack.getFrame(string));
        }
        return realtimeFrameList;
    }

    public void releaseFrameStacksNoClear() {
        for (RtFrameStack rtFrameStack : this.frameStackList) {
            rtFrameStack.releaseFrames();
        }
    }

    public void releaseFrameStacks() {
        this.releaseFrameStacksNoClear();
        this.frameStackList.clear();
    }

    @Override
    public Iterator iterator() {
        return this.frameStackList.iterator();
    }

    public float[][] getOrCalcualteAverages(RtSpatialObject rtSpatialObject) {
        if (this.average != null) {
            return new float[][]{this.average};
        }
        return RtFrameStackList.calculateAverageProfile(this, rtSpatialObject);
    }

    public static float[][] calculateAverageProfile(RtFrameStackList rtFrameStackList, RtSpatialObject rtSpatialObject) {
        RealtimeFrameList realtimeFrameList = rtFrameStackList.getReferenceOrRawFrameList();
        BandCount bandCount = realtimeFrameList.getBandCount();
        int n4 = rtSpatialObject.getArea();
        double[][] dArray = new double[1][bandCount.value];
        rtSpatialObject.forEveryPixel((n, n2, n3) -> {
            RtFrame rtFrame = (RtFrame)realtimeFrameList.get(n2);
            for (int i = 0; i < bandCount.value; ++i) {
                double[] dArray2 = dArray[0];
                int n4 = i;
                dArray2[n4] = dArray2[n4] + (double)rtFrame.getFrameValue(i, n);
            }
        });
        float[][] fArray = new float[1][bandCount.value];
        for (int i = 0; i < bandCount.value; ++i) {
            fArray[0][i] = (float)(dArray[0][i] / (double)n4);
        }
        return fArray;
    }

    public static class RealtimeFrameList
    extends ArrayList<RtFrame> {
        public RealtimeFrameList(int n) {
            super(n);
        }

        public final PixelWidth getWidth() {
            return ((RtFrame)this.get(0)).getColumns();
        }

        public final BandCount getBandCount() {
            return ((RtFrame)this.get(0)).getRows();
        }

        public final float getFrameValue(int n, int n2, int n3) {
            return ((RtFrame)this.get(n3)).getFrameValue(n, n2);
        }
    }

    public static class Builder {
        private final List<RtFrameStack> frameStackList = new ArrayList<RtFrameStack>();

        public void addFrame(RtFrameStack rtFrameStack) {
            this.frameStackList.add(rtFrameStack);
        }

        public RtFrameStackList build() {
            return new RtFrameStackList(this.frameStackList);
        }
    }
}

