/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.frame;

import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.realtime.frame.FramePool;
import se.prediktera.breeze.common.realtime.frame.FrameReleasePool;
import se.prediktera.breeze.common.realtime.frame.RtModelFrame;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.PixelWidth;

public class RtModelFramePool
implements FrameReleasePool<RtModelFrame> {
    private final PixelWidth frameColumns;
    private final int blocks;
    private final String analyseUid;
    private final List<String> bandNames;
    private final LinkedBlockingQueue<RtModelFrame> poolQueue = new LinkedBlockingQueue();

    public RtModelFramePool(PixelWidth pixelWidth, int n, String string, List<String> list) {
        this.frameColumns = pixelWidth;
        this.blocks = n;
        this.analyseUid = string;
        this.bandNames = list;
        for (int i = 0; i < FramePool.INITIAL_POOL_SIZE; ++i) {
            this.poolQueue.add(new RtModelFrame(string, list, pixelWidth, n, (FrameReleasePool)this));
        }
    }

    @Override
    public RtModelFrame getFrame() {
        RtModelFrame rtModelFrame = this.poolQueue.poll();
        if (rtModelFrame == null) {
            return new RtModelFrame(this.analyseUid, this.bandNames, this.frameColumns, this.blocks, (FrameReleasePool)this);
        }
        return rtModelFrame;
    }

    @Override
    public void returnFrame(RtModelFrame rtModelFrame) {
        this.poolQueue.add(rtModelFrame);
    }

    @Override
    public void setSize(int n) {
        while (this.poolQueue.size() > n) {
            this.poolQueue.remove();
        }
    }

    @Override
    public boolean equalDimension(BandCount bandCount, PixelWidth pixelWidth) {
        return this.bandNames.size() == bandCount.value && this.frameColumns.value == pixelWidth.value;
    }

    @Override
    public void clear() {
        this.poolQueue.clear();
    }

    public static RtModelFramePool fromClassification(PixelWidth pixelWidth, int n, BasicAnalyse basicAnalyse) {
        return new RtModelFramePool(pixelWidth, n, basicAnalyse.getUid(), List.of(basicAnalyse.getUid() + "_" + basicAnalyse.getCategoryFactor().getUid()));
    }

    @Override
    public void updateBandCount(BandCount bandCount) {
        throw new RuntimeException("Not implemented");
    }
}

