/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation;

import org.w3c.dom.Node;
import se.prediktera.breeze.common.realtime.descriptor.parameter.ExpressionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.SegmentationParameter;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentationInfo;
import se.prediktera.breeze.common.realtime.segmentation.spatial.IntensitySegmentation;

public abstract class AbstractHolderSegmentation
extends AbstractSegmentation {
    private NumberParameter minAreaParameter;
    private NumberParameter shrinkParameter;
    private SegmentationParameter segmentationParameter;

    public AbstractHolderSegmentation(AbstractSegmentationInfo abstractSegmentationInfo) {
        this(abstractSegmentationInfo, 50);
    }

    public AbstractHolderSegmentation(AbstractSegmentationInfo abstractSegmentationInfo, int n) {
        super(abstractSegmentationInfo);
        this.minAreaParameter = new NumberParameter("minarea", "Min area", n, "Min area in pixels");
        this.addParameter(this.minAreaParameter);
        this.addParameter(new NumberParameter("maxarea", "Max area", 0.0, "Max area in pixels (0 = Inf)"));
        this.addParameter(new FilterExpressionParameter());
        this.shrinkParameter = new NumberParameter("shrink", "Shrink", 0.0, "Remove number of pixels from border");
        this.addParameter(this.shrinkParameter);
        this.segmentationParameter = new SegmentationParameter("object");
        this.addParameter(this.segmentationParameter);
    }

    public int getMinArea() {
        return this.minAreaParameter.getValueInt();
    }

    public int getShrink() {
        return this.shrinkParameter.getValueInt();
    }

    public SegmentationParameter.SeparateOption getSeparateOption() {
        return this.segmentationParameter.getOp();
    }

    public static class FilterExpressionParameter
    extends ExpressionParameter {
        private IntensitySegmentation.SpatialExpression spatialExpression = new IntensitySegmentation.SpatialExpression();

        public FilterExpressionParameter() {
            super("objectExpression", "Object filter", "expression", "Example: roundness > 0.5");
            this.add(this.spatialExpression);
        }

        public void set(String string) {
            this.spatialExpression.set(string);
        }

        protected ExpressionParameter.Expression createList(Node node) {
            this.spatialExpression = new IntensitySegmentation.SpatialExpression(node);
            return this.spatialExpression;
        }
    }
}

