/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation;

import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.CameraParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentationInfo;
import se.prediktera.breeze.hardware.Camera;

public class CameraSegmentation
extends AbstractSegmentation {
    private CameraParameter cameraBandParameter = new CameraParameter("camera", "Custom bands");
    private NumberParameter numberParameter;

    public CameraSegmentation(AbstractSegmentationInfo abstractSegmentationInfo) {
        super(abstractSegmentationInfo);
        this.addParameter(this.cameraBandParameter);
        this.numberParameter = new NumberParameter("bands", "Bands", 0.0, "");
        this.addParameter(this.numberParameter);
        this.numberParameter.setVisible(() -> {
            Camera camera = this.cameraBandParameter.getCamera();
            if (camera != null) {
                this.numberParameter.setEditable(false);
                if (camera.isConnected()) {
                    this.numberParameter.setValue(camera.getBandCount().value);
                }
            } else {
                this.numberParameter.setEditable(true);
            }
            return true;
        });
        this.addOutput("value");
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        Camera camera = this.cameraBandParameter.getCamera();
        if (camera != null) {
            return Camera.getCameraTypeName(camera);
        }
        return "Camera " + this.getParameterByName("bands").getValueStr();
    }

    public static class Info
    extends AbstractSegmentationInfo {
        @Override
        public String getImageIcon() {
            return "switch_camera";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new CameraSegmentation(this);
        }

        public String toString() {
            return "CameraSegmentation";
        }

        @Override
        public String getName() {
            return "Camera";
        }

        @Override
        public String getDescription() {
            return "Camera band count";
        }

        @Override
        public String getShortDescription() {
            return "Camera";
        }

        @Override
        public String getHelp() {
            return "camera-segmentation";
        }
    }
}

