/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation;

import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentationInfo;
import se.prediktera.breeze.common.util.MinMax;

public class FramesSegmentation
extends AbstractSegmentation {
    public FramesSegmentation(AbstractSegmentationInfo abstractSegmentationInfo) {
        super(abstractSegmentationInfo);
        this.addParameter(new NumberParameter("frames", "Frames", 10.0, "", new MinMax(1.0f, 2.1474836E9f)));
        this.addParameter(new NumberParameter("gap", "Gap", 0.0, "", new MinMax(0.0f, 2.1474836E9f)));
        this.addParameter(new NumberParameter("overlap", "Overlap", 0.0, "", new MinMax(0.0f, 2.1474836E9f)));
        this.addParameter(new BooleanParameter("reqsamples", "Requires samples (Play mode)", "Only store measurements that contain subsamples", false));
        this.addOutput("value");
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return "Frames " + this.getParameterByName("frames").getValueStr();
    }

    public static class Info
    extends AbstractSegmentationInfo {
        @Override
        public String getImageIcon() {
            return "frame-stack";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new FramesSegmentation(this);
        }

        public String toString() {
            return "FramesSegmentation";
        }

        @Override
        public String getName() {
            return "Frames";
        }

        @Override
        public String getDescription() {
            return "Number of frames";
        }

        @Override
        public String getShortDescription() {
            return "Frames";
        }

        @Override
        public String getHelp() {
            return "frames-segmentation";
        }
    }
}

