/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation;

import javax.swing.filechooser.FileFilter;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FileParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentationInfo;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class NematodeSegmentation
extends AbstractSegmentation {
    public NematodeSegmentation(AbstractSegmentationInfo abstractSegmentationInfo) {
        super(abstractSegmentationInfo);
        this.addParameter(new BooleanParameter("order", "Kernel before PCA", "", true));
        this.addParameter(new FileParameter("modelfile", "Model file", "", ""));
        this.addParameter(new NumberParameter("mean", "Mean", 0.5, "", new MinMax(-2.1474836E9f, 2.1474836E9f)));
        this.addParameter(new NumberParameter("std", "Std", 1.0, ""));
        this.addParameter(new NumberParameter("r1", "R1", 1.0, ""));
        this.addParameter(new NumberParameter("r2", "R2", 2.0, ""));
        this.addParameter(new NumberParameter("r3", "R3", 5.0, ""));
        this.addParameter(new NumberParameter("threshold", "Threshold", 0.9, ""));
        this.addParameter(new FileParameter(this, "onnxfile", "Onnx file", "", ""){

            @Override
            public void customizeDialog(jopensaveDialog jopensaveDialog2) {
                jopensaveDialog2.setAcceptAllFileFilterUsed(true);
                FileParameter.ExtensionFilter extensionFilter = new FileParameter.ExtensionFilter("onnx", "Open Neural Network Exchange (*.onnx)");
                jopensaveDialog2.addChoosableFileFilter((FileFilter)extensionFilter);
                jopensaveDialog2.setFileFilter((FileFilter)extensionFilter);
            }
        });
        this.addParameter(new NumberParameter("onnxthreads", "Onnx threads", 0.0, "0 = All available"));
        this.addOutput("value");
    }

    public static class Info
    extends AbstractSegmentationInfo {
        @Override
        public String getImageIcon() {
            return "nematode";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new NematodeSegmentation(this);
        }

        public String toString() {
            return "NematodeSegmentation";
        }

        @Override
        public String getName() {
            return "NematodeSegmentation";
        }

        @Override
        public String getDescription() {
            return "Nematode detection";
        }

        @Override
        public String getHelp() {
            return null;
        }
    }
}

