/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.Arrays;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.entry.sample.MergedSample;
import se.prediktera.breeze.entry.sample.Sample;

public class SampleImageMask {
    private final BufferedImage maskImage;
    private final Rectangle bounds;
    private final byte[] maskData;
    private float[] descriptorValues;

    public SampleImageMask(BasicSample basicSample, Rectangle rectangle) {
        this(basicSample.getOrCreateGeneralPath(), rectangle);
    }

    public SampleImageMask(Shape shape, Rectangle rectangle) {
        this.bounds = rectangle;
        this.maskImage = new BufferedImage(rectangle.width, rectangle.height, 10);
        Graphics2D graphics2D = (Graphics2D)this.maskImage.getGraphics();
        graphics2D.translate(-rectangle.x, -rectangle.y);
        graphics2D.setColor(Color.white);
        graphics2D.fill(shape);
        graphics2D.dispose();
        this.maskData = ((DataBufferByte)this.maskImage.getRaster().getDataBuffer()).getData();
    }

    public int getWidth() {
        return this.maskImage.getWidth();
    }

    public int getHeight() {
        return this.maskImage.getHeight();
    }

    public boolean hasData(int n) {
        return this.maskData[n] != 0;
    }

    public void addSampleValues(Sample sample, DescriptorTreeNode descriptorTreeNode) {
        this.descriptorValues = new float[this.maskData.length];
        if (sample instanceof MergedSample) {
            MergedSample mergedSample = (MergedSample)sample;
            for (Sample sample2 : mergedSample.getSamples()) {
                Shape shape = sample2.getSamplePath().getOrCreateGeneralPath();
                float f = sample2.getDescriptorHolder().getDescriptorValue(descriptorTreeNode);
                BufferedImage bufferedImage = new BufferedImage(this.bounds.width, this.bounds.height, 10);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.translate(-this.bounds.x, -this.bounds.y);
                graphics2D.setColor(Color.white);
                graphics2D.fill(shape);
                graphics2D.dispose();
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] == 0) continue;
                    this.descriptorValues[i] = f;
                }
            }
        } else {
            Arrays.fill(this.descriptorValues, sample.getDescriptorHolder().getDescriptorValue(descriptorTreeNode));
        }
    }

    public float sampleValue(int n) {
        return this.descriptorValues[n];
    }

    public Rectangle getBounds() {
        return this.bounds;
    }
}

