/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation;

import java.awt.Rectangle;
import java.awt.Shape;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import se.prediktera.breeze.common.realtime.segmentation.SampleImageMask;
import se.prediktera.breeze.common.util.RtDataFormat;

public class SegmentationMatrix {
    private final int[][] data;
    private final int[][] idMatrix;
    private int rowsPadding;
    private int columnsPadding;

    public SegmentationMatrix(int n, int n2) {
        this.rowsPadding = n + 3;
        this.columnsPadding = n2 + 2;
        this.data = new int[this.rowsPadding][this.columnsPadding];
        this.idMatrix = new int[this.rowsPadding][this.columnsPadding];
    }

    public void resize(int n, int n2) {
        this.rowsPadding = n + 2;
        this.columnsPadding = n2 + 2;
        for (int i = 0; i < this.rowsPadding; ++i) {
            for (int j = 0; j < this.columnsPadding; ++j) {
                this.data[i][j] = 0;
                this.idMatrix[i][j] = 0;
            }
        }
    }

    public final int getValue(int n, int n2) {
        return this.data[n + 1][n2 + 1];
    }

    public final void setValue(int n, int n2, int n3) {
        this.data[n + 1][n2 + 1] = n3;
    }

    public final int[][] getIdMatrix() {
        return this.idMatrix;
    }

    public final void forEachForwards(ValueCallback valueCallback) {
        int n = this.rowsPadding - 1;
        int n2 = this.columnsPadding - 1;
        for (int i = 1; i < n; ++i) {
            int n3 = i - 1;
            for (int j = 1; j < n2; ++j) {
                valueCallback.onValue(this.data[i][j], n3, j - 1);
            }
        }
    }

    public final void forEachBackwards(ValueCallback valueCallback) {
        for (int i = this.rowsPadding - 2; i >= 1; --i) {
            int n = i - 1;
            for (int j = this.columnsPadding - 2; j >= 1; --j) {
                valueCallback.onValue(this.data[i][j], n, j - 1);
            }
        }
    }

    public final boolean forEachForwardsContains(ValueBoolCallback valueBoolCallback) {
        int n = this.rowsPadding - 1;
        int n2 = this.columnsPadding - 1;
        for (int i = 1; i < n; ++i) {
            int n3 = i - 1;
            for (int j = 1; j < n2; ++j) {
                if (!valueBoolCallback.onValue(this.data[i][j], n3, j - 1)) continue;
                return true;
            }
        }
        return false;
    }

    public void printMatrix() {
        System.out.println();
        for (int i = 1; i < this.rowsPadding - 2; ++i) {
            System.out.print("new int[] {");
            for (int j = 1; j < this.columnsPadding - 2; ++j) {
                if (j > 1) {
                    System.out.print(",");
                }
                System.out.print(RtDataFormat.toString(this.data[i][j]));
            }
            System.out.println("},");
        }
    }

    public void printWithPadding() {
        System.out.println();
        for (int i = 0; i < this.rowsPadding; ++i) {
            for (int j = 0; j < this.columnsPadding; ++j) {
                System.out.print(RtDataFormat.toString(this.data[i][j]));
            }
            System.out.println();
        }
    }

    public void save(File file) {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            int n = this.rowsPadding - 1;
            int n2 = this.columnsPadding - 1;
            for (int i = 1; i < n; ++i) {
                for (int j = 1; j < n2; ++j) {
                    if (j > 1) {
                        bufferedWriter.write(",");
                    }
                    bufferedWriter.write(RtDataFormat.toString(this.data[i][j]));
                }
                bufferedWriter.newLine();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static SegmentationMatrix createFromFile(File file) throws IOException {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        try (String[] stringArray = new BufferedReader(new FileReader(file));){
            while ((object = stringArray.readLine()) != null) {
                arrayList.add((String)object);
            }
        }
        stringArray = ((String)arrayList.get(0)).split(",");
        object = new SegmentationMatrix(arrayList.size(), stringArray.length);
        for (int i = 0; i < arrayList.size(); ++i) {
            String[] stringArray = ((String)arrayList.get(i)).split(",");
            for (int j = 0; j < stringArray.length; ++j) {
                ((SegmentationMatrix)object).setValue(i, j, RtDataFormat.toNumberInt(stringArray[j]));
            }
        }
        return object;
    }

    public static SegmentationMatrix createFromShape(Shape shape) {
        Rectangle rectangle = new Rectangle(0, 0, shape.getBounds().width + 1, shape.getBounds().height + 1);
        SampleImageMask sampleImageMask = new SampleImageMask(shape, rectangle);
        SegmentationMatrix segmentationMatrix = new SegmentationMatrix(rectangle.height, rectangle.width);
        int n = 0;
        for (int i = 0; i < rectangle.height; ++i) {
            int n2 = 0;
            while (n2 < rectangle.width) {
                segmentationMatrix.setValue(i, n2, sampleImageMask.hasData(n) ? 1 : 0);
                ++n2;
                ++n;
            }
        }
        return segmentationMatrix;
    }

    public static SegmentationMatrix createFromData(int[][] nArray) {
        SegmentationMatrix segmentationMatrix = new SegmentationMatrix(nArray.length, nArray[0].length);
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                segmentationMatrix.setValue(i, j, nArray[i][j]);
            }
        }
        return segmentationMatrix;
    }

    public static interface ValueCallback {
        public void onValue(int var1, int var2, int var3);
    }

    public static interface ValueBoolCallback {
        public boolean onValue(int var1, int var2, int var3);
    }
}

