/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.realtime.descriptor.parameter.ExpressionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.spectralLibraries.GroupCatClass;
import se.prediktera.breeze.common.realtime.descriptor.usgs.groups.MicaGroups;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentationInfo;
import se.prediktera.breeze.common.realtime.segmentation.model.AbstractModelSegmentation;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.polynom.RtPolyNode;

public class ModelExpressionSegmentation
extends AbstractModelSegmentation {
    private final ModelExpressionParameter parameter = new ModelExpressionParameter();

    public ModelExpressionSegmentation(AbstractSegmentationInfo abstractSegmentationInfo) {
        super(abstractSegmentationInfo);
        this.addParameter(this.parameter, 2);
        this.addOutput("value");
    }

    @Override
    public Factor getFactor(int n) {
        BasicAnalyse basicAnalyse = this.getAnalyse();
        if (basicAnalyse != null) {
            if (basicAnalyse.getModelMethod().isClassification()) {
                return basicAnalyse.getCategoryFactor();
            }
            return basicAnalyse.getPropertyFactors().get(n);
        }
        return super.getFactor(n);
    }

    @Override
    public List<BasicAnalyse.ModelType> getModelTypes() {
        return Arrays.asList(BasicAnalyse.ModelType.Sample, BasicAnalyse.ModelType.Quantification, BasicAnalyse.ModelType.Classification);
    }

    public ModelExpressionParameter getExpression() {
        return this.parameter;
    }

    @Override
    public String getOutputName(int n) {
        return "Segmentation";
    }

    public static class ModelExpressionParameter
    extends ExpressionParameter<ModelExpression> {
        private ModelExpression modelExpression = new ModelExpression();

        public ModelExpressionParameter() {
            super("Expression", "id", "Example: class = classname or variablename > 2");
            this.add(this.modelExpression);
        }

        public void set(String string) {
            this.modelExpression.set(string);
        }

        @Override
        protected ModelExpression createList(Node node) {
            this.modelExpression = new ModelExpression(node);
            return this.modelExpression;
        }

        @Override
        public void copy(FunctionParameter functionParameter) {
            super.copy(functionParameter);
            this.modelExpression = (ModelExpression)this.getExpressionLists().get(0);
        }

        public ModelExpression getModelExpression() {
            return this.modelExpression;
        }
    }

    public static class Info
    extends AbstractSegmentationInfo {
        @Override
        public String getImageIcon() {
            return "classification";
        }

        @Override
        public ModelExpressionSegmentation createFunction() {
            return new ModelExpressionSegmentation(this);
        }

        public String toString() {
            return "ModelExpressionSegmentation";
        }

        @Override
        public String getName() {
            return "ModelExpression";
        }

        @Override
        public String getShortDescription() {
            return "Model expression";
        }

        @Override
        public String getDescription() {
            return "Separate sample from background using model expression";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Model;
        }

        @Override
        public String getHelp() {
            return "model-expression";
        }

        @Override
        public List<String> getKeywords() {
            return Arrays.asList("plsda", "pls", "machinelearning", "onnx");
        }
    }

    public static abstract class ExpInside {
        protected final float value;

        public ExpInside(float f) {
            this.value = f;
        }

        public abstract boolean inside(float var1);

        public static class ExpSideGreaterEquals
        extends ExpInside {
            public ExpSideGreaterEquals(float f) {
                super(f);
            }

            @Override
            public boolean inside(float f) {
                return f >= this.value;
            }
        }

        public static class ExpSideGreater
        extends ExpInside {
            public ExpSideGreater(float f) {
                super(f);
            }

            @Override
            public boolean inside(float f) {
                return f > this.value;
            }
        }

        public static class ExpSideLessEquals
        extends ExpInside {
            public ExpSideLessEquals(float f) {
                super(f);
            }

            @Override
            public boolean inside(float f) {
                return f <= this.value;
            }
        }

        public static class ExpSideLess
        extends ExpInside {
            public ExpSideLess(float f) {
                super(f);
            }

            @Override
            public boolean inside(float f) {
                return f < this.value;
            }
        }

        public static class ExpSideEqual
        extends ExpInside {
            public ExpSideEqual(float f) {
                super(f);
            }

            @Override
            public boolean inside(float f) {
                return this.value == f;
            }
        }
    }

    public static class ExpInsideList
    extends ArrayList<ExpInside> {
        public boolean contains(float f, Class clazz) {
            for (ExpInside expInside : this) {
                if (!expInside.getClass().equals(clazz) || expInside.value != f) continue;
                return true;
            }
            return false;
        }

        public boolean anyInside(float f) {
            for (ExpInside expInside : this) {
                if (!expInside.inside(f)) continue;
                return true;
            }
            return false;
        }
    }

    public static class ModelExpression
    extends ExpressionParameter.Expression<Float> {
        private List<RtPolyNode> polyNodes = new ArrayList<RtPolyNode>();
        private List<RtPolyNode> constantNodes = new ArrayList<RtPolyNode>();
        private final List<RtPolyNode> avgNodes = new ArrayList<RtPolyNode>();
        private CategoryFactor categoryFactor;

        public ModelExpression() {
        }

        public void prepare(BasicAnalyse basicAnalyse) {
            this.polyNodes.clear();
            this.constantNodes.clear();
            this.avgNodes.clear();
            if (basicAnalyse.getModelMethod().isClassification()) {
                this.polyNodes.add(new RtPolyNode("CLASS"));
                this.categoryFactor = basicAnalyse.getCategoryFactor();
                for (CatClass catClass : this.categoryFactor.getLeafs()) {
                    RtPolyNode rtPolyNode = new RtPolyNode(this.getClassName(catClass));
                    rtPolyNode.setNum(this.categoryFactor.getClassIndex(catClass));
                    this.constantNodes.add(rtPolyNode);
                }
            } else {
                for (PropertyFactor propertyFactor : basicAnalyse.getPropertyFactors()) {
                    this.polyNodes.add(new RtPolyNode(StringHelper.removeSpace(propertyFactor.getName()).toUpperCase()));
                }
            }
        }

        private String getClassName(CatClass catClass) {
            if (catClass.isNoClass()) {
                return "none";
            }
            return StringHelper.removeNonAlphanumericCharacters(catClass.getName()).toUpperCase();
        }

        public ModelExpression(Node node) {
            super(node);
        }

        public boolean evaluate(RtFrame rtFrame, int n) {
            for (int i = 0; i < rtFrame.rows.value; ++i) {
                this.polyNodes.get(i).setNum(rtFrame.getFrameValue(i, n));
            }
            return this.parser.evaluateRelation();
        }

        public ModelExpression clone(FunctionParameter functionParameter) {
            ModelExpression modelExpression = (ModelExpression)super.clone(functionParameter);
            modelExpression.polyNodes = new ArrayList<RtPolyNode>();
            modelExpression.constantNodes = new ArrayList<RtPolyNode>();
            return modelExpression;
        }

        public List<RtPolyNode> getAvgNodes() {
            return this.avgNodes;
        }

        private RtPolyNode[] getIdArray() {
            ArrayList<RtPolyNode> arrayList = new ArrayList<RtPolyNode>();
            arrayList.addAll(this.polyNodes);
            arrayList.addAll(this.constantNodes);
            return arrayList.toArray(new RtPolyNode[0]);
        }

        public ExpInsideList getSimpleExpressionValues(BasicAnalyse basicAnalyse) {
            ExpInsideList expInsideList = new ExpInsideList();
            this.prepare(basicAnalyse);
            RtPolyNode[] rtPolyNodeArray = this.getIdArray();
            if (rtPolyNodeArray.length > 0) {
                this.parser.parse(this.getExpression(), rtPolyNodeArray);
                RtPolyNode rtPolyNode = this.parser.getRoot();
                if (rtPolyNode != null) {
                    this.processNode(rtPolyNode, expInsideList);
                }
            }
            return expInsideList;
        }

        private void processNode(RtPolyNode rtPolyNode, ExpInsideList expInsideList) {
            int n = rtPolyNode.getType();
            if (n == 124 && rtPolyNode.hasBothChildren()) {
                this.processNode(rtPolyNode.getLeft(), expInsideList);
                this.processNode(rtPolyNode.getRight(), expInsideList);
            } else if (n == 38 && rtPolyNode.hasBothChildren()) {
                this.processNode(rtPolyNode.getLeft(), expInsideList);
                this.processNode(rtPolyNode.getRight(), expInsideList);
            } else if (n == 61 && rtPolyNode.hasBothChildren()) {
                this.processEqualityNode(rtPolyNode, expInsideList);
            } else if (n == 33 && rtPolyNode.hasBothChildren()) {
                this.processInequalityNode(rtPolyNode, expInsideList);
            } else if (n == 7) {
                if (rtPolyNode.getRight() != null) {
                    this.processNode(rtPolyNode.getRight(), expInsideList);
                }
            } else if ((n == 60 || n == 91 || n == 62 || n == 93) && rtPolyNode.hasBothChildren()) {
                this.process(rtPolyNode, expInsideList);
            }
        }

        private void processEqualityNode(RtPolyNode rtPolyNode, ExpInsideList expInsideList) {
            RtPolyNode rtPolyNode2;
            RtPolyNode rtPolyNode3 = rtPolyNode.getLeft();
            if (!rtPolyNode3.hasChildren() && rtPolyNode3.getType() == 6 && rtPolyNode3.getVariable().equalsIgnoreCase("class") && !(rtPolyNode2 = rtPolyNode.getRight()).hasChildren() && rtPolyNode2.getType() == 6) {
                int n = (int)rtPolyNode2.getNum();
                List<CatClass> list = this.categoryFactor.getClasses();
                CatClass catClass = list.get(n);
                if (catClass instanceof MicaGroups.MicaCatClass) {
                    MicaGroups.MicaCatClass micaCatClass = (MicaGroups.MicaCatClass)catClass;
                    for (int i = 0; i < list.size(); ++i) {
                        String string = list.get(i).getName();
                        if (!string.equals(micaCatClass.getName()) || expInsideList.contains(i, ExpInside.ExpSideEqual.class)) continue;
                        expInsideList.add(new ExpInside.ExpSideEqual(i));
                    }
                } else {
                    catClass = list.get(n);
                    if (catClass instanceof GroupCatClass) {
                        GroupCatClass groupCatClass = (GroupCatClass)catClass;
                        for (int i = 0; i < list.size(); ++i) {
                            String string = list.get(i).getName();
                            if (!string.equals(groupCatClass.getName()) || expInsideList.contains(i, ExpInside.ExpSideEqual.class)) continue;
                            expInsideList.add(new ExpInside.ExpSideEqual(i));
                        }
                    } else if (!expInsideList.contains(n, ExpInside.ExpSideEqual.class)) {
                        expInsideList.add(new ExpInside.ExpSideEqual(n));
                    }
                }
            }
        }

        private void processInequalityNode(RtPolyNode rtPolyNode, ExpInsideList expInsideList) {
            block4: {
                RtPolyNode rtPolyNode2;
                RtPolyNode rtPolyNode3 = rtPolyNode.getLeft();
                if (rtPolyNode3.hasChildren() || rtPolyNode3.getType() != 6 || !rtPolyNode3.getVariable().equalsIgnoreCase("class") || (rtPolyNode2 = rtPolyNode.getRight()).hasChildren() || rtPolyNode2.getType() != 6) break block4;
                int n = (int)rtPolyNode2.getNum();
                List<CatClass> list = this.categoryFactor.getClasses();
                CatClass catClass = list.get(n);
                if (catClass instanceof MicaGroups.MicaCatClass) {
                    MicaGroups.MicaCatClass micaCatClass = (MicaGroups.MicaCatClass)catClass;
                    for (int i = 0; i < list.size(); ++i) {
                        String string = list.get(i).getName();
                        if (string.equals(micaCatClass.getName()) || expInsideList.contains(i, ExpInside.ExpSideEqual.class)) continue;
                        expInsideList.add(new ExpInside.ExpSideEqual(i));
                    }
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        if (i == n || expInsideList.contains(i, ExpInside.ExpSideEqual.class)) continue;
                        expInsideList.add(new ExpInside.ExpSideEqual(i));
                    }
                }
            }
        }

        private void process(RtPolyNode rtPolyNode, ExpInsideList expInsideList) {
            RtPolyNode rtPolyNode2;
            RtPolyNode rtPolyNode3 = rtPolyNode.getLeft();
            if (!rtPolyNode3.hasChildren() && rtPolyNode3.getType() == 6 && rtPolyNode3.getVariable() != null && !(rtPolyNode2 = rtPolyNode.getRight()).hasChildren() && rtPolyNode2.getType() == 3) {
                int n = rtPolyNode.getType();
                if (n == 60) {
                    expInsideList.add(new ExpInside.ExpSideLess((float)rtPolyNode2.getNum()));
                } else if (n == 91) {
                    expInsideList.add(new ExpInside.ExpSideLessEquals((float)rtPolyNode2.getNum()));
                } else if (n == 62) {
                    expInsideList.add(new ExpInside.ExpSideGreater((float)rtPolyNode2.getNum()));
                } else if (n == 93) {
                    expInsideList.add(new ExpInside.ExpSideGreaterEquals((float)rtPolyNode2.getNum()));
                }
            }
        }
    }
}

