/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation.model;

import java.util.Arrays;
import java.util.List;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentationInfo;
import se.prediktera.breeze.common.realtime.segmentation.model.AbstractModelSegmentation;

public class ModelSegmentation
extends AbstractModelSegmentation {
    private final InverseParameter inverseParameter = new InverseParameter();

    public ModelSegmentation(AbstractSegmentationInfo abstractSegmentationInfo) {
        super(abstractSegmentationInfo);
        this.addParameter(this.inverseParameter);
        this.addOutput("value");
    }

    @Override
    public boolean isInverse() {
        return this.inverseParameter.getValueBool();
    }

    @Override
    public List<BasicAnalyse.ModelType> getModelTypes() {
        return List.of(BasicAnalyse.ModelType.Sample);
    }

    public static class InverseParameter
    extends BooleanParameter {
        public InverseParameter() {
            super("inverse", false);
        }
    }

    public static class Info
    extends AbstractSegmentationInfo {
        @Override
        public AbstractBreezeFunction createFunction() {
            return new ModelSegmentation(this);
        }

        public String toString() {
            return "ModelSegmentation";
        }

        @Override
        public String getName() {
            return "Model";
        }

        @Override
        public String getShortDescription() {
            return "Model";
        }

        @Override
        public String getDescription() {
            return "Separate sample from background";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Model;
        }

        @Override
        public String getImageIcon() {
            return "classification";
        }

        @Override
        public String getHelp() {
            return "model";
        }

        @Override
        public List<String> getKeywords() {
            return Arrays.asList("pca", "sample");
        }
    }
}

