/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation.spatial;

import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.OptionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextEditParameter;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentationInfo;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeTextEditButtonField;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.view.preview.CoordinateImagePanel;
import se.prediktera.breeze.frontend.common.view.preview.CropImagePanel;
import se.prediktera.map.common.error.Logg;

public class CoordinateSegmentation
extends AbstractSegmentation {
    public CoordinateSegmentation(AbstractSegmentationInfo abstractSegmentationInfo) {
        super(abstractSegmentationInfo);
        this.addParameter(new OrigoParameter(this, "origo", "Origo", "", ""));
        this.addParameter(new TextEditParameter("coordinate", "Coordinates", "0,0;50,0;50,50;0,50", "Example: x1,y1;x2,y2..."){

            @Override
            public void showDialog(BreezeFrame breezeFrame, Workflow workflow, Object object, BreezeTextEditButtonField breezeTextEditButtonField) {
                Measurement measurement = Measurement.getFirstMeasurementWithData(object);
                if (measurement == null) {
                    BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "No measurement", "No measurement in this Project to use as reference for edit coordinates");
                    return;
                }
                try {
                    BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Coordinates", "", (AbstractBreezeCustomPanel)new CoordinateImagePanel(CropImagePanel.readImage(measurement.getThumbnailFile()), CoordinateSegmentation.this.createCoordinates(breezeTextEditButtonField.getValue())), null, breezeActionEvent -> {
                        CoordinateImagePanel coordinateImagePanel = (CoordinateImagePanel)breezeActionEvent.getBreezeCustomPanel();
                        breezeTextEditButtonField.setValue(coordinateImagePanel.getCoordinateString());
                    });
                }
                catch (Exception exception) {
                    Logg.error((String)"Interval error", (Throwable)exception);
                }
            }
        });
        this.addParameter(new BooleanParameter("center", "Center around origo", "Center coordinate object around origo", false));
        this.addOutput("value");
    }

    private double[][] createCoordinates(String string) {
        String[] stringArray = string.split(";");
        double[][] dArrayArray = new double[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String[] stringArray2 = string2.split(",", 2);
            if (!RtDataFormat.isNumber(stringArray2[0]) || !RtDataFormat.isNumber(stringArray2[1])) continue;
            dArrayArray[i] = new double[]{RtDataFormat.toNumber(stringArray2[0]), RtDataFormat.toNumber(stringArray2[1])};
        }
        return dArrayArray;
    }

    @Override
    public String getOutputName(int n) {
        return "Segmentation";
    }

    private class OrigoParameter
    extends OptionParameter {
        public OrigoParameter(CoordinateSegmentation coordinateSegmentation, String string, String string2, String string3, String string4) {
            super(string, string2, string3, string4);
            this.add(new OptionParameter.Option("upperleft", "Upper left corner"));
            this.add(new OptionParameter.Option("center", "Parent object center"));
            this.add(new OptionParameter.Option("mass", "Parent object mass center"));
        }
    }

    public static class Info
    extends AbstractSegmentationInfo {
        @Override
        public String getImageIcon() {
            return "crosshair";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new CoordinateSegmentation(this);
        }

        public String toString() {
            return "CoordinateSegmentation";
        }

        @Override
        public String getName() {
            return "Coordinate";
        }

        @Override
        public String getDescription() {
            return "Pixel coordinates";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Spatial;
        }

        @Override
        public String getHelp() {
            return "pixel-coordinates";
        }
    }
}

