/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation.spatial;

import java.util.Arrays;
import java.util.List;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.usgs.DepthRegistrationPanel;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.map.register.RegInfo;

public class DepthDescriptor
extends AbstractDescriptor {
    public DepthDescriptor(AbstractDescriptorInfo abstractDescriptorInfo) {
        super(abstractDescriptorInfo);
        this.addParameter(new BooleanParameter("keepInterval", "Keep interval", "", true));
        this.addOutput("start");
        this.addOutput("end");
        this.addOutput("length");
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        String string = StringHelper.formatLabel(super.getNodeString(functionTreeNode, n, textType));
        return string + (n < 2 ? " depth" : "") + " (" + this.getWorkflowUnit() + ")";
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        return DepthRegistrationPanel.format(f);
    }

    @Override
    public String getUnit(FunctionTreeNode functionTreeNode, int n) {
        return this.getWorkflowUnit();
    }

    private String getWorkflowUnit() {
        Workflow workflow = this.getWorkflow();
        if (workflow != null) {
            return workflow.getDefaultUnit().getUnit();
        }
        return "";
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "depth";
        }

        @Override
        public DepthDescriptor createFunction() {
            return new DepthDescriptor(this);
        }

        public String toString() {
            return "Depth";
        }

        @Override
        public String getDescription() {
            return "Registration depth";
        }

        @Override
        public RegInfo.LicenseFeature getLicenseFeature() {
            return RegInfo.LicenseFeature.Geo;
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Geo;
        }

        @Override
        public String getHelp() {
            return "registration-depth";
        }

        @Override
        public List<String> getKeywords() {
            return Arrays.asList("start", "end", "length");
        }
    }
}

