/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation.spatial;

import java.util.HashMap;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.realtime.descriptor.usgs.DepthRegistrationPanel;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleRow;

public class DepthInterval {
    private SampleRow sampleRow = new SampleRow();
    public final double start;
    public final double end;
    public final double length;

    public DepthInterval(Sample sample) {
        this.sampleRow.add(sample);
        HashMap<String, String> hashMap = this.getNonEmptyAttributes(sample);
        this.start = RtDataFormat.toNumber(hashMap.get("start"));
        this.end = RtDataFormat.toNumber(hashMap.get("end"));
        this.length = this.end - this.start;
    }

    private HashMap<String, String> getNonEmptyAttributes(Sample sample) {
        Sample sample2 = sample;
        while (sample2 != null) {
            Sample sample3;
            HashMap<String, String> hashMap = sample2.getAttributes();
            if (hashMap != null && !hashMap.isEmpty()) {
                return hashMap;
            }
            BasicSample basicSample = sample2.getParent();
            if (!(basicSample instanceof Sample)) break;
            sample2 = sample3 = (Sample)basicSample;
        }
        return sample.getAttributes();
    }

    public DepthInterval(double d, double d2) {
        this.start = d;
        this.end = d2;
        this.length = d2 - d;
    }

    public SampleRow getSampleRow() {
        return this.sampleRow;
    }

    public void setSampleRow(SampleRow sampleRow) {
        this.sampleRow = sampleRow;
        for (Sample sample : this.sampleRow) {
            if (sample == null) continue;
            sample.setAttributes(this.getAttributes());
        }
    }

    public boolean contains(DepthInterval depthInterval) {
        double d = depthInterval.middle();
        return d >= this.start && d < this.end;
    }

    public boolean precedes(DepthInterval depthInterval) {
        return depthInterval.middle() >= this.end;
    }

    public double middle() {
        return this.start + this.length / 2.0;
    }

    public HashMap<String, String> getAttributes() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("start", RtDataFormat.toString(this.start));
        hashMap.put("end", RtDataFormat.toString(this.end));
        return hashMap;
    }

    public String toString() {
        return DepthRegistrationPanel.format(this.start) + "-" + DepthRegistrationPanel.format(this.end);
    }
}

